/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import org.eclipse.jkube.kit.build.api.assembly.AssemblyManager;
import org.eclipse.jkube.kit.build.service.docker.ArchiveService;
import org.eclipse.jkube.kit.build.service.docker.BuildService;
import org.eclipse.jkube.kit.build.service.docker.ContainerTracker;
import org.eclipse.jkube.kit.build.service.docker.DockerAccessFactory;
import org.eclipse.jkube.kit.build.service.docker.QueryService;
import org.eclipse.jkube.kit.build.service.docker.RegistryService;
import org.eclipse.jkube.kit.build.service.docker.RunService;
import org.eclipse.jkube.kit.build.service.docker.VolumeService;
import org.eclipse.jkube.kit.build.service.docker.WaitService;
import org.eclipse.jkube.kit.build.service.docker.WatchService;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogOutputSpecFactory;
import org.eclipse.jkube.kit.common.KitLogger;

public class DockerServiceHub {
    private final DockerAccess dockerAccess;
    private final QueryService queryService;
    private final RunService runService;
    private final RegistryService registryService;
    private final BuildService buildService;
    private final ArchiveService archiveService;
    private final VolumeService volumeService;
    private final WatchService watchService;
    private final WaitService waitService;

    public static DockerServiceHub newInstance(KitLogger kitLogger) {
        return DockerServiceHub.newInstance(kitLogger, new DockerAccessFactory().createDockerAccess(DockerAccessFactory.DockerAccessContext.getDefault(kitLogger)), new LogOutputSpecFactory(true, true));
    }

    public static DockerServiceHub newInstance(KitLogger kitLogger, DockerAccess dockerAccess, LogOutputSpecFactory logOutputSpecFactory) {
        return new DockerServiceHub(dockerAccess, ContainerTracker.getInstance(), AssemblyManager.getInstance(), kitLogger, logOutputSpecFactory);
    }

    DockerServiceHub(DockerAccess dockerAccess, ContainerTracker containerTracker, AssemblyManager assemblyManager, KitLogger logger, LogOutputSpecFactory logSpecFactory) {
        this.dockerAccess = dockerAccess;
        this.archiveService = new ArchiveService(assemblyManager, logger);
        if (dockerAccess != null) {
            this.queryService = new QueryService(dockerAccess);
            this.registryService = new RegistryService(dockerAccess, this.queryService, logger);
            this.runService = new RunService(dockerAccess, this.queryService, containerTracker, logSpecFactory, logger);
            this.buildService = new BuildService(dockerAccess, this.queryService, this.registryService, this.archiveService, logger);
            this.volumeService = new VolumeService(dockerAccess);
            this.watchService = new WatchService(this.archiveService, this.buildService, this.queryService, this.runService, logger);
            this.waitService = new WaitService(dockerAccess, this.queryService, logger);
        } else {
            this.queryService = null;
            this.registryService = null;
            this.runService = null;
            this.buildService = null;
            this.volumeService = null;
            this.watchService = null;
            this.waitService = null;
        }
    }

    public DockerAccess getDockerAccess() {
        return this.dockerAccess;
    }

    public BuildService getBuildService() {
        this.checkDockerAccessInitialization();
        return this.buildService;
    }

    public QueryService getQueryService() {
        this.checkDockerAccessInitialization();
        return this.queryService;
    }

    public RegistryService getRegistryService() {
        this.checkDockerAccessInitialization();
        return this.registryService;
    }

    public RunService getRunService() {
        this.checkDockerAccessInitialization();
        return this.runService;
    }

    public VolumeService getVolumeService() {
        this.checkDockerAccessInitialization();
        return this.volumeService;
    }

    public WatchService getWatchService() {
        this.checkDockerAccessInitialization();
        return this.watchService;
    }

    public WaitService getWaitService() {
        this.checkDockerAccessInitialization();
        return this.waitService;
    }

    public ArchiveService getArchiveService() {
        return this.archiveService;
    }

    private synchronized void checkDockerAccessInitialization() {
        if (this.dockerAccess == null) {
            throw new IllegalStateException("Service hub created without a docker access to a docker daemon");
        }
    }
}

