/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot.enricher;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import java.net.URLClassLoader;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.SpringBootConfigurationHelper;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;

public class SpringBootHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    public static final String ENRICHER_NAME = "jkube-healthcheck-spring-boot";
    protected static final String[] REQUIRED_CLASSES = new String[]{"org.springframework.boot.actuate.health.HealthIndicator", "org.springframework.web.context.support.GenericWebApplicationContext"};
    private static final String SCHEME_HTTPS = "HTTPS";
    private static final String SCHEME_HTTP = "HTTP";

    public SpringBootHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
    }

    protected Probe getReadinessProbe() {
        Integer initialDelay = Configs.asInteger((String)this.getConfig(Config.readinessProbeInitialDelaySeconds));
        Integer period = Configs.asInteger((String)this.getConfig(Config.readinessProbePeriodSeconds));
        Integer timeout = Configs.asInteger((String)this.getConfig(Config.timeoutSeconds));
        Integer failureThreshold = Configs.asInteger((String)this.getConfig(Config.failureThreshold));
        Integer successThreshold = Configs.asInteger((String)this.getConfig(Config.successThreshold));
        return this.discoverSpringBootHealthCheck(initialDelay, period, timeout, failureThreshold, successThreshold);
    }

    protected Probe getLivenessProbe() {
        Integer initialDelay = Configs.asInteger((String)this.getConfig(Config.livenessProbeInitialDelaySeconds));
        Integer period = Configs.asInteger((String)this.getConfig(Config.livenessProbePeriodSeconds));
        Integer timeout = Configs.asInteger((String)this.getConfig(Config.timeoutSeconds));
        Integer failureThreshold = Configs.asInteger((String)this.getConfig(Config.failureThreshold));
        Integer successThreshold = Configs.asInteger((String)this.getConfig(Config.successThreshold));
        return this.discoverSpringBootHealthCheck(initialDelay, period, timeout, failureThreshold, successThreshold);
    }

    protected Probe discoverSpringBootHealthCheck(Integer initialDelay, Integer period, Integer timeout, Integer failureTh, Integer successTh) {
        try {
            if (this.getContext().getProjectClassLoaders().isClassInCompileClasspath(true, REQUIRED_CLASSES)) {
                Properties properties = SpringBootUtil.getSpringBootApplicationProperties((URLClassLoader)this.getContext().getProjectClassLoaders().getCompileClassLoader());
                return this.buildProbe(properties, initialDelay, period, timeout, failureTh, successTh);
            }
        }
        catch (Exception ex) {
            this.log.error("Error while reading the spring-boot configuration", new Object[]{ex});
        }
        return null;
    }

    protected Probe buildProbe(Properties springBootProperties, Integer initialDelay, Integer period, Integer timeout, Integer failureTh, Integer successTh) {
        String prefix;
        String scheme;
        SpringBootConfigurationHelper propertyHelper = new SpringBootConfigurationHelper(this.getContext().getDependencyVersion("org.springframework.boot", "spring-boot"));
        Integer managementPort = propertyHelper.getManagementPort(springBootProperties);
        boolean usingManagementPort = managementPort != null;
        Integer port = managementPort;
        if (port == null) {
            port = propertyHelper.getServerPort(springBootProperties);
        }
        if (usingManagementPort) {
            scheme = StringUtils.isNotBlank((CharSequence)springBootProperties.getProperty(propertyHelper.getManagementKeystorePropertyKey())) ? SCHEME_HTTPS : SCHEME_HTTP;
            prefix = springBootProperties.getProperty(propertyHelper.getManagementContextPathPropertyKey(), "");
        } else {
            scheme = StringUtils.isNotBlank((CharSequence)springBootProperties.getProperty(propertyHelper.getServerKeystorePropertyKey())) ? SCHEME_HTTPS : SCHEME_HTTP;
            prefix = springBootProperties.getProperty(propertyHelper.getServerContextPathPropertyKey(), "");
            prefix = prefix + springBootProperties.getProperty(propertyHelper.getServletPathPropertyKey(), "");
            prefix = prefix + springBootProperties.getProperty(propertyHelper.getManagementContextPathPropertyKey(), "");
        }
        String actuatorBasePathKey = propertyHelper.getActuatorBasePathPropertyKey();
        String actuatorBasePath = propertyHelper.getActuatorDefaultBasePath();
        if (actuatorBasePathKey != null) {
            actuatorBasePath = springBootProperties.getProperty(actuatorBasePathKey, actuatorBasePath);
        }
        ProbeBuilder probeBuilder = (ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(port)).withPath(this.normalizeMultipleSlashes(prefix + actuatorBasePath + Configs.asString((String)this.getConfig(Config.path))))).withScheme(scheme)).endHttpGet();
        if (initialDelay != null) {
            probeBuilder = (ProbeBuilder)probeBuilder.withInitialDelaySeconds(initialDelay);
        }
        if (period != null) {
            probeBuilder = (ProbeBuilder)probeBuilder.withPeriodSeconds(period);
        }
        if (timeout != null) {
            probeBuilder.withTimeoutSeconds(timeout);
        }
        if (failureTh != null) {
            probeBuilder.withFailureThreshold(failureTh);
        }
        if (successTh != null) {
            probeBuilder.withSuccessThreshold(successTh);
        }
        return probeBuilder.build();
    }

    private String normalizeMultipleSlashes(String s) {
        return s.replaceAll("/{2,}", "/");
    }

    private static enum Config implements Configs.Key
    {
        readinessProbeInitialDelaySeconds{
            {
                this.d = "10";
            }
        }
        ,
        readinessProbePeriodSeconds,
        path{
            {
                this.d = "/health";
            }
        }
        ,
        livenessProbeInitialDelaySeconds{
            {
                this.d = "180";
            }
        }
        ,
        livenessProbePeriodSeconds,
        failureThreshold{
            {
                this.d = "3";
            }
        }
        ,
        successThreshold{
            {
                this.d = "1";
            }
        }
        ,
        timeoutSeconds;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

