/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.GeneratorMode;
import org.eclipse.jkube.kit.build.service.docker.ServiceHub;
import org.eclipse.jkube.kit.build.service.docker.WatchService;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.AnsiLogger;
import org.eclipse.jkube.kit.common.util.MavenUtil;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.config.image.build.JKubeConfiguration;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.profile.ProfileUtil;
import org.eclipse.jkube.maven.plugin.mojo.ManifestProvider;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractDockerMojo;
import org.eclipse.jkube.maven.plugin.watcher.WatcherManager;
import org.eclipse.jkube.watcher.api.WatcherContext;

@Mojo(name="watch", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
@Execute(goal="deploy")
public class WatchMojo
extends AbstractDockerMojo
implements ManifestProvider {
    @Parameter(property="jkube.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/kubernetes.yml")
    private File kubernetesManifest;
    @Parameter
    private ProcessorConfig watcher;
    private KubernetesClient kubernetesClient;

    @Override
    public File getKubernetesManifest() {
        return this.kubernetesManifest;
    }

    @Override
    protected void init() {
        super.init();
        this.kubernetesClient = this.clusterAccess.createDefaultClient();
    }

    @Override
    public void executeInternal() throws MojoExecutionException {
        URL masterUrl = this.kubernetesClient.getMasterUrl();
        KubernetesResourceUtil.validateKubernetesMasterUrl((URL)masterUrl);
        try {
            Set resources = KubernetesResourceUtil.loadResources((File)this.getManifest(this.kubernetesClient));
            WatcherContext context = this.getWatcherContext();
            WatcherManager.watch(this.getResolvedImages(), resources, context);
        }
        catch (KubernetesClientException ex) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)ex, (KitLogger)this.log);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("An error has occurred while while trying to watch the resources", ex);
        }
    }

    private WatcherContext getWatcherContext() throws MojoExecutionException {
        try {
            JKubeConfiguration buildContext = this.initJKubeConfiguration();
            WatchService.WatchContext watchContext = this.jkubeServiceHub.getDockerServiceHub() != null ? this.getWatchContext() : null;
            return WatcherContext.builder().buildContext(buildContext).watchContext(watchContext).config(this.extractWatcherConfig()).logger(this.log).newPodLogger(this.createLogger("[[C]][NEW][[C]] ")).oldPodLogger(this.createLogger("[[R]][OLD][[R]] ")).useProjectClasspath(this.useProjectClasspath).jKubeServiceHub(this.jkubeServiceHub).build();
        }
        catch (IOException exception) {
            throw new MojoExecutionException(exception.getMessage());
        }
        catch (DependencyResolutionRequiredException dependencyException) {
            throw new MojoExecutionException("Instructed to use project classpath, but cannot. Continuing build if we can: " + dependencyException.getMessage());
        }
    }

    @Override
    protected GeneratorContext.GeneratorContextBuilder generatorContextBuilder() throws DependencyResolutionRequiredException {
        return GeneratorContext.builder().config(this.extractGeneratorConfig()).project(MavenUtil.convertMavenProjectToJKubeProject((MavenProject)this.project, (MavenSession)this.session)).logger(this.log).runtimeMode(this.getConfiguredRuntimeMode()).useProjectClasspath(this.useProjectClasspath).artifactResolver(this.jkubeServiceHub.getArtifactResolverService()).generatorMode(GeneratorMode.WATCH);
    }

    private ProcessorConfig extractWatcherConfig() {
        try {
            return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.WATCHER_CONFIG, (String)this.profile, (File)ResourceUtil.getFinalResourceDir((File)this.resourceDir, (String)this.environment), (ProcessorConfig)this.watcher);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot extract watcher config: " + e, e);
        }
    }

    protected KitLogger createLogger(String prefix) {
        return new AnsiLogger(this.getLog(), this.useColor, this.verbose, this.settings.getInteractiveMode() == false, this.getLogPrefix() + prefix);
    }

    protected WatchService.WatchContext getWatchContext() throws IOException, DependencyResolutionRequiredException {
        ServiceHub hub = this.jkubeServiceHub.getDockerServiceHub();
        return WatchService.WatchContext.builder().watchInterval(this.watchInterval).watchMode(this.watchMode).watchPostGoal(this.watchPostGoal).watchPostExec(this.watchPostExec).autoCreateCustomNetworks(this.autoCreateCustomNetworks).keepContainer(this.keepContainer).keepRunning(this.keepRunning).removeVolumes(this.removeVolumes).containerNamePattern(this.containerNamePattern).buildTimestamp(this.getBuildTimestamp()).gavLabel(this.getGavLabel()).buildContext(this.initJKubeConfiguration()).follow(this.watchFollow).showLogs(this.watchShowLogs).serviceHubFactory(this.serviceHubFactory).hub(hub).dispatcher(this.getLogDispatcher(hub)).build();
    }
}

