/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pass.file.service;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.pass.file.service.storage.FileStorageService;
import org.eclipse.pass.file.service.storage.StorageFile;
import org.eclipse.pass.object.security.WebSecurityRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class PassFileServiceController {
    private static final Logger LOG = LoggerFactory.getLogger(PassFileServiceController.class);
    private final FileStorageService fileStorageService;

    public PassFileServiceController(FileStorageService fileStorageService) {
        this.fileStorageService = fileStorageService;
    }

    @PostMapping(value={"/file"})
    public ResponseEntity<?> fileUpload(@RequestParam(value="file") MultipartFile file, Principal principal) {
        StorageFile returnStorageFile;
        try {
            if (file.getBytes().length == 0 || file.isEmpty()) {
                return ResponseEntity.badRequest().build();
            }
        }
        catch (IOException e) {
            LOG.error("File Service: Error processing file upload: " + e);
            return ResponseEntity.badRequest().build();
        }
        try {
            returnStorageFile = this.fileStorageService.storeFile(file, principal.getName());
        }
        catch (IOException e) {
            LOG.error("File Service: Error storing file upload: " + e);
            return ResponseEntity.internalServerError().build();
        }
        return ResponseEntity.created((URI)URI.create(returnStorageFile.getUuid())).body((Object)returnStorageFile);
    }

    @GetMapping(value={"/file/{uuid:.+}/{origFileName:.+}"})
    @ResponseBody
    public ResponseEntity<?> getFileById(@PathVariable(value="uuid") String uuid, @PathVariable(value="origFileName") String origFileName) {
        ByteArrayResource fileResource;
        String fileId = uuid + "/" + origFileName;
        if (StringUtils.isEmpty((CharSequence)uuid) || StringUtils.isEmpty((CharSequence)origFileName)) {
            LOG.error("File ID not provided to get a file.");
            return ResponseEntity.badRequest().body((Object)"File ID not provided to get a file.");
        }
        String contentType = "";
        try {
            contentType = this.fileStorageService.getFileContentType(fileId);
            fileResource = this.fileStorageService.getFile(fileId);
        }
        catch (Exception e) {
            LOG.error("File Service: File not found: " + e);
            return ResponseEntity.notFound().build();
        }
        String headerAttachment = "attachment; filename=\"" + origFileName + "\"";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{headerAttachment})).contentLength(fileResource.contentLength()).contentType(MediaType.parseMediaType((String)contentType)).body((Object)fileResource);
    }

    @DeleteMapping(value={"/file/{uuid:.+}/{origFileName:.+}"})
    public ResponseEntity<?> deleteFileById(@PathVariable(value="uuid") String uuid, @PathVariable(value="origFileName") String origFileName, Principal principal, HttpServletRequest request) {
        String principalName = principal.getName();
        String fileId = uuid + "/" + origFileName;
        try {
            this.fileStorageService.getFile(fileId);
        }
        catch (Exception e) {
            LOG.error("File Service: File not found: " + e);
            return ResponseEntity.notFound().build();
        }
        return this.canUserDeleteFile(principalName, fileId, request) ? this.deleteFile(fileId) : ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"User does not have permission to delete this file.");
    }

    private boolean canUserDeleteFile(String principalName, String fileId, HttpServletRequest request) {
        try {
            boolean hasDeletePermission = this.fileStorageService.checkUserDeletePermissions(fileId, principalName);
            return hasDeletePermission || request.isUserInRole(WebSecurityRole.BACKEND.getValue());
        }
        catch (Exception e) {
            LOG.error("File Service: Unable to determine user permissions to delete file: " + e);
            return false;
        }
    }

    private ResponseEntity<?> deleteFile(String fileId) {
        try {
            this.fileStorageService.deleteFile(fileId);
            return ResponseEntity.ok().body((Object)"Deleted");
        }
        catch (Exception e) {
            LOG.error("File Service: Unable to delete file: " + e);
            return ResponseEntity.badRequest().build();
        }
    }
}

