/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pass.file.service.storage;

import io.ocfl.api.OcflOption;
import io.ocfl.api.OcflRepository;
import io.ocfl.api.exception.NotFoundException;
import io.ocfl.api.model.FileDetails;
import io.ocfl.api.model.ObjectVersionId;
import io.ocfl.api.model.User;
import io.ocfl.api.model.VersionDetails;
import io.ocfl.api.model.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.pass.file.service.storage.StorageFile;
import org.eclipse.pass.file.service.storage.StorageProperties;
import org.eclipse.pass.file.service.storage.StorageServiceType;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Service;
import org.springframework.util.FileSystemUtils;
import org.springframework.web.multipart.MultipartFile;

@Lazy
@Service
public class FileStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(FileStorageService.class);
    private final OcflRepository ocflRepository;
    private final Path tempLoc;
    private final StorageServiceType storageType;

    public FileStorageService(OcflRepository ocflRepository, StorageProperties storageProperties, Path rootLoc) {
        this.ocflRepository = ocflRepository;
        this.tempLoc = Paths.get(rootLoc.toString(), storageProperties.getStorageTempDir());
        this.storageType = storageProperties.getStorageType();
    }

    public StorageFile storeFile(MultipartFile mFile, String userName) throws IOException {
        StorageFile storageFile;
        try {
            String origFileNameExt = Jsoup.clean((String)Objects.requireNonNull(mFile.getOriginalFilename()), (Safelist)Safelist.basic());
            String fileExt = FilenameUtils.getExtension((String)origFileNameExt);
            String fileUuid = UUID.randomUUID().toString();
            String fileId = fileUuid + "/" + origFileNameExt;
            String mimeType = URLConnection.guessContentTypeFromName(origFileNameExt);
            String ocflRepoFileName = StringUtils.isNotEmpty((CharSequence)fileExt) ? fileUuid + "." + fileExt : fileUuid;
            Path pathTempLoc = Paths.get(this.tempLoc.toString(), new String[0]);
            User fileUser = new User();
            fileUser.setName(userName);
            if (!Files.exists(pathTempLoc, new LinkOption[0])) {
                Files.createDirectory(pathTempLoc, new FileAttribute[0]);
            }
            Path tempPathAndFileName = Paths.get(this.tempLoc.toString(), ocflRepoFileName);
            mFile.transferTo(tempPathAndFileName);
            this.ocflRepository.putObject(ObjectVersionId.head((String)fileId), tempPathAndFileName, new VersionInfo().setMessage("Pass-Core File Service: Initial commit").setUser(fileUser), new OcflOption[0]);
            String fileRepoRelPath = ((FileDetails)this.ocflRepository.describeVersion(ObjectVersionId.head((String)fileId)).getFileMap().entrySet().iterator().next().getValue()).getStorageRelativePath();
            LOG.info("File Service: File with ID " + fileId + " was stored in the system repo at location: location:" + fileRepoRelPath);
            storageFile = new StorageFile(fileId, fileUuid, origFileNameExt, mimeType, this.storageType.label, mFile.getSize(), fileExt);
            Files.delete(tempPathAndFileName);
        }
        catch (IOException e) {
            LOG.error("Error storing file", (Throwable)e);
            throw new IOException("File Service: The file system was unable to store the uploaded file", e);
        }
        return storageFile;
    }

    public ByteArrayResource getFile(String fileId) throws IOException {
        ByteArrayResource loadedResource;
        Path tempLoadDir = Paths.get(this.tempLoc.toString(), "output", fileId.split("/")[0], Instant.now().toString().replace(":", "-").replace(".", "-"));
        Path tempLoadParentDir = Paths.get(this.tempLoc.toString(), "output", fileId.split("/")[0]);
        try {
            if (!Files.exists(tempLoadParentDir, new LinkOption[0])) {
                Files.createDirectories(tempLoadParentDir, new FileAttribute[0]);
            }
            this.ocflRepository.getObject(ObjectVersionId.head((String)fileId), tempLoadDir);
            LOG.debug("File Service: File with ID " + fileId + " was loaded from the repo");
            Path fileNamePath = Objects.requireNonNull(tempLoadDir.toFile().listFiles())[0].toPath();
            loadedResource = new ByteArrayResource(Files.readAllBytes(fileNamePath));
        }
        catch (NotFoundException e) {
            throw new IOException("File Service: The file could not be loaded, file ID: " + fileId + " " + e);
        }
        if (loadedResource.exists() && loadedResource.isReadable()) {
            if (!FileSystemUtils.deleteRecursively((Path)Paths.get(this.tempLoc.toString(), new String[0]))) {
                LOG.debug("File Service: No files to cleanup on file get");
            }
            return loadedResource;
        }
        throw new IOException("File Service: Unable to return the file. Verify read/write permissions of the temp directory.");
    }

    public void deleteFile(String fileId) {
        this.ocflRepository.purgeObject(fileId);
    }

    public String getResourceFileRelativePath(String fileId) throws IOException {
        VersionDetails versionDetails = this.ocflRepository.describeVersion(ObjectVersionId.head((String)fileId));
        Collection allVersionFiles = versionDetails.getFiles();
        return ((FileDetails)allVersionFiles.stream().findFirst().orElseThrow(() -> new IOException("The relative path could not be found for file ID: " + fileId))).getStorageRelativePath();
    }

    public String getFileContentType(String fileId) {
        try {
            VersionDetails versionDetails = this.ocflRepository.describeVersion(ObjectVersionId.head((String)fileId));
            FileDetails fileDetails = (FileDetails)versionDetails.getFiles().stream().findFirst().orElseThrow(() -> new IOException("The content type could not be found for file ID: " + fileId));
            Path fileDetailPath = Paths.get(fileDetails.getPath(), new String[0]);
            File file = fileDetailPath.toFile();
            String type = Files.probeContentType(file.toPath());
            if (type == null) {
                type = "application/octet-stream";
            }
            return type;
        }
        catch (IOException e) {
            LOG.error("File Service: Unable to determine the content type of the file with ID: " + fileId, (Throwable)e);
            return "application/octet-stream";
        }
    }

    public boolean checkUserDeletePermissions(String fileId, String userId) {
        return userId.equals(this.getFileOwner(fileId));
    }

    public String getFileOwner(String fileId) {
        VersionInfo versionInfo = this.ocflRepository.describeVersion(ObjectVersionId.head((String)fileId)).getVersionInfo();
        return versionInfo.getUser().getName();
    }
}

