/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pass.file.service.storage;

import io.ocfl.api.OcflRepository;
import io.ocfl.aws.OcflS3Client;
import io.ocfl.core.OcflRepositoryBuilder;
import io.ocfl.core.extension.OcflExtensionConfig;
import io.ocfl.core.extension.storage.layout.config.HashedNTupleLayoutConfig;
import io.ocfl.core.path.constraint.ContentPathConstraints;
import io.ocfl.core.storage.cloud.CloudClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.pass.file.service.storage.StorageProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;

@Configuration
@EnableConfigurationProperties(value={StorageProperties.class})
public class StorageConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(StorageConfiguration.class);
    @Value(value="${aws.region}")
    private String awsRegion;

    @Bean
    @ConditionalOnProperty(name={"pass.file-service.storage-type"}, havingValue="S3")
    public S3Client s3Client(StorageProperties storageProperties) throws IOException {
        S3Client s3Client;
        String bucketName = storageProperties.getBucketName().orElseThrow(() -> new IOException("File Service: S3 bucket name is not set"));
        S3ClientBuilder builder = (S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).region(Region.of((String)this.awsRegion));
        String endpoint = storageProperties.getS3Endpoint().orElse(null);
        S3Client s3Client2 = s3Client = StringUtils.isNotBlank((CharSequence)endpoint) ? (S3Client)((S3ClientBuilder)((S3ClientBuilder)builder.endpointOverride(URI.create(endpoint))).forcePathStyle(Boolean.valueOf(true))).build() : (S3Client)builder.build();
        if (s3Client.listBuckets().buckets().stream().noneMatch(b -> b.name().equals(bucketName))) {
            s3Client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build());
        }
        return s3Client;
    }

    @Bean
    @ConditionalOnProperty(name={"pass.file-service.storage-type"}, havingValue="S3")
    public OcflRepository ocflS3Repository(S3Client s3Client, StorageProperties storageProperties, @Qualifier(value="rootPath") Path rootLoc) throws IOException {
        String bucketName = storageProperties.getBucketName().orElseThrow(() -> new IOException("File Service: S3 bucket name is not set"));
        String repoPrefix = storageProperties.getS3RepoPrefix().orElse(null);
        OcflS3Client.Builder builder = OcflS3Client.builder().s3Client(s3Client).bucket(bucketName);
        OcflS3Client ocflS3Client = StringUtils.isNotBlank((CharSequence)repoPrefix) ? builder.repoPrefix(repoPrefix).build() : builder.build();
        Path workLoc = this.ocflWorkingDir(storageProperties, rootLoc);
        OcflRepository ocflRepository = new OcflRepositoryBuilder().defaultLayoutConfig((OcflExtensionConfig)new HashedNTupleLayoutConfig()).contentPathConstraints(ContentPathConstraints.cloud()).storage(storage -> storage.cloud((CloudClient)ocflS3Client)).workDir(workLoc).build();
        LOG.info("File Service: S3 OCFL is configured and OCFL repository is built");
        return ocflRepository;
    }

    @Bean
    @ConditionalOnProperty(name={"pass.file-service.storage-type"}, havingValue="FILE_SYSTEM")
    public OcflRepository ocflFileRepository(StorageProperties storageProperties, @Qualifier(value="rootPath") Path rootLoc) throws IOException {
        Path ocflLoc = Paths.get(rootLoc.toString(), storageProperties.getStorageOcflDir());
        if (!Files.exists(ocflLoc, new LinkOption[0])) {
            Files.createDirectory(ocflLoc, new FileAttribute[0]);
        }
        if (!Files.isReadable(ocflLoc) || !Files.isWritable(ocflLoc)) {
            throw new IOException("File Service: No permission to read/write OCFL directory.");
        }
        Path workLoc = this.ocflWorkingDir(storageProperties, rootLoc);
        OcflRepository ocflRepository = new OcflRepositoryBuilder().defaultLayoutConfig((OcflExtensionConfig)new HashedNTupleLayoutConfig()).storage(storage -> storage.fileSystem(ocflLoc)).workDir(workLoc).build();
        LOG.info("File Service: File Service OCFL is configured and OCFL repository is built");
        return ocflRepository;
    }

    @Bean
    @Qualifier(value="rootPath")
    public Path rootPath(StorageProperties storageProperties) throws IOException {
        Path rootLoc;
        if (StringUtils.isBlank((CharSequence)storageProperties.getStorageRootDir())) {
            rootLoc = Files.createTempDirectory(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), null, new FileAttribute[0]);
            storageProperties.setRootDir(rootLoc.toString().substring(rootLoc.toString().lastIndexOf(File.separator) + 1));
        } else {
            rootLoc = Paths.get(storageProperties.getStorageRootDir(), new String[0]);
        }
        LOG.info("File Service: " + rootLoc + " Storage Root Directory");
        return rootLoc;
    }

    private Path ocflWorkingDir(StorageProperties storageProperties, Path rootLoc) throws IOException {
        Path workLoc = Paths.get(rootLoc.toString(), storageProperties.getStorageWorkDir());
        try {
            if (!Files.exists(rootLoc, new LinkOption[0])) {
                Files.createDirectory(rootLoc, new FileAttribute[0]);
            }
            if (!Files.exists(workLoc, new LinkOption[0])) {
                Files.createDirectory(workLoc, new FileAttribute[0]);
            }
            if (!Files.isReadable(workLoc) || !Files.isWritable(workLoc)) {
                throw new IOException("File Service: No permission to read/write work directory.");
            }
            if (!Files.isReadable(rootLoc) || !Files.isWritable(rootLoc)) {
                throw new IOException("File Service: No permission to read/write File Service root directory.");
            }
        }
        catch (IOException e) {
            throw new IOException("File Service: Unable to setup File Storage directories: " + e);
        }
        return workLoc;
    }
}

