/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pass.file.service.storage;

import java.util.Optional;
import org.eclipse.pass.file.service.storage.StorageServiceType;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="pass.file-service")
public class StorageProperties {
    private static final String OCFL_DIR = "ocfl";
    private static final String OCFL_WORK_DIR = "ocfl-work";
    private static final String TEMP_DIR = "temp";
    private String rootDir;
    private StorageServiceType storageType;
    private String s3BucketName;
    private String s3Endpoint;
    private String s3RepoPrefix;

    public String getStorageRootDir() {
        return this.rootDir;
    }

    public String getStorageOcflDir() {
        return OCFL_DIR;
    }

    public String getStorageWorkDir() {
        return OCFL_WORK_DIR;
    }

    public String getStorageTempDir() {
        return TEMP_DIR;
    }

    public StorageServiceType getStorageType() {
        return this.storageType;
    }

    public Optional<String> getS3RepoPrefix() {
        return Optional.ofNullable(this.s3RepoPrefix);
    }

    public Optional<String> getBucketName() {
        return Optional.of(this.s3BucketName);
    }

    public Optional<String> getS3Endpoint() {
        return Optional.ofNullable(this.s3Endpoint);
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public void setStorageType(StorageServiceType storageType) {
        this.storageType = storageType;
    }

    public void setS3BucketName(String bucketName) {
        this.s3BucketName = bucketName;
    }

    public void setS3RepoPrefix(String s3RepoPrefix) {
        this.s3RepoPrefix = s3RepoPrefix;
    }

    public void setS3Endpoint(String endpoint) {
        this.s3Endpoint = endpoint;
    }
}

