/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.benchmark;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.inferencer.fc.ForwardChainingRDFSInferencer;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public class ReasoningBenchmark {
    private int expectedCount;
    @Param(value={"moreRdfs::12180", "longChain::5803", "medium::544", "simple::152"})
    public String param;

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void noReasoning() throws IOException {
        SailRepository sail = new SailRepository((Sail)new MemoryStore());
        sail.initialize();
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            this.addAllDataSingleTransaction(connection);
            connection.commit();
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void noReasoningMultipleTransactions() throws IOException {
        SailRepository sail = new SailRepository((Sail)new MemoryStore());
        sail.initialize();
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
            this.addAllDataMultipleTransactions(connection);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingRDFSInferencer() throws IOException {
        SailRepository sail = new SailRepository((Sail)new ForwardChainingRDFSInferencer((NotifyingSail)new MemoryStore()));
        sail.initialize();
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            this.addAllDataSingleTransaction(connection);
            connection.commit();
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingRDFSInferencerMultipleTransactions() throws IOException {
        SailRepository sail = new SailRepository((Sail)new ForwardChainingRDFSInferencer((NotifyingSail)new MemoryStore()));
        sail.initialize();
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
            this.addAllDataMultipleTransactions(connection);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingSchemaCachingRDFSInferencer() throws IOException {
        SailRepository sail = new SailRepository((Sail)new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore()));
        sail.initialize();
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            this.addAllDataSingleTransaction(connection);
            connection.commit();
        }
        this.checkSize(sail);
    }

    private void checkSize(SailRepository sail) {
        assert (this.getSize(sail) == this.expectedCount) : "Was " + this.getSize(sail) + " but expected " + this.expectedCount;
    }

    /*
     * Exception decompiling
     */
    private int getSize(SailRepository sail) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingSchemaCachingRDFSInferencerMultipleTransactions() throws IOException {
        SailRepository sail = new SailRepository((Sail)new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore()));
        sail.initialize();
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            connection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
            this.addAllDataMultipleTransactions(connection);
        }
        this.checkSize(sail);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingSchemaCachingRDFSInferencerSchema() throws IOException {
        SailRepository sail = new SailRepository((Sail)new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore(), (Repository)this.createSchema()));
        sail.initialize();
        try (SailRepositoryConnection connection = sail.getConnection();){
            connection.begin();
            this.addAllDataSingleTransaction(connection);
            connection.commit();
        }
        this.checkSize(sail);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void forwardChainingSchemaCachingRDFSInferencerMultipleTransactionsSchema() throws IOException {
        SailRepository sail = new SailRepository((Sail)new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore(), (Repository)this.createSchema()));
        sail.initialize();
        try (SailRepositoryConnection connection = sail.getConnection();){
            this.addAllDataMultipleTransactions(connection);
        }
        this.checkSize(sail);
    }

    private SailRepository createSchema() throws IOException {
        SailRepository schema = new SailRepository((Sail)new MemoryStore());
        schema.initialize();
        try (SailRepositoryConnection schemaConnection = schema.getConnection();){
            schemaConnection.begin();
            schemaConnection.add(this.resourceAsStream("schema.ttl"), "", RDFFormat.TURTLE, new Resource[0]);
            schemaConnection.commit();
        }
        return schema;
    }

    private void addAllDataSingleTransaction(SailRepositoryConnection connection) throws IOException {
        InputStream data = this.resourceAsStream("data.ttl");
        if (data != null) {
            connection.add(data, "", RDFFormat.TURTLE, new Resource[0]);
        }
        int counter = 0;
        while ((data = this.resourceAsStream("data" + counter++ + ".ttl")) != null) {
            connection.add(data, "", RDFFormat.TURTLE, new Resource[0]);
        }
    }

    private void addAllDataMultipleTransactions(SailRepositoryConnection connection) throws IOException {
        InputStream data = this.resourceAsStream("data.ttl");
        if (data != null) {
            connection.begin();
            connection.add(data, "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
        }
        int counter = 0;
        while ((data = this.resourceAsStream("data" + counter++ + ".ttl")) != null) {
            connection.begin();
            connection.add(data, "", RDFFormat.TURTLE, new Resource[0]);
            connection.commit();
        }
    }

    private InputStream resourceAsStream(String resourceName) {
        String[] split = this.param.split("\\:\\:");
        this.expectedCount = Integer.parseInt(split[1]);
        return ReasoningBenchmark.class.getClassLoader().getResourceAsStream(split[0] + "/" + resourceName);
    }
}

