/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.net;

import java.io.Serializable;
import java.net.IDN;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;

public class ParsedIRI
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5681843777254402303L;
    private static final Comparator<int[]> CMP = (o1, o2) -> o1[0] - o2[0];
    private static int EOF = 0;
    private static int[][] iprivate = new int[][]{{57344, 63743}, {983040, 1048573}, {0x100000, 1114109}};
    private static int[][] ucschar = new int[][]{{160, 55295}, {63744, 64975}, {65008, 65519}, {65536, 131069}, {131072, 196605}, {196608, 262141}, {262144, 327677}, {327680, 393213}, {393216, 458749}, {458752, 524285}, {524288, 589821}, {589824, 655357}, {655360, 720893}, {720896, 786429}, {786432, 851965}, {851968, 917501}, {921600, 983037}};
    private static int[][] ALPHA = new int[][]{{65, 90}, {97, 122}};
    private static int[][] DIGIT = new int[][]{{48, 57}};
    private static int[][] sub_delims = ParsedIRI.union(Character.valueOf('!'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('='));
    private static int[][] gen_delims = ParsedIRI.union(Character.valueOf(':'), Character.valueOf('/'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('@'));
    private static int[][] reserved = ParsedIRI.union(new Object[]{gen_delims, sub_delims});
    private static int[][] unreserved_rfc3986 = ParsedIRI.union(new Object[]{ALPHA, DIGIT, Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~')});
    private static int[][] unreserved = ParsedIRI.union(new Object[]{unreserved_rfc3986, ucschar});
    private static int[][] schar = ParsedIRI.union(new Object[]{ALPHA, DIGIT, Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.')});
    private static int[][] uchar = ParsedIRI.union(new Object[]{unreserved, sub_delims, Character.valueOf(':')});
    private static int[][] hchar = ParsedIRI.union(new Object[]{unreserved, sub_delims});
    private static int[][] pchar = ParsedIRI.union(new Object[]{unreserved, sub_delims, Character.valueOf(':'), Character.valueOf('@')});
    private static int[][] qchar = ParsedIRI.union(new Object[]{pchar, iprivate, Character.valueOf('/'), Character.valueOf('?')});
    private static int[][] fchar = ParsedIRI.union(new Object[]{pchar, Character.valueOf('/'), Character.valueOf('?')});
    private static int[] HEXDIG = ParsedIRI.flatten(ParsedIRI.union(new Object[]{DIGIT, new int[][]{{65, 70}, {97, 102}}}));
    private static int[] ascii = ParsedIRI.flatten(ParsedIRI.union(new Object[]{unreserved_rfc3986, reserved, Character.valueOf('%')}));
    private static int[] common = ParsedIRI.flatten(ParsedIRI.union(new Object[]{unreserved_rfc3986, reserved, Character.valueOf('%'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\"'), Character.valueOf(' '), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('`')}));
    private static String[] common_pct = ParsedIRI.pctEncode(common);
    private final String iri;
    private int pos;
    private String scheme;
    private String userInfo;
    private String host;
    private int port = -1;
    private String path;
    private String query;
    private String fragment;

    private static int[][] union(Object ... sets) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object set : sets) {
            if (set instanceof int[][]) {
                int[][] ar = (int[][])set;
                list.addAll(Arrays.asList(ar));
                continue;
            }
            if (set instanceof Character) {
                char chr = ((Character)set).charValue();
                list.add(new int[]{chr, chr});
                continue;
            }
            throw new IllegalStateException();
        }
        int[][] dest = (int[][])list.toArray((T[])new int[0][]);
        Arrays.sort(dest, CMP);
        return dest;
    }

    private static int[] flatten(int[] ... arrays) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int[] str : arrays) {
            if (str.length == 1) {
                list.add(str[0]);
                continue;
            }
            if (str.length == 2) {
                int end = str[1];
                for (int chr = str[0]; chr <= end; ++chr) {
                    list.add(chr);
                }
                continue;
            }
            throw new IllegalStateException();
        }
        int[] chars = new int[list.size()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (Integer)list.get(i);
        }
        Arrays.sort(chars);
        return chars;
    }

    private static String[] pctEncode(int[] unencoded) {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        String[] result = new String[unencoded.length];
        for (int i = 0; i < unencoded.length; ++i) {
            ByteBuffer bb;
            String ns = new String(Character.toChars(unencoded[i]));
            try {
                bb = encoder.encode(CharBuffer.wrap(ns));
            }
            catch (CharacterCodingException x) {
                throw new IllegalStateException();
            }
            StringBuilder sb = new StringBuilder();
            while (bb.hasRemaining()) {
                byte b = (byte)(bb.get() & 0xFF);
                sb.append('%');
                sb.appendCodePoint(HEXDIG[b >> 4 & 0xF]);
                sb.appendCodePoint(HEXDIG[b & 0xF]);
            }
            result[i] = sb.toString();
        }
        return result;
    }

    public static ParsedIRI create(String str) {
        try {
            return new ParsedIRI(str);
        }
        catch (URISyntaxException x) {
            int problem = x.getIndex();
            StringBuilder sb = new StringBuilder(str);
            while (true) {
                int end;
                String decoded;
                String encoded = " ".equals(decoded = sb.substring(problem, end = sb.offsetByCodePoints(problem, 1))) ? "%20" : URLEncoder.encode(decoded, StandardCharsets.UTF_8);
                sb.replace(problem, end, encoded);
                try {
                    return new ParsedIRI(sb.toString());
                }
                catch (URISyntaxException ex) {
                    if (ex.getIndex() <= problem) {
                        throw new IllegalArgumentException(x.getMessage(), x);
                    }
                    problem = ex.getIndex();
                    continue;
                }
                break;
            }
        }
    }

    public ParsedIRI(String iri) throws URISyntaxException {
        assert (iri != null);
        this.iri = iri;
        this.parse();
    }

    public ParsedIRI(String scheme, String userInfo, String host, int port, String path, String query, String fragment) {
        this.iri = this.buildIRI(scheme, userInfo, host, port, path, query, fragment);
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path == null ? "" : path;
        this.query = query;
        this.fragment = fragment;
    }

    public int hashCode() {
        return this.iri.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ParsedIRI && this.iri.equals(((ParsedIRI)obj).iri);
    }

    public String toString() {
        return this.iri;
    }

    public String toASCIIString() {
        StringBuilder sb = new StringBuilder(this.iri.length());
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (this.host != null) {
            sb.append("//");
            if (this.userInfo != null) {
                this.appendAscii(sb, this.userInfo);
                sb.append('@');
            }
            if (this.host.length() > 0) {
                sb.append(IDN.toASCII(this.host, 1));
            }
            if (this.port >= 0) {
                sb.append(':').append(this.port);
            }
        }
        if (this.path != null) {
            this.appendAscii(sb, this.path);
        }
        if (this.query != null) {
            sb.append('?');
            this.appendAscii(sb, this.query);
        }
        if (this.fragment != null) {
            sb.append('#');
            this.appendAscii(sb, this.fragment);
        }
        return sb.toString();
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.scheme != null && !this.path.isEmpty() && !this.path.startsWith("/");
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public ParsedIRI normalize() {
        boolean localhost;
        String _scheme = this.toLowerCase(this.scheme);
        boolean optionalPort = this.isScheme("http") && 80 == this.port || this.isScheme("https") && 443 == this.port;
        int _port = optionalPort ? -1 : this.port;
        boolean bl = localhost = this.isScheme("file") && this.userInfo == null && -1 == this.port && ("".equals(this.host) || "localhost".equals(this.host));
        String _host = localhost ? null : (this.host == null || this.host.length() == 0 ? this.host : IDN.toUnicode(this.pctEncodingNormalization(this.toLowerCase(this.host)), 3));
        String _path = _scheme != null && this.path == null ? "" : this.normalizePath(this.path);
        String _userInfo = this.pctEncodingNormalization(this.userInfo);
        String _query = this.pctEncodingNormalization(this.query);
        String _fragment = this.pctEncodingNormalization(this.fragment);
        ParsedIRI normalized = new ParsedIRI(_scheme, _userInfo, _host, _port, _path, _query, _fragment);
        if (this.iri.equals(normalized.iri)) {
            return this;
        }
        return normalized;
    }

    public String resolve(String iri) {
        return this.resolve(ParsedIRI.create(iri)).toString();
    }

    public ParsedIRI resolve(ParsedIRI relative) {
        Object path;
        int port;
        String host;
        String userInfo;
        if (relative.isAbsolute()) {
            return relative;
        }
        if (relative.getHost() == null && relative.getQuery() == null && relative.getPath().length() == 0) {
            String fragment = relative.getFragment();
            return new ParsedIRI(this.getScheme(), this.getUserInfo(), this.getHost(), this.getPort(), this.getPath(), this.getQuery(), fragment);
        }
        if (relative.getHost() == null && relative.getPath().length() == 0) {
            String query = relative.getQuery();
            String fragment = relative.getFragment();
            return new ParsedIRI(this.getScheme(), this.getUserInfo(), this.getHost(), this.getPort(), this.getPath(), query, fragment);
        }
        boolean normalize = false;
        String scheme = this.getScheme();
        String query = relative.getQuery();
        String fragment = relative.getFragment();
        if (relative.getHost() != null) {
            userInfo = relative.getUserInfo();
            host = relative.getHost();
            port = relative.getPort();
            path = relative.getPath();
        } else {
            userInfo = this.getUserInfo();
            host = this.getHost();
            port = this.getPort();
            if (relative.getPath().startsWith("/")) {
                path = relative.getPath();
            } else {
                path = this.getPath();
                if (path == null) {
                    path = "/";
                } else {
                    if (!((String)path).endsWith("/")) {
                        int lastSlashIdx = ((String)path).lastIndexOf(47);
                        path = ((String)path).substring(0, lastSlashIdx + 1);
                    }
                    if (((String)path).length() == 0) {
                        path = "/";
                    }
                }
                path = (String)path + relative.getPath();
                normalize = true;
            }
        }
        if (normalize || ((String)path).contains("/./") || ((String)path).contains("/../")) {
            path = this.pathSegmentNormalization((String)path);
        }
        return new ParsedIRI(scheme, userInfo, host, port, (String)path, query, fragment);
    }

    public String relativize(String iri) {
        return this.relativize(ParsedIRI.create(iri)).toString();
    }

    public ParsedIRI relativize(ParsedIRI absolute) {
        String _frag = absolute.getFragment();
        if (this.iri.equals(absolute.iri) && _frag == null) {
            return new ParsedIRI(null, null, null, -1, "", null, null);
        }
        if (absolute.getScheme() != null && !absolute.getScheme().equalsIgnoreCase(this.getScheme())) {
            return absolute;
        }
        if (absolute.getUserInfo() != null && !absolute.getUserInfo().equals(this.getUserInfo())) {
            return absolute;
        }
        if (absolute.getHost() != null && !absolute.getHost().equalsIgnoreCase(this.getHost())) {
            return absolute;
        }
        if (absolute.getPort() != this.getPort()) {
            return absolute;
        }
        if (_frag != null) {
            if (this.getFragment() == null) {
                if (absolute.iri.startsWith(this.iri) && absolute.iri.charAt(this.iri.length()) == '#') {
                    return new ParsedIRI(null, null, null, -1, "", null, _frag);
                }
            } else {
                int this_idx = this.iri.length() - this.getFragment().length();
                int abs_idx = absolute.iri.length() - _frag.length();
                if (this.iri.substring(0, this_idx).equals(absolute.iri.substring(0, abs_idx))) {
                    return new ParsedIRI(null, null, null, -1, "", null, _frag);
                }
            }
        }
        if (this.isOpaque() || absolute.isOpaque()) {
            return absolute;
        }
        String _query = absolute.getQuery();
        if (_query != null) {
            if (this.getQuery() == null && this.getFragment() == null) {
                if (absolute.iri.startsWith(this.iri) && absolute.iri.charAt(this.iri.length()) == '?') {
                    return new ParsedIRI(null, null, null, -1, "", _query, _frag);
                }
            } else {
                int this_idx = this.getQuery() == null ? this.iri.indexOf(35) : this.iri.indexOf(63);
                int abs_idx = absolute.iri.indexOf(63);
                if (this.iri.substring(0, this_idx).equals(absolute.iri.substring(0, abs_idx))) {
                    return new ParsedIRI(null, null, null, -1, "", _query, _frag);
                }
            }
        }
        String _path = absolute.getPath();
        int this_idx = this.getPath().lastIndexOf(47);
        int abs_idx = _path.lastIndexOf(47);
        if (this_idx < 0 || abs_idx < 0) {
            return absolute;
        }
        if (_path.equals(this.getPath().substring(0, this_idx + 1))) {
            return new ParsedIRI(null, null, null, -1, ".", _query, _frag);
        }
        if (_path.startsWith(this.getPath().substring(0, this_idx + 1))) {
            return new ParsedIRI(null, null, null, -1, _path.substring(this_idx + 1), _query, _frag);
        }
        return new ParsedIRI(null, null, null, -1, this.relativizePath(_path), _query, _frag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse() throws URISyntaxException {
        int peek;
        this.pos = 0;
        this.scheme = this.parseScheme();
        if ("jar".equalsIgnoreCase(this.scheme)) {
            this.scheme = this.scheme + ":" + this.parseScheme();
        }
        if (47 == (peek = this.peek()) && 47 == this.peek(1)) {
            int next;
            this.advance(2);
            if (this.iri.indexOf(64) >= 0) {
                this.userInfo = this.parseUserInfo();
            }
            this.host = this.parseHost();
            if (58 == this.peek()) {
                this.advance(1);
                String p = this.parseMember(DIGIT, 47);
                this.port = p.length() > 0 ? Integer.parseInt(p) : -1;
            }
            if (47 != (next = this.peek()) && 63 != next && 35 != next && EOF != next) throw this.error("absolute or empty path expected");
            this.path = this.parsePath();
        } else if (47 == peek || 63 == peek || 35 == peek || EOF == peek) {
            this.path = this.parsePath();
        } else if (37 == peek || 58 != peek && this.isMember(pchar, peek)) {
            this.path = this.parsePath();
        } else if (this.scheme != null && 58 == peek) {
            this.path = this.parsePath();
        }
        if (63 == this.peek()) {
            this.advance(1);
            this.query = this.parsePctEncoded(qchar, 35, EOF);
        }
        if (35 == this.peek()) {
            this.advance(1);
            this.fragment = this.parsePctEncoded(fchar, 35, EOF);
        }
        if (this.pos == this.iri.length()) return;
        throw this.error("Unexpected character");
    }

    private String buildIRI(String scheme, String userInfo, String host, int port, String path, String query, String fragment) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(scheme).append(':');
        }
        if (host != null) {
            sb.append("//");
            if (userInfo != null) {
                sb.append(userInfo).append('@');
            }
            sb.append(host);
            if (port >= 0) {
                sb.append(':').append(port);
            }
        }
        if (path != null) {
            sb.append(path);
        }
        if (query != null) {
            sb.append('?').append(query);
        }
        if (fragment != null) {
            sb.append('#').append(fragment);
        }
        return sb.toString();
    }

    private String parseScheme() {
        if (this.isMember(ALPHA, this.peek())) {
            int start = this.pos;
            String scheme = this.parseMember(schar, 58);
            if (58 == this.peek()) {
                this.advance(1);
                return scheme;
            }
            this.pos = start;
        }
        return null;
    }

    private String parseUserInfo() throws URISyntaxException {
        int start = this.pos;
        String userinfo = this.parsePctEncoded(uchar, 64, 47);
        if (64 == this.peek()) {
            this.advance(1);
            return userinfo;
        }
        this.pos = start;
        return null;
    }

    private String parseHost() throws URISyntaxException {
        int start = this.pos;
        if (91 == this.peek()) {
            this.advance(1);
            this.parseMember(uchar, 93);
            if (93 == this.peek()) {
                this.advance(1);
                return this.iri.substring(start, this.pos);
            }
            throw this.error("Invalid host IP address");
        }
        if (this.isMember(DIGIT, this.peek())) {
            URISyntaxException parsingException = null;
            int startPos = this.pos;
            for (int i = 0; i < 4; ++i) {
                int octet;
                try {
                    octet = Integer.parseInt(this.parseMember(DIGIT, 46));
                }
                catch (NumberFormatException e) {
                    parsingException = this.error("Invalid IPv4 address");
                    break;
                }
                if (octet < 0 || octet > 255) {
                    parsingException = this.error("Invalid IPv4 address");
                    break;
                }
                if (46 == this.peek()) {
                    this.advance(1);
                    continue;
                }
                if (i == 3 && (EOF == this.peek() || 58 == this.peek() || 47 == this.peek())) continue;
                parsingException = this.error("Invalid IPv4 address");
                break;
            }
            if (parsingException == null) {
                return this.iri.substring(start, this.pos);
            }
            this.pos = startPos;
            String host = this.parsePctEncoded(hchar, 58, 47);
            if ((this.isScheme("http") || this.isScheme("https")) && !this.isTLDValid(start)) {
                throw parsingException;
            }
            return host;
        }
        return this.parsePctEncoded(hchar, 58, 47);
    }

    private boolean isTLDValid(int hostStartPos) {
        int step = 0;
        boolean illegalCharFound = false;
        while (this.pos + step > hostStartPos) {
            int currChar;
            if (46 == (currChar = this.peek(--step))) {
                return !illegalCharFound;
            }
            if (this.isMember(ALPHA, currChar)) continue;
            illegalCharFound = true;
        }
        return true;
    }

    private String parsePath() throws URISyntaxException {
        return this.parsePctEncoded(fchar, 63, 35);
    }

    private String parsePctEncoded(int[][] set, int end1, int end2) throws URISyntaxException {
        int chr;
        int start = this.pos;
        while ((chr = this.peek()) != EOF && chr != end1 && chr != end2) {
            if (97 <= chr && chr <= 122 || 65 <= chr && chr <= 90 || 48 <= chr && chr <= 57) {
                this.advance(1);
                continue;
            }
            if (37 == chr) {
                if (Arrays.binarySearch(HEXDIG, this.peek(1)) >= 0 && Arrays.binarySearch(HEXDIG, this.peek(2)) >= 0) {
                    this.advance(3);
                    continue;
                }
                throw this.error("Illegal percent encoding");
            }
            if (!this.isMember(set, chr)) break;
            this.advance(1);
        }
        return this.iri.substring(start, this.pos);
    }

    private String parseMember(int[][] set, int end) {
        int chr;
        int start = this.pos;
        while ((chr = this.peek()) != EOF && chr != end && this.isMember(set, chr)) {
            this.advance(1);
        }
        return this.iri.substring(start, this.pos);
    }

    private boolean isMember(int[][] set, int chr) {
        int idx = Arrays.binarySearch(set, new int[]{chr}, CMP);
        if (idx >= 0) {
            return true;
        }
        if (idx == -1) {
            return false;
        }
        int i = -idx - 2;
        assert (set[i][0] <= chr && set[i].length == 2);
        return chr <= set[i][1];
    }

    private int peek() {
        if (this.pos < this.iri.length()) {
            return this.iri.codePointAt(this.pos);
        }
        return EOF;
    }

    private int peek(int ahead) {
        if (this.pos + ahead < this.iri.length()) {
            return this.iri.codePointAt(this.iri.offsetByCodePoints(this.pos, ahead));
        }
        return EOF;
    }

    private void advance(int ahead) {
        this.pos = this.pos + ahead < this.iri.length() ? this.iri.offsetByCodePoints(this.pos, ahead) : (this.pos += ahead);
    }

    private URISyntaxException error(String reason) {
        if (this.pos > -1 && this.pos < this.iri.length()) {
            int cp = this.iri.codePointAt(this.pos);
            reason = (String)reason + " U+" + Integer.toHexString(cp).toUpperCase();
        }
        return new URISyntaxException(this.iri, (String)reason, this.pos);
    }

    private void appendAscii(StringBuilder sb, String input) {
        int n = input.codePointCount(0, input.length());
        for (int c = 0; c < n; ++c) {
            int chr = input.codePointAt(input.offsetByCodePoints(0, c));
            if (Arrays.binarySearch(ascii, chr) >= 0) {
                sb.appendCodePoint(chr);
                continue;
            }
            sb.append(this.pctEncode(chr));
        }
    }

    private String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        boolean changed = false;
        StringBuilder sb = new StringBuilder(string);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c < 'A' || c > 'Z') continue;
            changed = true;
            sb.setCharAt(i, (char)(c + 32));
        }
        return changed ? sb.toString() : string;
    }

    private String toUpperCase(String string) {
        if (string == null) {
            return null;
        }
        boolean changed = false;
        StringBuilder sb = new StringBuilder(string);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c < 'a' || c > 'z') continue;
            changed = true;
            sb.setCharAt(i, (char)(c - 32));
        }
        return changed ? sb.toString() : string;
    }

    private boolean isScheme(String scheme) {
        return scheme.equalsIgnoreCase(this.scheme) || this.scheme != null && this.scheme.indexOf(58) == 3 && this.scheme.equalsIgnoreCase("jar:" + scheme);
    }

    private String normalizePath(String path) {
        if ("".equals(path)) {
            return this.isScheme("http") || this.isScheme("https") ? "/" : "";
        }
        if (this.isScheme("file")) {
            if (path.contains("%5C")) {
                return this.normalizePath(path.replace("%5C", "/"));
            }
            if (!path.startsWith("/") && this.isMember(ALPHA, path.codePointAt(0)) && (':' == path.charAt(1) || path.length() >= 4 && "%7C".equals(path.substring(1, 4)))) {
                return this.normalizePath("/" + path);
            }
            if (path.length() >= 5 && "%7C".equals(path.substring(2, 5)) && this.isMember(ALPHA, path.codePointAt(1))) {
                return this.normalizePath(path.substring(0, 2) + ":" + path.substring(5));
            }
        }
        return this.pctEncodingNormalization(this.pathSegmentNormalization(path));
    }

    private String pctEncodingNormalization(String path) {
        if (path == null || path.length() == 0 || path.indexOf(37) < 0) {
            return path;
        }
        String[] encodings = this.listPctEncodings(path);
        StringBuilder sb = new StringBuilder(path);
        int pos = 0;
        for (String encoding : encodings) {
            int idx = sb.indexOf(encoding, pos);
            String decoded = this.normalizePctEncoding(encoding);
            sb.replace(idx, idx + encoding.length(), decoded);
            pos += decoded.length();
        }
        return Normalizer.normalize(sb, Normalizer.Form.NFC);
    }

    private String[] listPctEncodings(String path) {
        if (path == null || path.indexOf(37) < 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int pct = -1;
        while ((pct = path.indexOf(37, pct + 1)) > 0) {
            int start = pct;
            if (Arrays.binarySearch(common_pct, path.substring(pct, pct + 3)) < 0) {
                while (pct + 3 < path.length() && path.charAt(pct + 3) == '%' && Arrays.binarySearch(common_pct, path.substring(pct + 3, pct + 6)) < 0) {
                    pct += 3;
                }
            }
            list.add(path.substring(start, pct + 3));
        }
        return list.toArray(new String[0]);
    }

    private String normalizePctEncoding(String encoded) {
        int cidx = Arrays.binarySearch(common_pct, encoded);
        if (cidx >= 0 && this.isMember(unreserved, common[cidx])) {
            return new String(Character.toChars(common[cidx]));
        }
        if (cidx >= 0) {
            return encoded;
        }
        String decoded = this.pctDecode(encoded);
        String ns = Normalizer.normalize(decoded, Normalizer.Form.NFC);
        StringBuilder sb = new StringBuilder(ns.length());
        int n = ns.codePointCount(0, ns.length());
        for (int c = 0; c < n; ++c) {
            int chr = ns.codePointAt(ns.offsetByCodePoints(0, c));
            if (this.isMember(unreserved, chr)) {
                sb.appendCodePoint(chr);
                continue;
            }
            if (n == 1) {
                return this.toUpperCase(encoded);
            }
            sb.append(this.pctEncode(chr));
        }
        return sb.toString();
    }

    private String pctDecode(String encoded) {
        return URLDecoder.decode(encoded, StandardCharsets.UTF_8);
    }

    private String pctEncode(int chr) {
        return URLEncoder.encode(new String(Character.toChars(chr)), StandardCharsets.UTF_8);
    }

    private String pathSegmentNormalization(String _path) {
        if (_path == null) {
            return null;
        }
        if ((_path = _path.replace("/./", "/")) == null) {
            return null;
        }
        if (_path.startsWith("./")) {
            _path = _path.substring(2);
        }
        if (_path.endsWith("/.")) {
            _path = _path.substring(0, _path.length() - 1);
        }
        if (!_path.contains("/../") && !_path.endsWith("/..")) {
            return _path;
        }
        LinkedList<String> segments = new LinkedList<String>(Arrays.asList(_path.split("/")));
        if (_path.startsWith("/")) {
            segments.remove(0);
        }
        boolean lastSegmentRemoved = false;
        int i = 1;
        while (i < segments.size()) {
            String segment = segments.get(i);
            if (segment.equals("..")) {
                String prevSegment = segments.get(i - 1);
                if (prevSegment.equals("..")) {
                    i += 2;
                    continue;
                }
                if (i == segments.size() - 1) {
                    lastSegmentRemoved = true;
                }
                segments.remove(i);
                segments.remove(i - 1);
                if (i <= 1) continue;
                --i;
                continue;
            }
            ++i;
        }
        while (!segments.isEmpty() && (segments.get(0).equals("..") || segments.get(0).equals("."))) {
            segments.remove(0);
        }
        StringBuilder newPath = new StringBuilder(_path.length());
        if (_path.startsWith("/")) {
            newPath.append('/');
        }
        int segmentCount = segments.size();
        for (i = 0; i < segmentCount - 1; ++i) {
            newPath.append(segments.get(i));
            newPath.append('/');
        }
        if (segmentCount > 0) {
            String lastSegment = segments.get(segmentCount - 1);
            newPath.append(lastSegment);
            if (_path.endsWith("/") || lastSegmentRemoved) {
                newPath.append('/');
            }
        }
        return newPath.toString();
    }

    private String relativizePath(String absolute) {
        int i;
        int same;
        assert (absolute.charAt(0) == '/');
        String[] paths = this.path.split("/", Integer.MAX_VALUE);
        String[] seg = absolute.split("/", Integer.MAX_VALUE);
        for (same = 1; same < paths.length && same < seg.length - 1 && paths[same].equals(seg[same]); ++same) {
        }
        if (same < 2) {
            return absolute;
        }
        StringBuilder sb = new StringBuilder();
        for (i = same; i < paths.length - 1; ++i) {
            sb.append("../");
        }
        for (i = same; i < seg.length - 1; ++i) {
            sb.append(seg[i]).append('/');
        }
        return sb.append(seg[seg.length - 1]).toString();
    }
}

