/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.rdf4j.console.Console;
import org.eclipse.rdf4j.console.ConsoleIO;

class CmdLineParser {
    private static final Option HELP = new Option("h", "help", false, "print this help");
    private static final Option VERSION = new Option("v", "version", false, "print version information");
    private static final Option SERVER = new Option("s", "serverURL", true, "URL of RDF4J Server to connect to, e.g. http://localhost:8080/rdf4j-server/");
    private static final Option DIRECTORY = new Option("d", "dataDir", true, "data dir to 'connect' to");
    private static final Option ECHO = new Option("e", "echo", false, "echoes input back to stdout, useful for logging script sessions");
    private static final Option QUIET = new Option("q", "quiet", false, "suppresses prompts, useful for scripting");
    private static final Option FORCE = new Option("f", "force", false, "always answer yes to (suppressed) confirmation prompts");
    private static final Option CAUTIOUS = new Option("c", "cautious", false, "always answer no to (suppressed) confirmation prompts");
    private static final Option MODE = new Option("x", "exitOnError", false, "immediately exit the console on the first error");
    private static final OptionGroup CAUTION_GROUP = new OptionGroup().addOption(CAUTIOUS).addOption(FORCE).addOption(MODE);
    private static final OptionGroup LOCATION_GROUP = new OptionGroup().addOption(SERVER).addOption(DIRECTORY);
    private static final Options OPTIONS = new Options().addOptionGroup(LOCATION_GROUP).addOptionGroup(CAUTION_GROUP).addOption(HELP).addOption(VERSION).addOption(ECHO).addOption(QUIET);
    private final Console console;
    private CommandLine commandLine;

    protected CommandLine parse(String[] args) {
        try {
            this.commandLine = new PosixParser().parse(OPTIONS, args);
        }
        catch (ParseException e) {
            this.commandLine = null;
            this.console.getConsoleIO().writeError(e.getMessage());
        }
        return this.commandLine;
    }

    protected void printUsage() {
        ConsoleIO io = this.console.getConsoleIO();
        io.writeln("RDF4J Console, an interactive command shell for RDF4J repositories.");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(80);
        formatter.printHelp("start-console [OPTION] [repositoryID]", OPTIONS);
        io.writeln();
        io.writeln("For bug reports and suggestions, see http://www.rdf4j.org/");
    }

    protected boolean handleInfoOptions() {
        if (this.commandLine.hasOption(HELP.getOpt())) {
            this.printUsage();
            return false;
        }
        if (this.commandLine.hasOption(VERSION.getOpt())) {
            this.console.getConsoleIO().writeln(this.console.getState().getApplicationName());
            return false;
        }
        return true;
    }

    protected void handleExitOption() {
        this.console.setExitOnError(this.commandLine.hasOption(MODE.getOpt()));
    }

    protected void handleEchoOptions() {
        ConsoleIO io = this.console.getConsoleIO();
        io.setEcho(this.commandLine.hasOption(ECHO.getOpt()));
        io.setQuiet(this.commandLine.hasOption(QUIET.getOpt()));
    }

    protected boolean handleCautionGroup() {
        ConsoleIO io = this.console.getConsoleIO();
        try {
            if (this.commandLine.hasOption(FORCE.getOpt())) {
                CAUTION_GROUP.setSelected(FORCE);
                io.setForce();
            }
            if (this.commandLine.hasOption(CAUTIOUS.getOpt())) {
                CAUTION_GROUP.setSelected(CAUTIOUS);
                io.setCautious();
            }
        }
        catch (AlreadySelectedException e) {
            this.printUsage();
            return false;
        }
        return true;
    }

    protected String handleLocationGroup() {
        String location = null;
        try {
            if (this.commandLine.hasOption(DIRECTORY.getOpt())) {
                LOCATION_GROUP.setSelected(DIRECTORY);
                location = this.commandLine.getOptionValue(DIRECTORY.getOpt());
            }
            if (this.commandLine.hasOption(SERVER.getOpt())) {
                LOCATION_GROUP.setSelected(SERVER);
                location = this.commandLine.getOptionValue(SERVER.getOpt());
            }
        }
        catch (AlreadySelectedException e) {
            this.printUsage();
        }
        return location;
    }

    protected String getSelectedLocation() {
        return LOCATION_GROUP.getSelected();
    }

    protected String handleOtherArg() {
        String[] otherArgs = this.commandLine.getArgs();
        if (otherArgs.length > 1) {
            this.printUsage();
            return null;
        }
        return otherArgs.length == 1 ? otherArgs[0] : "";
    }

    protected CmdLineParser(Console console) {
        this.console = console;
    }
}

