/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.RDF4J;
import org.eclipse.rdf4j.common.app.AppConfiguration;
import org.eclipse.rdf4j.common.app.AppVersion;
import org.eclipse.rdf4j.console.CmdLineParser;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleParameters;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.Clear;
import org.eclipse.rdf4j.console.command.Close;
import org.eclipse.rdf4j.console.command.Connect;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.console.command.Convert;
import org.eclipse.rdf4j.console.command.Create;
import org.eclipse.rdf4j.console.command.Disconnect;
import org.eclipse.rdf4j.console.command.Drop;
import org.eclipse.rdf4j.console.command.Export;
import org.eclipse.rdf4j.console.command.Federate;
import org.eclipse.rdf4j.console.command.Load;
import org.eclipse.rdf4j.console.command.Open;
import org.eclipse.rdf4j.console.command.PrintHelp;
import org.eclipse.rdf4j.console.command.PrintInfo;
import org.eclipse.rdf4j.console.command.QueryEvaluator;
import org.eclipse.rdf4j.console.command.Serql;
import org.eclipse.rdf4j.console.command.SetParameters;
import org.eclipse.rdf4j.console.command.Show;
import org.eclipse.rdf4j.console.command.Sparql;
import org.eclipse.rdf4j.console.command.Verify;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.jline.reader.EndOfFileException;
import org.jline.reader.UserInterruptException;

public class Console {
    private static final AppVersion VERSION = AppVersion.parse((String)RDF4J.getVersion());
    private static final String APP_NAME = "Console";
    private static final AppConfiguration APP_CFG = new AppConfiguration("Console", VERSION);
    private static final ConsoleState STATE = new ConsoleState(){
        private RepositoryManager manager;
        private String managerID;
        private Repository repository;
        private String repositoryID;

        @Override
        public String getApplicationName() {
            return APP_CFG.getFullName();
        }

        @Override
        public File getDataDirectory() {
            return APP_CFG.getDataDir();
        }

        @Override
        public String getManagerID() {
            return this.managerID;
        }

        @Override
        public String getRepositoryID() {
            return this.repositoryID;
        }

        @Override
        public RepositoryManager getManager() {
            return this.manager;
        }

        @Override
        public void setManager(RepositoryManager manager) {
            this.manager = manager;
        }

        @Override
        public void setManagerID(String managerID) {
            this.managerID = managerID;
        }

        @Override
        public Repository getRepository() {
            return this.repository;
        }

        @Override
        public void setRepositoryID(String repositoryID) {
            this.repositoryID = repositoryID;
        }

        @Override
        public void setRepository(Repository repository) {
            this.repository = repository;
        }
    };
    private static final ConsoleParameters PARAMS = new ConsoleParameters(){
        private int consoleWidth = 80;
        private boolean showPrefix = true;
        private boolean queryPrefix = true;

        @Override
        public int getWidth() {
            return this.consoleWidth;
        }

        @Override
        public void setWidth(int width) {
            this.consoleWidth = width;
        }

        @Override
        public boolean isShowPrefix() {
            return this.showPrefix;
        }

        @Override
        public void setShowPrefix(boolean value) {
            this.showPrefix = value;
        }

        @Override
        public boolean isQueryPrefix() {
            return this.queryPrefix;
        }

        @Override
        public void setQueryPrefix(boolean value) {
            this.queryPrefix = value;
        }
    };
    private static boolean exitOnError;
    private final ConsoleIO consoleIO;
    private final SortedMap<String, ConsoleCommand> commandMap = new TreeMap<String, ConsoleCommand>();
    private final Connect connect;
    private final Disconnect disconnect;
    private final Open open;
    private final Close close;

    public ConsoleState getState() {
        return STATE;
    }

    public ConsoleIO getConsoleIO() {
        return this.consoleIO;
    }

    protected void setExitOnError(boolean mode) {
        exitOnError = mode;
    }

    public static void main(String[] args) throws IOException {
        Console console = new Console();
        CmdLineParser parser = new CmdLineParser(console);
        if (parser.parse(args) == null) {
            System.exit(-1);
        }
        if (!parser.handleInfoOptions()) {
            System.exit(0);
        }
        parser.handleEchoOptions();
        parser.handleExitOption();
        String location = parser.handleLocationGroup();
        if (!parser.handleCautionGroup()) {
            System.exit(3);
        }
        String otherArg = parser.handleOtherArg();
        Console.connectAndOpen(console, parser.getSelectedLocation(), location, otherArg);
        console.start();
    }

    private static void connectAndOpen(Console console, String selectedLocation, String location, String otherArg) {
        boolean connected = "s".equals(selectedLocation) ? console.connect.connectRemote(location) : ("d".equals(selectedLocation) ? console.connect.connectLocal(location) : console.connect.connectDefault());
        if (!connected) {
            System.exit(2);
        }
        if (!otherArg.isEmpty()) {
            console.open.openRepository(otherArg);
        }
    }

    public final void register(ConsoleCommand cmd) {
        this.commandMap.put(cmd.getName(), cmd);
    }

    public Console() throws IOException {
        APP_CFG.init();
        this.consoleIO = new ConsoleIO(STATE);
        this.close = new Close(this.consoleIO, STATE);
        this.disconnect = new Disconnect(this.consoleIO, STATE, this.close);
        this.connect = new Connect(this.consoleIO, STATE, this.disconnect);
        this.open = new Open(this.consoleIO, STATE, this.close);
        this.register(this.open);
        this.register(this.close);
        this.register(this.connect);
        this.register(this.disconnect);
        this.register(new Federate(this.consoleIO, STATE));
        this.register(new Sparql(this.consoleIO, STATE, PARAMS));
        this.register(new Serql(this.consoleIO, STATE, PARAMS));
        this.register(new PrintHelp(this.consoleIO, this.commandMap));
        this.register(new PrintInfo(this.consoleIO, STATE));
        this.register(new Show(this.consoleIO, STATE));
        this.register(new Create(this.consoleIO, STATE));
        this.register(new Drop(this.consoleIO, STATE, this.close));
        this.register(new Verify(this.consoleIO));
        this.register(new Load(this.consoleIO, STATE));
        this.register(new Clear(this.consoleIO, STATE));
        this.register(new Export(this.consoleIO, STATE));
        this.register(new Convert(this.consoleIO, STATE));
        this.register(new SetParameters(this.consoleIO, STATE, PARAMS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.consoleIO.writeln(APP_CFG.getFullName());
        this.consoleIO.writeln();
        this.consoleIO.writeln(RDF4J.getVersion());
        this.consoleIO.writeln("Type 'help' for help.");
        int exitCode = 0;
        try {
            boolean exitFlag = false;
            while (!exitFlag) {
                String command = this.consoleIO.readCommand();
                if (command == null) {
                    break;
                }
                exitFlag = this.executeCommand(command);
                if (!exitOnError || !this.consoleIO.wasErrorWritten()) continue;
                exitCode = 2;
                exitFlag = true;
            }
        }
        catch (EndOfFileException | UserInterruptException e) {
            exitCode = 0;
        }
        finally {
            this.disconnect.execute(false);
        }
        if (exitCode != 0) {
            System.exit(exitCode);
        }
        this.consoleIO.writeln("Bye");
    }

    private boolean executeCommand(String command) throws IOException {
        boolean exit = false;
        if (0 < command.length()) {
            String[] tokens = this.parse(command);
            String operation = tokens[0].toLowerCase(Locale.ENGLISH);
            boolean bl = exit = "quit".equals(operation) || "exit".equals(operation);
            if (!exit) {
                ConsoleCommand cmd = (ConsoleCommand)this.commandMap.getOrDefault(operation, (ConsoleCommand)this.commandMap.get("sparql"));
                if (cmd instanceof QueryEvaluator) {
                    ((QueryEvaluator)cmd).executeQuery(command, operation);
                } else {
                    cmd.execute(tokens);
                }
            }
        }
        return exit;
    }

    private String[] parse(String command) {
        Pattern pattern = Pattern.compile("\"([^\"]*)\"|(\\S+)");
        Matcher matcher = pattern.matcher(command);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            if (matcher.group(1) == null) {
                tokens.add(matcher.group());
                continue;
            }
            tokens.add(matcher.group(1));
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

