/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.LockRemover;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.RepositoryReadOnlyException;
import org.eclipse.rdf4j.repository.config.ConfigTemplate;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.jline.reader.EndOfFileException;
import org.jline.reader.UserInterruptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Create
extends ConsoleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(Create.class);
    private static final String TEMPLATES_DIR = "templates";

    @Override
    public String getName() {
        return "create";
    }

    @Override
    public String getHelpShort() {
        return "Creates a new repository";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\ncreate <template-name>\n  <template-name>   The name of a repository configuration template\n";
    }

    public Create(ConsoleIO consoleIO, ConsoleState state) {
        super(consoleIO, state);
    }

    @Override
    public void execute(String ... tokens) throws IOException {
        if (tokens.length < 2) {
            this.consoleIO.writeln(this.getHelpLong());
        } else {
            this.createRepository(tokens[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepository(String templateName) throws IOException {
        block10: {
            try {
                boolean proceedInvalid;
                String template;
                String templateFileName = templateName + ".ttl";
                File templatesDir = new File(this.state.getDataDirectory(), TEMPLATES_DIR);
                File templateFile = new File(templatesDir, templateFileName);
                InputStream templateStream = this.createTemplateStream(templateName, templateFileName, templatesDir, templateFile);
                if (templateStream == null) break block10;
                try {
                    template = IOUtil.readString((Reader)new InputStreamReader(templateStream, "UTF-8"));
                }
                finally {
                    templateStream.close();
                }
                ConfigTemplate configTemplate = new ConfigTemplate(template);
                HashMap<String, String> valueMap = new HashMap<String, String>();
                Map variableMap = configTemplate.getVariableMap();
                boolean eof = this.inputParameters(valueMap, variableMap, configTemplate.getMultilineMap());
                if (eof) break block10;
                String configString = configTemplate.render(valueMap);
                LinkedHashModel graph = new LinkedHashModel();
                RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.TURTLE, (ValueFactory)SimpleValueFactory.getInstance());
                rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)graph));
                rdfParser.parse((Reader)new StringReader(configString), "http://www.openrdf.org/config/repository#");
                Resource repositoryNode = (Resource)Models.subject((Model)graph.filter(null, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY, new Resource[0])).orElseThrow(() -> new RepositoryConfigException("missing repository node"));
                RepositoryConfig repConfig = RepositoryConfig.create((Model)graph, (Resource)repositoryNode);
                repConfig.validate();
                String overwrite = "WARNING: you are about to overwrite the configuration of an existing repository!";
                boolean proceedOverwrite = this.state.getManager().hasRepositoryConfig(repConfig.getID()) ? this.consoleIO.askProceed(overwrite, false) : true;
                String suggested = this.state.getManager().getNewRepositoryID(repConfig.getID());
                String invalid = "WARNING: There are potentially incompatible characters in the repository id.";
                boolean bl = proceedInvalid = !suggested.startsWith(repConfig.getID()) ? this.consoleIO.askProceed(invalid, false) : true;
                if (proceedInvalid && proceedOverwrite) {
                    try {
                        this.state.getManager().addRepositoryConfig(repConfig);
                        this.consoleIO.writeln("Repository created");
                    }
                    catch (RepositoryReadOnlyException e) {
                        if (LockRemover.tryToRemoveLock(this.state.getManager().getSystemRepository(), this.consoleIO)) {
                            this.state.getManager().addRepositoryConfig(repConfig);
                            this.consoleIO.writeln("Repository created");
                            break block10;
                        }
                        this.consoleIO.writeError("Failed to create repository");
                        LOGGER.error("Failed to create repository", (Throwable)e);
                    }
                    break block10;
                }
                this.consoleIO.writeln("Create aborted");
            }
            catch (EndOfFileException | UserInterruptException e) {
                LOGGER.error("Create repository aborted", e);
                throw e;
            }
            catch (Exception e) {
                this.consoleIO.writeError(e.toString());
                LOGGER.error("Failed to create repository", (Throwable)e);
            }
        }
    }

    private boolean inputParameters(Map<String, String> valueMap, Map<String, List<String>> variableMap, Map<String, String> multilineInput) throws IOException {
        if (!variableMap.isEmpty()) {
            this.consoleIO.writeln("Please specify values for the following variables:");
        }
        boolean eof = false;
        for (Map.Entry<String, List<String>> entry : variableMap.entrySet()) {
            String var = entry.getKey();
            List<String> values = entry.getValue();
            StringBuilder sb = new StringBuilder();
            sb.append(var);
            if (values.size() > 1) {
                sb.append(" (");
                for (int i = 0; i < values.size(); ++i) {
                    if (i > 0) {
                        sb.append("|");
                    }
                    sb.append(values.get(i));
                }
                sb.append(")");
            }
            if (!values.isEmpty()) {
                sb.append(" [" + values.get(0) + "]");
            }
            String prompt = sb.append(": ").toString();
            String value = multilineInput.containsKey(var) ? this.consoleIO.readMultiLineInput(prompt) : this.consoleIO.readln(prompt);
            boolean bl = eof = value == null;
            if (eof) break;
            if ((value = value.trim()).length() == 0) {
                value = null;
            }
            valueMap.put(var, value);
        }
        return eof;
    }

    private InputStream createTemplateStream(String templateName, String templateFileName, File templatesDir, File templateFile) throws FileNotFoundException {
        InputStream templateStream = null;
        if (templateFile.exists()) {
            if (templateFile.canRead()) {
                templateStream = new FileInputStream(templateFile);
            } else {
                this.consoleIO.writeError("Not allowed to read template file: " + templateFile);
            }
        } else {
            templateStream = RepositoryConfig.class.getResourceAsStream(templateFileName);
            if (templateStream == null) {
                this.consoleIO.writeError("No template called " + templateName + " found in " + templatesDir);
            }
        }
        return templateStream;
    }
}

