/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.SesameClient;
import org.eclipse.rdf4j.http.client.SesameSession;
import org.eclipse.rdf4j.http.client.SparqlSession;

public class SesameClientImpl
implements SesameClient,
HttpClientDependent {
    private HttpClient httpClient;
    private CloseableHttpClient dependentClient;
    private ExecutorService executor = null;
    private HttpClientBuilder httpClientBuilder;

    public SesameClientImpl() {
        this.initialize();
    }

    public SesameClientImpl(CloseableHttpClient dependentClient, ExecutorService dependentExecutorService) {
        this.dependentClient = dependentClient;
        this.httpClient = this.dependentClient;
        this.executor = dependentExecutorService;
    }

    @Override
    public synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.dependentClient = this.createHttpClient();
            this.httpClient = this.dependentClient;
        }
        return this.httpClient;
    }

    @Override
    public synchronized void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public synchronized void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    private CloseableHttpClient createHttpClient() {
        if (this.httpClientBuilder != null) {
            return this.httpClientBuilder.build();
        }
        return HttpClients.createSystem();
    }

    @Override
    public synchronized SparqlSession createSparqlSession(String queryEndpointUrl, String updateEndpointUrl) {
        SparqlSession session = new SparqlSession(this.getHttpClient(), this.executor);
        session.setQueryURL(queryEndpointUrl);
        session.setUpdateURL(updateEndpointUrl);
        return session;
    }

    @Override
    public synchronized SesameSession createSesameSession(String serverURL) {
        SesameSession session = new SesameSession(this.getHttpClient(), this.executor);
        session.setServerURL(serverURL);
        return session;
    }

    @Override
    public synchronized void shutDown() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        if (this.dependentClient != null) {
            HttpClientUtils.closeQuietly((HttpClient)this.dependentClient);
            this.dependentClient = null;
        }
    }

    public synchronized void initialize() {
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool();
        }
    }
}

