/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class QueueCursor<E>
extends LookAheadIteration<E, QueryEvaluationException> {
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final BlockingQueue<E> queue;
    private final E afterLast = this.createAfterLast();
    private final Queue<Throwable> exceptions = new LinkedList<Throwable>();

    public QueueCursor(int capacity) {
        this(capacity, false);
    }

    public QueueCursor(int capacity, boolean fair) {
        this.queue = new ArrayBlockingQueue(capacity, fair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toss(Exception exception) {
        Queue<Throwable> queue = this.exceptions;
        synchronized (queue) {
            this.exceptions.add(exception);
        }
    }

    public void put(E item) throws InterruptedException {
        if (!this.done.get()) {
            this.queue.put(item);
        }
    }

    public void done() {
        this.done.lazySet(true);
        try {
            this.queue.add(this.afterLast);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public E getNextElement() throws QueryEvaluationException {
        try {
            Object take;
            this.checkException();
            if (this.done.get()) {
                take = this.queue.poll();
            } else {
                take = this.queue.take();
                if (this.done.get()) {
                    this.done();
                }
            }
            if (this.isAfterLast(take)) {
                this.checkException();
                this.done();
                return null;
            }
            return take;
        }
        catch (InterruptedException e) {
            this.checkException();
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            this.done.set(true);
            do {
                this.queue.clear();
            } while (!this.queue.offer(this.afterLast));
            this.checkException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkException() throws QueryEvaluationException {
        Queue<Throwable> queue = this.exceptions;
        synchronized (queue) {
            if (!this.exceptions.isEmpty()) {
                try {
                    throw this.exceptions.remove();
                }
                catch (RDF4JException e) {
                    if (e instanceof QueryEvaluationException) {
                        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
                        stack.addAll(Arrays.asList(e.getStackTrace()));
                        StackTraceElement[] thisStack = new Throwable().getStackTrace();
                        stack.addAll(Arrays.asList(thisStack).subList(1, thisStack.length));
                        e.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
                        throw e;
                    }
                    throw new QueryEvaluationException((Throwable)e);
                }
                catch (RuntimeException e) {
                    ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
                    stack.addAll(Arrays.asList(e.getStackTrace()));
                    StackTraceElement[] thisStack = new Throwable().getStackTrace();
                    stack.addAll(Arrays.asList(thisStack));
                    e.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
                    throw e;
                }
                catch (Throwable e) {
                    throw new QueryEvaluationException(e);
                }
            }
        }
    }

    private boolean isAfterLast(E take) {
        return take == null || take == this.afterLast;
    }

    private E createAfterLast() {
        return (E)new Object();
    }
}

