/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.http.client.SparqlSession;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.http.protocol.transaction.TransactionWriter;
import org.eclipse.rdf4j.http.protocol.transaction.operations.TransactionOperation;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;

public class SesameSession
extends SparqlSession {
    private String serverURL;
    private String transactionURL;

    public SesameSession(HttpClient client, ExecutorService executor) {
        super(client, executor);
        this.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        this.setPreferredTupleQueryResultFormat(TupleQueryResultFormat.BINARY);
        this.setPreferredRDFFormat(RDFFormat.BINARY);
    }

    public void setServerURL(String serverURL) {
        if (serverURL == null) {
            throw new IllegalArgumentException("serverURL must not be null");
        }
        this.serverURL = serverURL;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getRepositoryURL() {
        return this.getQueryURL();
    }

    public void setRepository(String repositoryURL) {
        Pattern urlPattern = Pattern.compile("(.*)/repositories/[^/]*/?");
        Matcher matcher = urlPattern.matcher(repositoryURL);
        if (matcher.matches() && matcher.groupCount() == 1) {
            this.setServerURL(matcher.group(1));
        }
        this.setQueryURL(repositoryURL);
    }

    protected void checkRepositoryURL() {
        if (this.getRepositoryURL() == null) {
            throw new IllegalStateException("Repository URL has not been set");
        }
    }

    protected void checkServerURL() {
        if (this.serverURL == null) {
            throw new IllegalStateException("Server URL has not been set");
        }
    }

    @Override
    public String getUpdateURL() {
        return Protocol.getStatementsLocation((String)this.getQueryURL());
    }

    public TupleQueryResult getRepositoryList() throws IOException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getRepositoryList((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getRepositoryList(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkServerURL();
        HttpGet method = new HttpGet(Protocol.getRepositoriesLocation((String)this.serverURL));
        try {
            this.getTupleQueryResult((HttpUriRequest)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public String getServerProtocol() throws IOException, RepositoryException, UnauthorizedException {
        this.checkServerURL();
        HttpGet method = new HttpGet(Protocol.getProtocolLocation((String)this.serverURL));
        try {
            return EntityUtils.toString((HttpEntity)this.executeOK((HttpUriRequest)method).getEntity());
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public long size(Resource ... contexts) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        try {
            boolean useTransaction = this.transactionURL != null;
            String baseLocation = useTransaction ? this.appendAction(this.transactionURL, Protocol.Action.SIZE) : Protocol.getSizeLocation((String)this.getQueryURL());
            URIBuilder url = new URIBuilder(baseLocation);
            String[] encodedContexts = Protocol.encodeContexts((Resource[])contexts);
            for (int i = 0; i < encodedContexts.length; ++i) {
                url.addParameter("context", encodedContexts[i]);
            }
            HttpPut method = useTransaction ? new HttpPut(url.build()) : new HttpGet(url.build());
            String response = EntityUtils.toString((HttpEntity)this.executeOK((HttpUriRequest)method).getEntity());
            try {
                return Long.parseLong(response);
            }
            catch (NumberFormatException e) {
                throw new RepositoryException("Server responded with invalid size value: " + response);
            }
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void deleteRepository(String repositoryID) throws IOException, RepositoryException {
        HttpDelete method = new HttpDelete(Protocol.getRepositoryLocation((String)this.serverURL, (String)repositoryID));
        try {
            this.executeNoContent((HttpUriRequest)method);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public TupleQueryResult getNamespaces() throws IOException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getNamespaces((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getNamespaces(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkRepositoryURL();
        HttpGet method = new HttpGet(Protocol.getNamespacesLocation((String)this.getQueryURL()));
        try {
            this.getTupleQueryResult((HttpUriRequest)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public String getNamespace(String prefix) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        HttpGet method = new HttpGet(Protocol.getNamespacePrefixLocation((String)this.getQueryURL(), (String)prefix));
        try {
            HttpResponse response = this.execute((HttpUriRequest)method);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200 || code == 203) {
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            EntityUtils.consume((HttpEntity)response.getEntity());
            return null;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void setNamespacePrefix(String prefix, String name) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        HttpPut method = new HttpPut(Protocol.getNamespacePrefixLocation((String)this.getQueryURL(), (String)prefix));
        method.setEntity((HttpEntity)new StringEntity(name, ContentType.create((String)"text/plain", (String)"UTF-8")));
        try {
            this.executeNoContent((HttpUriRequest)method);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void removeNamespacePrefix(String prefix) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        HttpDelete method = new HttpDelete(Protocol.getNamespacePrefixLocation((String)this.getQueryURL(), (String)prefix));
        try {
            this.executeNoContent((HttpUriRequest)method);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void clearNamespaces() throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        HttpDelete method = new HttpDelete(Protocol.getNamespacesLocation((String)this.getQueryURL()));
        try {
            this.executeNoContent((HttpUriRequest)method);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public TupleQueryResult getContextIDs() throws IOException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getContextIDs((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getContextIDs(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkRepositoryURL();
        HttpGet method = new HttpGet(Protocol.getContextsLocation((String)this.getQueryURL()));
        try {
            this.getTupleQueryResult((HttpUriRequest)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public void getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws IOException, RDFHandlerException, RepositoryException, UnauthorizedException, QueryInterruptedException {
        this.checkRepositoryURL();
        try {
            boolean useTransaction = this.transactionURL != null;
            String baseLocation = useTransaction ? this.transactionURL : Protocol.getStatementsLocation((String)this.getQueryURL());
            URIBuilder url = new URIBuilder(baseLocation);
            if (subj != null) {
                url.setParameter("subj", Protocol.encodeValue((Value)subj));
            }
            if (pred != null) {
                url.setParameter("pred", Protocol.encodeValue((Value)pred));
            }
            if (obj != null) {
                url.setParameter("obj", Protocol.encodeValue((Value)obj));
            }
            for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
                url.addParameter("context", encodedContext);
            }
            url.setParameter("infer", Boolean.toString(includeInferred));
            if (useTransaction) {
                url.setParameter("action", Protocol.Action.GET.toString());
            }
            HttpPut method = useTransaction ? new HttpPut(url.build()) : new HttpGet(url.build());
            try {
                this.getRDF((HttpUriRequest)method, handler, true);
            }
            catch (MalformedQueryException e) {
                this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beginTransaction(IsolationLevel isolationLevel) throws RDF4JException, IOException, UnauthorizedException {
        block7: {
            this.checkRepositoryURL();
            if (this.transactionURL != null) {
                throw new IllegalStateException("Transaction URL is already set");
            }
            HttpPost method = new HttpPost(Protocol.getTransactionsLocation((String)this.getRepositoryURL()));
            method.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (isolationLevel != null) {
                params.add(new BasicNameValuePair("isolation-level", isolationLevel.getURI().stringValue()));
            }
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(params, UTF8));
            HttpResponse response = this.execute((HttpUriRequest)method);
            int code = response.getStatusLine().getStatusCode();
            try {
                if (code == 201) {
                    this.transactionURL = response.getFirstHeader("Location").getValue();
                    if (this.transactionURL == null) {
                        throw new RepositoryException("no valid transaction ID received in server response.");
                    }
                    break block7;
                }
                throw new RepositoryException("unable to start transaction. HTTP error code " + code);
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commitTransaction() throws RDF4JException, IOException, UnauthorizedException {
        block7: {
            this.checkRepositoryURL();
            if (this.transactionURL == null) {
                throw new IllegalStateException("Transaction URL has not been set");
            }
            HttpPut method = null;
            try {
                URIBuilder url = new URIBuilder(this.transactionURL);
                url.addParameter("action", Protocol.Action.COMMIT.toString());
                method = new HttpPut(url.build());
            }
            catch (URISyntaxException e) {
                this.logger.error("could not create URL for transaction commit", (Throwable)e);
                throw new RuntimeException(e);
            }
            HttpResponse response = this.execute((HttpUriRequest)method);
            try {
                int code = response.getStatusLine().getStatusCode();
                if (code == 200) {
                    this.transactionURL = null;
                    break block7;
                }
                throw new RepositoryException("unable to commit transaction. HTTP error code " + code);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollbackTransaction() throws RDF4JException, IOException, UnauthorizedException {
        block5: {
            this.checkRepositoryURL();
            if (this.transactionURL == null) {
                throw new IllegalStateException("Transaction URL has not been set");
            }
            String requestURL = this.transactionURL;
            HttpDelete method = new HttpDelete(requestURL);
            HttpResponse response = this.execute((HttpUriRequest)method);
            try {
                int code = response.getStatusLine().getStatusCode();
                if (code == 204) {
                    this.transactionURL = null;
                    break block5;
                }
                throw new RepositoryException("unable to rollback transaction. HTTP error code " + code);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    private String appendAction(String url, Protocol.Action action) {
        return url + "?" + "action" + "=" + action.toString();
    }

    @Deprecated
    public void sendTransaction(final Iterable<? extends TransactionOperation> txn) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        HttpPost method = new HttpPost(Protocol.getStatementsLocation((String)this.getQueryURL()));
        method.setEntity((HttpEntity)new AbstractHttpEntity(){

            public long getContentLength() {
                return -1L;
            }

            public Header getContentType() {
                return new BasicHeader("Content-Type", "application/x-rdftransaction");
            }

            public boolean isRepeatable() {
                return true;
            }

            public boolean isStreaming() {
                return true;
            }

            public InputStream getContent() throws IOException, IllegalStateException {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                this.writeTo(buf);
                return new ByteArrayInputStream(buf.toByteArray());
            }

            public void writeTo(OutputStream out) throws IOException {
                TransactionWriter txnWriter = new TransactionWriter();
                txnWriter.serialize(txn, out);
            }
        });
        try {
            this.executeNoContent((HttpUriRequest)method);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void addData(InputStream contents, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws UnauthorizedException, RDFParseException, RepositoryException, IOException {
        this.upload(contents, baseURI, dataFormat, false, true, Protocol.Action.ADD, contexts);
    }

    public void removeData(InputStream contents, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws UnauthorizedException, RDFParseException, RepositoryException, IOException {
        this.upload(contents, baseURI, dataFormat, false, true, Protocol.Action.DELETE, contexts);
    }

    public void upload(InputStream contents, String baseURI, RDFFormat dataFormat, boolean overwrite, boolean preserveNodeIds, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        this.upload(contents, baseURI, dataFormat, overwrite, preserveNodeIds, Protocol.Action.ADD, contexts);
    }

    protected void upload(InputStream contents, String baseURI, RDFFormat dataFormat, boolean overwrite, boolean preserveNodeIds, Protocol.Action action, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        InputStreamEntity entity = new InputStreamEntity(contents, -1L, ContentType.parse((String)dataFormat.getDefaultMIMEType()));
        this.upload((HttpEntity)entity, baseURI, overwrite, preserveNodeIds, action, contexts);
    }

    public void upload(Reader contents, String baseURI, RDFFormat dataFormat, boolean overwrite, boolean preserveNodeIds, Resource ... contexts) throws UnauthorizedException, RDFParseException, RepositoryException, IOException {
        this.upload(contents, baseURI, dataFormat, overwrite, preserveNodeIds, Protocol.Action.ADD, contexts);
    }

    @Override
    protected HttpUriRequest getQueryMethod(QueryLanguage ql, String query, String baseURI, Dataset dataset, boolean includeInferred, int maxQueryTime, Binding ... bindings) {
        RequestBuilder builder = null;
        if (this.transactionURL != null) {
            builder = RequestBuilder.put((String)this.transactionURL);
            builder.setHeader("Content-Type", "application/sparql-query; charset=utf-8");
            builder.addParameter("action", Protocol.Action.QUERY.toString());
            for (NameValuePair nvp : this.getQueryMethodParameters(ql, null, baseURI, dataset, includeInferred, maxQueryTime, bindings)) {
                builder.addParameter(nvp);
            }
            builder.setEntity((HttpEntity)new StringEntity(query, UTF8));
        } else {
            builder = RequestBuilder.post((String)this.getQueryURL());
            builder.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            builder.setEntity((HttpEntity)new UrlEncodedFormEntity(this.getQueryMethodParameters(ql, query, baseURI, dataset, includeInferred, maxQueryTime, bindings), UTF8));
        }
        return builder.build();
    }

    @Override
    protected HttpUriRequest getUpdateMethod(QueryLanguage ql, String update, String baseURI, Dataset dataset, boolean includeInferred, int maxExecutionTime, Binding ... bindings) {
        RequestBuilder builder = null;
        if (this.transactionURL != null) {
            builder = RequestBuilder.put((String)this.transactionURL);
            builder.addHeader("Content-Type", "application/sparql-update; charset=utf-8");
            builder.addParameter("action", Protocol.Action.UPDATE.toString());
            for (NameValuePair nvp : this.getUpdateMethodParameters(ql, null, baseURI, dataset, includeInferred, maxExecutionTime, bindings)) {
                builder.addParameter(nvp);
            }
            builder.setEntity((HttpEntity)new StringEntity(update, UTF8));
        } else {
            builder = RequestBuilder.post((String)this.getUpdateURL());
            builder.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            builder.setEntity((HttpEntity)new UrlEncodedFormEntity(this.getUpdateMethodParameters(ql, update, baseURI, dataset, includeInferred, maxExecutionTime, bindings), UTF8));
        }
        return builder.build();
    }

    protected void upload(final Reader contents, String baseURI, final RDFFormat dataFormat, boolean overwrite, boolean preserveNodeIds, Protocol.Action action, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        final Charset charset = dataFormat.hasCharset() ? dataFormat.getCharset() : Charset.forName("UTF-8");
        AbstractHttpEntity entity = new AbstractHttpEntity(){
            private InputStream content;

            public long getContentLength() {
                return -1L;
            }

            public Header getContentType() {
                return new BasicHeader("Content-Type", dataFormat.getDefaultMIMEType() + "; charset=" + charset.name());
            }

            public boolean isRepeatable() {
                return false;
            }

            public boolean isStreaming() {
                return true;
            }

            public synchronized InputStream getContent() throws IOException, IllegalStateException {
                if (this.content == null) {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    this.writeTo(buf);
                    this.content = new ByteArrayInputStream(buf.toByteArray());
                }
                return this.content;
            }

            public void writeTo(OutputStream out) throws IOException {
                try {
                    OutputStreamWriter writer = new OutputStreamWriter(out, charset);
                    IOUtil.transfer((Reader)contents, (Writer)writer);
                    writer.flush();
                }
                finally {
                    contents.close();
                }
            }
        };
        this.upload((HttpEntity)entity, baseURI, overwrite, preserveNodeIds, action, contexts);
    }

    protected void upload(HttpEntity reqEntity, String baseURI, boolean overwrite, boolean preserveNodeIds, Protocol.Action action, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.checkRepositoryURL();
        boolean useTransaction = this.transactionURL != null;
        try {
            String baseLocation = useTransaction ? this.transactionURL : Protocol.getStatementsLocation((String)this.getQueryURL());
            URIBuilder url = new URIBuilder(baseLocation);
            for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
                url.addParameter("context", encodedContext);
            }
            if (baseURI != null && baseURI.trim().length() != 0) {
                String encodedBaseURI = Protocol.encodeValue((Value)SimpleValueFactory.getInstance().createIRI(baseURI));
                url.setParameter("baseURI", encodedBaseURI);
            }
            if (preserveNodeIds) {
                url.setParameter("preserveNodeId", "true");
            }
            if (useTransaction) {
                if (action == null) {
                    throw new IllegalArgumentException("action can not be null on transaction operation");
                }
                url.setParameter("action", action.toString());
            }
            Object method = overwrite || useTransaction ? new HttpPut(url.build()) : new HttpPost(url.build());
            method.setEntity(reqEntity);
            try {
                this.executeNoContent((HttpUriRequest)method);
            }
            catch (RepositoryException e) {
                throw e;
            }
            catch (RDFParseException e) {
                throw e;
            }
            catch (RDF4JException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void setUsernameAndPassword(String username, String password) {
        this.checkServerURL();
        this.setUsernameAndPasswordForUrl(username, password, this.getServerURL());
    }
}

