/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client.query;

import java.util.Iterator;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.AbstractQuery;

public abstract class AbstractHTTPQuery
extends AbstractQuery {
    private final SPARQLProtocolSession httpClient;
    protected final QueryLanguage queryLanguage;
    protected final String queryString;
    protected final String baseURI;

    protected AbstractHTTPQuery(SPARQLProtocolSession httpClient, QueryLanguage queryLanguage, String queryString, String baseURI) {
        this.httpClient = httpClient;
        this.queryLanguage = queryLanguage;
        this.queryString = queryString;
        this.baseURI = baseURI != null && baseURI.length() > 0 ? baseURI : null;
    }

    protected SPARQLProtocolSession getHttpClient() {
        return this.httpClient;
    }

    public Binding[] getBindingsArray() {
        BindingSet bindings = this.getBindings();
        Binding[] bindingsArray = new Binding[bindings.size()];
        Iterator iter = bindings.iterator();
        for (int i = 0; i < bindings.size(); ++i) {
            bindingsArray[i] = (Binding)iter.next();
        }
        return bindingsArray;
    }

    public void setMaxExecutionTime(int maxExecutionTimeSeconds) {
        super.setMaxExecutionTime(maxExecutionTimeSeconds);
        this.httpClient.setConnectionTimeout(1000L * (long)this.getMaxExecutionTime());
    }

    public String toString() {
        return this.queryString;
    }
}

