/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model;

import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.IRI;
import org.junit.Test;

public abstract class IRITest {
    protected abstract IRI iri(String var1);

    protected abstract IRI iri(String var1, String var2);

    @Test
    public final void testUnaryConstructor() {
        String hash = "http://example.org#base#iri";
        String slash = "http://example.org/base/iri";
        String colon = "urn:base:iri";
        Assertions.assertThat((String)this.iri("http://example.org#base#iri").stringValue()).isEqualTo("http://example.org#base#iri");
        Assertions.assertThat((String)this.iri("http://example.org/base/iri").stringValue()).isEqualTo("http://example.org/base/iri");
        Assertions.assertThat((String)this.iri("urn:base:iri").stringValue()).isEqualTo("urn:base:iri");
        Assertions.assertThat((String)this.iri("http://example.org#base#iri").getNamespace()).isEqualTo("http://example.org#");
        Assertions.assertThat((String)this.iri("http://example.org#base#iri").getLocalName()).isEqualTo("base#iri");
        Assertions.assertThat((String)this.iri("http://example.org/base/iri").getNamespace()).isEqualTo("http://example.org/base/");
        Assertions.assertThat((String)this.iri("http://example.org/base/iri").getLocalName()).isEqualTo("iri");
        Assertions.assertThat((String)this.iri("urn:base:iri").getNamespace()).isEqualTo("urn:base:");
        Assertions.assertThat((String)this.iri("urn:base:iri").getLocalName()).isEqualTo("iri");
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.iri(null));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.iri("malformed"));
    }

    @Test
    public final void testBinaryConstructor() {
        String namespace = "http://example.org/";
        String localname = "iri";
        Assertions.assertThat((String)this.iri("http://example.org/", "iri").stringValue()).isEqualTo("http://example.org/iri");
        Assertions.assertThat((String)this.iri("http://example.org/", "iri").getNamespace()).isEqualTo("http://example.org/");
        Assertions.assertThat((String)this.iri("http://example.org/", "iri").getLocalName()).isEqualTo("iri");
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.iri(null, null));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.iri(null, "iri"));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.iri("http://example.org/", null));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.iri("malformed", "name"));
    }

    @Test
    public void testStringValue() {
        String namespace = "http://example.org/";
        String localname = "x";
        IRI iri = this.iri("http://example.org/", "x");
        Assertions.assertThat((String)iri.stringValue()).isEqualTo("http://example.org/x");
    }

    @Test
    public void testEquals() {
        IRI x = this.iri("http://example.org/", "x");
        IRI y = this.iri("http://example.org/", "Y");
        Assertions.assertThat((Object)x).isEqualTo((Object)x);
        Assertions.assertThat((Object)x).isEqualTo((Object)this.iri(x.getNamespace(), x.getLocalName()));
        Assertions.assertThat((Object)x).isNotEqualTo(null);
        Assertions.assertThat((Object)x).isNotEqualTo(new Object());
        Assertions.assertThat((Object)x).isNotEqualTo((Object)y);
    }

    @Test
    public void testHashCode() {
        IRI iri = this.iri("http://example.org/", "iri");
        ((AbstractIntegerAssert)Assertions.assertThat((int)iri.hashCode()).as("computed according to contract", new Object[0])).isEqualTo(iri.stringValue().hashCode());
    }
}

