/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.ChronoField;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBigIntegerAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableTypeAssert;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.junit.Test;

public abstract class LiteralTest {
    private static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    private static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final String XSD_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    static final String XSD_BYTE = "http://www.w3.org/2001/XMLSchema#byte";
    static final String XSD_SHORT = "http://www.w3.org/2001/XMLSchema#short";
    static final String XSD_INT = "http://www.w3.org/2001/XMLSchema#int";
    static final String XSD_LONG = "http://www.w3.org/2001/XMLSchema#long";
    static final String XSD_FLOAT = "http://www.w3.org/2001/XMLSchema#float";
    static final String XSD_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    static final String XSD_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    static final String XSD_DECIMAL = "http://www.w3.org/2001/XMLSchema#decimal";
    static final String XSD_STRING = "http://www.w3.org/2001/XMLSchema#string";
    static final String XSD_DATETIME = "http://www.w3.org/2001/XMLSchema#dateTime";
    static final String XSD_TIME = "http://www.w3.org/2001/XMLSchema#time";
    static final String XSD_DATE = "http://www.w3.org/2001/XMLSchema#date";
    static final String XSD_GYEARMONTH = "http://www.w3.org/2001/XMLSchema#gYearMonth";
    static final String XSD_GYEAR = "http://www.w3.org/2001/XMLSchema#gYear";
    static final String XSD_GMONTHDAY = "http://www.w3.org/2001/XMLSchema#gMonthDay";
    static final String XSD_GDAY = "http://www.w3.org/2001/XMLSchema#gDay";
    static final String XSD_GMONTH = "http://www.w3.org/2001/XMLSchema#gMonth";
    static final String XSD_DURATION = "http://www.w3.org/2001/XMLSchema#duration";
    static final String XSD_DURATION_DAYTIME = "http://www.w3.org/2001/XMLSchema#dayTimeDuration";
    static final String XSD_DURATION_YEARMONTH = "http://www.w3.org/2001/XMLSchema#yearMonthDuration";
    static final String RDF_LANG_STRING = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";

    protected abstract Literal literal(String var1);

    protected abstract Literal literal(String var1, String var2);

    protected abstract Literal literal(String var1, IRI var2);

    protected abstract Literal literal(String var1, CoreDatatype var2);

    protected abstract IRI datatype(String var1);

    @Test
    public final void testPlainConstructor() {
        String label = "label";
        Literal literal = this.literal("label");
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("label");
        Assertions.assertThat((Optional)literal.getLanguage()).isNotPresent();
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo(XSD_STRING);
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null));
    }

    @Test
    public final void testPlainConstructorWithLongLabel() {
        StringBuilder label = new StringBuilder(1000000);
        for (int i = 0; i < 1000000; ++i) {
            label.append(Integer.toHexString(i % 16));
        }
        Literal literal = this.literal(label.toString());
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(label.toString());
        Assertions.assertThat((Optional)literal.getLanguage()).isNotPresent();
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo(XSD_STRING);
    }

    @Test
    public final void testTaggedConstructor() {
        String label = "label";
        String language = "en";
        Literal literal = this.literal("label", "en");
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("label");
        Assertions.assertThat((Optional)literal.getLanguage()).contains((Object)"en");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo(RDF_LANG_STRING);
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, (String)null));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal("", (String)null));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, ""));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, (IRI)null));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.literal("", ""));
    }

    @Test
    public final void testTypedConstructor() {
        String label = "label";
        String datatype = "http://examplle.org/datatype";
        Literal literal = this.literal("label", this.datatype("http://examplle.org/datatype"));
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("label");
        Assertions.assertThat((Optional)literal.getLanguage()).isNotPresent();
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://examplle.org/datatype");
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, (IRI)null));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, this.datatype(XSD_STRING)));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, this.datatype(RDF_LANG_STRING)));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.literal("", this.datatype(RDF_LANG_STRING)));
    }

    @Test
    public final void testTypedConstructorNullDatatype() {
        String label = "label";
        IRI datatype = null;
        Literal literal = this.literal(label, datatype);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(label);
        Assertions.assertThat((Optional)literal.getLanguage()).isNotPresent();
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo(XSD_STRING);
    }

    @Test
    public void testStringValue() {
        String label = "literal";
        String language = "en";
        IRI datatype = this.datatype(XSD_DECIMAL);
        Assertions.assertThat((String)this.literal("literal").stringValue()).isEqualTo("literal");
        Assertions.assertThat((String)this.literal("literal", "en").stringValue()).isEqualTo("literal");
        Assertions.assertThat((String)this.literal("literal", datatype).stringValue()).isEqualTo("literal");
    }

    @Test
    public void testBooleanValue() {
        IRI datatype = this.datatype(XSD_BOOLEAN);
        Assertions.assertThat((boolean)this.literal("true", datatype).booleanValue()).isTrue();
        Assertions.assertThat((boolean)this.literal("false", datatype).booleanValue()).isFalse();
        Assertions.assertThat((boolean)this.literal("1", datatype).booleanValue()).isTrue();
        Assertions.assertThat((boolean)this.literal("0", datatype).booleanValue()).isFalse();
        Assertions.assertThat((boolean)this.literal("\ttrue", datatype).booleanValue()).isTrue();
        Assertions.assertThat((boolean)this.literal("false\t", datatype).booleanValue()).isFalse();
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.literal("malformed", datatype).booleanValue());
    }

    @Test
    public final void testByteValue() {
        IRI datatype = this.datatype(XSD_BYTE);
        Class<Byte> type = Byte.class;
        ((AbstractByteAssert)Assertions.assertThat((byte)this.literal("100", datatype).byteValue()).isInstanceOf(type)).isEqualTo((byte)100);
        ((AbstractByteAssert)Assertions.assertThat((byte)this.literal("+100", datatype).byteValue()).isInstanceOf(type)).isEqualTo((byte)100);
        ((AbstractByteAssert)Assertions.assertThat((byte)this.literal("-100", datatype).byteValue()).isInstanceOf(type)).isEqualTo((byte)-100);
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.literal("\t100", datatype).byteValue());
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.literal("malformed", datatype).booleanValue());
    }

    @Test
    public final void testShortValue() {
        IRI datatype = this.datatype(XSD_SHORT);
        Class<Short> type = Short.class;
        ((AbstractShortAssert)Assertions.assertThat((short)this.literal("100", datatype).shortValue()).isInstanceOf(type)).isEqualTo((short)100);
        ((AbstractShortAssert)Assertions.assertThat((short)this.literal("+100", datatype).shortValue()).isInstanceOf(type)).isEqualTo((short)100);
        ((AbstractShortAssert)Assertions.assertThat((short)this.literal("-100", datatype).shortValue()).isInstanceOf(type)).isEqualTo((short)-100);
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.literal("\t100", datatype).shortValue());
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.literal("malformed", datatype).shortValue());
    }

    @Test
    public final void testIntValue() {
        IRI datatype = this.datatype(XSD_INT);
        Class<Integer> type = Integer.class;
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.literal("100", datatype).intValue()).isInstanceOf(type)).isEqualTo(100);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.literal("+100", datatype).intValue()).isInstanceOf(type)).isEqualTo(100);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.literal("-100", datatype).intValue()).isInstanceOf(type)).isEqualTo(-100);
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.literal("\t100", datatype).intValue());
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.literal("malformed", datatype).intValue());
    }

    @Test
    public final void testLongValue() {
        IRI datatype = this.datatype(XSD_LONG);
        Class<Long> type = Long.class;
        ((AbstractLongAssert)Assertions.assertThat((long)this.literal("100", datatype).longValue()).isInstanceOf(type)).isEqualTo(100L);
        ((AbstractLongAssert)Assertions.assertThat((long)this.literal("+100", datatype).longValue()).isInstanceOf(type)).isEqualTo(100L);
        ((AbstractLongAssert)Assertions.assertThat((long)this.literal("-100", datatype).longValue()).isInstanceOf(type)).isEqualTo(-100L);
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.literal("\t100", datatype).longValue());
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.literal("malformed", datatype).longValue());
    }

    @Test
    public final void testFloatValue() {
        IRI datatype = this.datatype(XSD_FLOAT);
        Class<Float> type = Float.class;
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("100", datatype).floatValue()).isInstanceOf(type)).isEqualTo(100.0f);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("+100", datatype).floatValue()).isInstanceOf(type)).isEqualTo(100.0f);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("-100", datatype).floatValue()).isInstanceOf(type)).isEqualTo(-100.0f);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("100.0", datatype).floatValue()).isInstanceOf(type)).isEqualTo(100.0f);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("10e1", datatype).floatValue()).isInstanceOf(type)).isEqualTo(100.0f);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("INF", datatype).floatValue()).isInstanceOf(type)).isEqualTo(Float.POSITIVE_INFINITY);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("-INF", datatype).floatValue()).isInstanceOf(type)).isEqualTo(Float.NEGATIVE_INFINITY);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Float.isNaN(this.literal("NaN", datatype).floatValue()));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.literal("malformed", datatype).floatValue());
    }

    @Test
    public final void testDoubleValue() {
        IRI datatype = this.datatype(XSD_DOUBLE);
        Class<Double> type = Double.class;
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("100", datatype).doubleValue()).isInstanceOf(type)).isEqualTo(100.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("+100", datatype).doubleValue()).isInstanceOf(type)).isEqualTo(100.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("-100", datatype).doubleValue()).isInstanceOf(type)).isEqualTo(-100.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("100.0", datatype).doubleValue()).isInstanceOf(type)).isEqualTo(100.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("10e1", datatype).doubleValue()).isInstanceOf(type)).isEqualTo(100.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("INF", datatype).doubleValue()).isInstanceOf(type)).isEqualTo(Double.POSITIVE_INFINITY);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("-INF", datatype).doubleValue()).isInstanceOf(type)).isEqualTo(Double.NEGATIVE_INFINITY);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isNaN(this.literal("NaN", datatype).doubleValue()));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.literal("malformed", datatype).doubleValue());
    }

    @Test
    public final void testIntegerValue() {
        IRI datatype = this.datatype(XSD_INTEGER);
        Class<BigInteger> type = BigInteger.class;
        ((AbstractBigIntegerAssert)Assertions.assertThat((BigInteger)this.literal("100", datatype).integerValue()).isInstanceOf(type)).isEqualTo(100);
        ((AbstractBigIntegerAssert)Assertions.assertThat((BigInteger)this.literal("+100", datatype).integerValue()).isInstanceOf(type)).isEqualTo(100);
        ((AbstractBigIntegerAssert)Assertions.assertThat((BigInteger)this.literal("-100", datatype).integerValue()).isInstanceOf(type)).isEqualTo(-100);
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.literal("\t100", datatype).integerValue());
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.literal("malformed", datatype).integerValue());
    }

    @Test
    public final void testDecimalValue() {
        IRI datatype = this.datatype(XSD_DECIMAL);
        Class<BigDecimal> type = BigDecimal.class;
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)this.literal("100", datatype).decimalValue()).isInstanceOf(type)).isEqualTo((Object)new BigDecimal("100"));
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)this.literal("+100", datatype).decimalValue()).isInstanceOf(type)).isEqualTo((Object)new BigDecimal("100"));
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)this.literal("-100", datatype).decimalValue()).isInstanceOf(type)).isEqualTo((Object)new BigDecimal("-100"));
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)this.literal("100.0", datatype).decimalValue()).isInstanceOf(type)).isEqualTo((Object)new BigDecimal("100.0"));
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)this.literal("10e1", datatype).decimalValue()).isInstanceOf(type)).isEqualTo((Object)new BigDecimal("1.0e2"));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.literal("\t100", datatype).decimalValue());
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.literal("malformed", datatype).decimalValue());
    }

    @Test
    public final void testTemporalDateTimeValue() {
        String integral = "2020-09-29T01:02:03";
        String fractional = "2020-09-29T01:02:03.004";
        String offset = "2020-09-29T01:02:03+05:00";
        String zero = "2020-09-29T01:02:03Z";
        Assertions.assertThat((LocalDateTime)LocalDateTime.from(this.literal("2020-09-29T01:02:03", XSD_DATETIME).temporalAccessorValue())).isEqualTo((Object)LocalDateTime.parse("2020-09-29T01:02:03"));
        Assertions.assertThat((LocalDateTime)LocalDateTime.from(this.literal("2020-09-29T01:02:03.004", XSD_DATETIME).temporalAccessorValue())).isEqualTo((Object)LocalDateTime.parse("2020-09-29T01:02:03.004"));
        Assertions.assertThat((OffsetDateTime)OffsetDateTime.from(this.literal("2020-09-29T01:02:03+05:00", XSD_DATETIME).temporalAccessorValue())).isEqualTo((Object)OffsetDateTime.parse("2020-09-29T01:02:03+05:00"));
        Assertions.assertThat((OffsetDateTime)OffsetDateTime.from(this.literal("2020-09-29T01:02:03Z", XSD_DATETIME).temporalAccessorValue())).isEqualTo((Object)OffsetDateTime.parse("2020-09-29T01:02:03Z"));
        Stream.of("0001-01-01T00:00:00", "0001-01-01T00:00:00.0", "0001-01-01T00:00:00Z", "0001-01-01T00:00:00.0Z", "0001-01-01T00:00:00+00:00", "0001-01-01T00:00:00.0+00:00", "0001-01-01T00:00:00.0-00:00", "0001-01-01T00:00:00.0+14:00", "0001-01-01T00:00:00.0-14:00", "0001-05-31T00:00:00.00", "0001-07-31T00:00:00.00", "0001-08-31T00:00:00.00", "0001-10-31T00:00:00.00", "0001-12-31T00:00:00.00", "-0001-01-01T00:00:00", "1234-12-31T23:59:59", "1234-12-31T24:00:00", "2004-02-29T00:00:00").forEach(value -> ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.literal((String)value, XSD_DATETIME).temporalAccessorValue()).as(value, new Object[0])).doesNotThrowAnyException());
    }

    @Test
    public final void testTemporalTimeValue() {
        String integral = "01:02:03";
        String fractional = "01:02:03.004";
        String offset = "01:02:03+05:00";
        String zero = "01:02:03Z";
        Assertions.assertThat((LocalTime)LocalTime.from(this.literal("01:02:03", XSD_TIME).temporalAccessorValue())).isEqualTo((Object)LocalTime.parse("01:02:03"));
        Assertions.assertThat((LocalTime)LocalTime.from(this.literal("01:02:03.004", XSD_TIME).temporalAccessorValue())).isEqualTo((Object)LocalTime.parse("01:02:03.004"));
        Assertions.assertThat((OffsetTime)OffsetTime.from(this.literal("01:02:03+05:00", XSD_TIME).temporalAccessorValue())).isEqualTo((Object)OffsetTime.parse("01:02:03+05:00"));
        Assertions.assertThat((OffsetTime)OffsetTime.from(this.literal("01:02:03Z", XSD_TIME).temporalAccessorValue())).isEqualTo((Object)OffsetTime.parse("01:02:03Z"));
    }

    @Test
    public final void testTemporalDateValue() {
        String local = "2020-11-14";
        String offset = "2020-11-14+05:00";
        String zero = "2020-11-14Z";
        Assertions.assertThat((LocalDate)LocalDate.from(this.literal("2020-11-14", XSD_DATE).temporalAccessorValue())).isEqualTo((Object)LocalDate.parse("2020-11-14"));
        Assertions.assertThat((LocalDate)LocalDate.from(this.literal("2020-11-14+05:00", XSD_DATE).temporalAccessorValue())).isEqualTo((Object)LocalDate.parse("2020-11-14+05:00".substring(0, 10)));
        Assertions.assertThat((LocalDate)LocalDate.from(this.literal("2020-11-14Z", XSD_DATE).temporalAccessorValue())).isEqualTo((Object)LocalDate.parse("2020-11-14+05:00".substring(0, 10)));
    }

    @Test
    public final void testTemporalGYearMonthValue() {
        String base = "2020-11";
        Assertions.assertThat((Comparable)YearMonth.from(this.literal("2020-11", XSD_GYEARMONTH).temporalAccessorValue())).isEqualTo((Object)YearMonth.parse("2020-11"));
    }

    @Test
    public final void testTemporalGYearValue() {
        String local = "2020";
        Assertions.assertThat((Comparable)Year.from(this.literal("2020", XSD_GYEAR).temporalAccessorValue())).isEqualTo((Object)Year.parse("2020"));
    }

    @Test
    public final void testTemporalGMonthDayValue() {
        String local = "--11-14";
        Assertions.assertThat((Comparable)MonthDay.from(this.literal("--11-14", XSD_GMONTHDAY).temporalAccessorValue())).isEqualTo((Object)MonthDay.parse("--11-14"));
    }

    @Test
    public final void testTemporalGDayValue() {
        String local = "---14";
        Assertions.assertThat((int)this.literal("---14", XSD_GDAY).temporalAccessorValue().get(ChronoField.DAY_OF_MONTH)).isEqualTo(14);
    }

    @Test
    public final void testTemporalGMonthValue() {
        String local = "--11";
        Assertions.assertThat((Comparable)((Object)Month.from(this.literal("--11", XSD_GMONTH).temporalAccessorValue()))).isEqualTo((Object)Month.NOVEMBER);
    }

    @Test
    public final void testTemporalAccessorMalformedValue() {
        Assertions.assertThatExceptionOfType(DateTimeException.class).isThrownBy(() -> this.literal("", XSD_DATETIME).temporalAccessorValue());
        Assertions.assertThatExceptionOfType(DateTimeException.class).isThrownBy(() -> this.literal("--", XSD_DATETIME).temporalAccessorValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("no time components", new Object[0])).isThrownBy(() -> this.literal("2020-11-16T", XSD_DATETIME).temporalAccessorValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("missing fractional digits after dot", new Object[0])).isThrownBy(() -> this.literal("2020-11-16T11:12:13.", XSD_DATETIME).temporalAccessorValue());
        Assertions.assertThatExceptionOfType(DateTimeException.class).isThrownBy(() -> this.literal("malformed", XSD_DATETIME).temporalAccessorValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("no time components", new Object[0])).isThrownBy(() -> this.literal("2020-11-16T", XSD_DATETIME).temporalAccessorValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("missing fractional digits after dot", new Object[0])).isThrownBy(() -> this.literal("2020-11-16T11:12:13.", XSD_DATETIME).temporalAccessorValue());
        Stream.of("foo", "Mon, 11 Jul 2005 09:22:29 +0200", "0001-01-01T00:00", "0001-01-01T00:00.00", "0001-13-01T00:00:00.00", "0001-01-32T00:00:00.00", "0001-01-01T25:00:00.00", "0001-01-01T00:61:00.00", "0001-01-01T00:00:61.00", "0001-01-01T00:00.00+15:00", "0001-01-01T00:00.00-15:00", "001-01-01T00:00:00.0", "0001-1-01T00:00:00.0", "0001-01-1T00:00:00.0", "0001-01-01T0:00:00.0", "0001-01-01T00:0:00.0", "0001-01-01T00:00:0.0", "0001/01-01T00:00:00.0", "0001-01/01T00:00:00.0", "0001-01-01t00:00:00.0", "0001-01-01T00.00:00.0", "0001-01-01T00:00.00.0", "0001-01-01T00:00:00:0", "0001-01-01T00:00.00+0:00", "0001-01-01T00:00.00+00:0", "0001-jan-01T00:00:00", "0001-01-01T00:00:00+00:00Z", "0001-01-01T24:01:00", "0001-01-01T24:00:01", "00001-01-01T00:00:00", "0001-001-01T00:00:00", "0001-01-001T00:00:00", "0001-01-01T000:00:00", "0001-01-01T00:000:00", "0001-01-01T00:00:000", "0001-01-01T00:00:000", "0001-01-01T00:00:00z", "0001-01-01T00:00:00+05", "0001-01-01T00:00:00+0500", "0001-01-01T00:00:00GMT", "0001-01-01T00:00:00PST", "0001-01-01T00:00:00GMT+05", "-0000-01-01T00:00:00", "+0001-01-01T00:00:00").forEach(value -> ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as(value, new Object[0])).isThrownBy(() -> this.literal((String)value, XSD_DATETIME).temporalAccessorValue()));
    }

    @Test
    public final void testTemporalDurationValue() {
        String period = "P1Y2M3D";
        String duration = "PT1H2M3.4S";
        Assertions.assertThat((Period)Period.from(this.literal("P1Y2M3D", XSD_DURATION).temporalAmountValue())).isEqualTo((Object)Period.parse("P1Y2M3D"));
        Assertions.assertThat((Period)Period.from(this.literal("-P1Y2M3D", XSD_DURATION).temporalAmountValue())).isEqualTo((Object)Period.parse("P1Y2M3D").negated());
        Assertions.assertThat((Duration)Duration.from(this.literal("PT1H2M3.4S", XSD_DURATION).temporalAmountValue())).isEqualTo((Object)Duration.parse("PT1H2M3.4S"));
    }

    @Test
    public final void testTemporalAmountMalformedValue() {
        Assertions.assertThatExceptionOfType(DateTimeException.class).isThrownBy(() -> this.literal("", XSD_DURATION).temporalAmountValue());
        Assertions.assertThatExceptionOfType(DateTimeException.class).isThrownBy(() -> this.literal("malformed", XSD_DURATION).temporalAmountValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("no  components", new Object[0])).isThrownBy(() -> this.literal("P", XSD_DURATION).temporalAmountValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("no time components", new Object[0])).isThrownBy(() -> this.literal("P1Y2MT", XSD_DURATION).temporalAmountValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("negative component", new Object[0])).isThrownBy(() -> this.literal("P-1347M ", XSD_DURATION).temporalAmountValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("no time separator", new Object[0])).isThrownBy(() -> this.literal("P1Y1S ", XSD_DURATION).temporalAmountValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("missing fractional digits after dot", new Object[0])).isThrownBy(() -> this.literal("PT1.S", XSD_DURATION).temporalAmountValue());
    }

    @Test
    public final void testCalendarValue() throws DatatypeConfigurationException {
        Class<XMLGregorianCalendar> type = XMLGregorianCalendar.class;
        DatatypeFactory factory = DatatypeFactory.newInstance();
        Function<Consumer, XMLGregorianCalendar> setup = consumer -> {
            XMLGregorianCalendar calendar = factory.newXMLGregorianCalendar();
            consumer.accept(calendar);
            return calendar;
        };
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("2020-09-29T01:02:03.004Z", XSD_DATETIME).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> {
            calendar.setYear(2020);
            calendar.setMonth(9);
            calendar.setDay(29);
            calendar.setTime(1, 2, 3, 4);
            calendar.setTimezone(0);
        }));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("01:02:03.004", XSD_TIME).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> calendar.setTime(1, 2, 3, 4)));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("2020-09-29", XSD_DATE).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> {
            calendar.setYear(2020);
            calendar.setMonth(9);
            calendar.setDay(29);
        }));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("2020-09", XSD_GYEARMONTH).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> {
            calendar.setYear(2020);
            calendar.setMonth(9);
        }));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("--09-29", XSD_GMONTHDAY).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> {
            calendar.setMonth(9);
            calendar.setDay(29);
        }));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("2020", XSD_GYEAR).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> calendar.setYear(2020)));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("--09", XSD_GMONTH).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> calendar.setMonth(9)));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("---29", XSD_GDAY).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> calendar.setDay(29)));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.literal("\t100", XSD_DATETIME).calendarValue());
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.literal("malformed", XSD_DATETIME).calendarValue());
    }

    @Test
    public void testEqualsAndHashCode() {
        Literal plain = this.literal("plain");
        Literal tagged = this.literal("tagged", "en");
        Literal typed = this.literal("typed", this.datatype("http://example.org/datatype"));
        Literal _plain = this.literal(plain.getLabel());
        Literal _tagged = this.literal(tagged.getLabel(), tagged.getLanguage().orElse(""));
        Literal _typed = this.literal(typed.getLabel(), typed.getDatatype());
        Assertions.assertThat((Object)plain).isEqualTo((Object)plain);
        Assertions.assertThat((Object)plain).isEqualTo((Object)_plain);
        Assertions.assertThat((Object)tagged).isEqualTo((Object)tagged);
        Assertions.assertThat((Object)tagged).isEqualTo((Object)_tagged);
        Assertions.assertThat((Object)typed).isEqualTo((Object)typed);
        Assertions.assertThat((Object)typed).isEqualTo((Object)_typed);
        Assertions.assertThat((Object)plain).isNotEqualTo(null);
        Assertions.assertThat((Object)plain).isNotEqualTo(new Object());
        Assertions.assertThat((Object)plain).isNotEqualTo((Object)tagged);
        Assertions.assertThat((Object)plain).isNotEqualTo((Object)typed);
        Assertions.assertThat((Object)tagged).isNotEqualTo((Object)typed);
        Assertions.assertThat((Object)plain).isNotEqualTo((Object)this.literal("other"));
        Assertions.assertThat((Object)tagged).isNotEqualTo((Object)this.literal(tagged.getLabel(), "other"));
        Assertions.assertThat((Object)typed).isNotEqualTo((Object)this.literal(typed.getLabel(), this.datatype("http://example.org/other")));
        Assertions.assertThat((int)plain.hashCode()).isEqualTo(_plain.hashCode());
        Assertions.assertThat((int)tagged.hashCode()).isEqualTo(_tagged.hashCode());
        Assertions.assertThat((int)typed.hashCode()).isEqualTo(_typed.hashCode());
        ((AbstractIntegerAssert)Assertions.assertThat((int)tagged.hashCode()).as("computed according to contract", new Object[0])).isEqualTo(tagged.getLabel().hashCode());
    }

    @Test
    public final void testEqualsAndHashCodeCaseInsensitiveLanguage() {
        Literal lowercase = this.literal("label", "en");
        Literal uppercase = this.literal("label", "EN");
        Assertions.assertThat((Object)lowercase).isEqualTo((Object)uppercase);
        Assertions.assertThat((int)lowercase.hashCode()).isEqualTo(uppercase.hashCode());
    }

    @Test
    public final void testEqualsAndHashCodeXSDString() {
        Literal plain = this.literal("label");
        Literal typed = this.literal("label", this.datatype(XSD_STRING));
        Assertions.assertThat((Object)plain).isEqualTo((Object)typed);
        Assertions.assertThat((int)plain.hashCode()).isEqualTo(typed.hashCode());
    }

    @Test
    public final void testCoreDatatypePlainConstructor() {
        String label = "label";
        Literal literal = this.literal(label);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(label);
        Assertions.assertThat((Optional)literal.getLanguage()).isNotPresent();
        Assertions.assertThat((Object)literal.getCoreDatatype()).isEqualTo((Object)CoreDatatype.XSD.STRING);
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null));
    }

    @Test
    public final void testCoreDatatypePlainConstructorWithLongLabel() {
        StringBuilder label = new StringBuilder(1000000);
        for (int i = 0; i < 1000000; ++i) {
            label.append(Integer.toHexString(i % 16));
        }
        Literal literal = this.literal(label.toString());
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(label.toString());
        Assertions.assertThat((Optional)literal.getLanguage()).isNotPresent();
        Assertions.assertThat((Object)literal.getCoreDatatype()).isEqualTo((Object)CoreDatatype.XSD.STRING);
    }

    @Test
    public final void testCoreDatatypeTaggedConstructor() {
        String label = "label";
        String language = "en";
        Literal literal = this.literal(label, language);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(label);
        Assertions.assertThat((Optional)literal.getLanguage()).contains((Object)language);
        Assertions.assertThat((Object)literal.getCoreDatatype()).isEqualTo((Object)CoreDatatype.RDF.LANGSTRING);
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, (String)null));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal("", (String)null));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, ""));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, (CoreDatatype)null));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.literal("", ""));
    }

    @Test
    public final void testCoreDatatypeTypedConstructor() {
        String label = "label";
        String datatype = "http://examplle.org/datatype";
        Literal literal = this.literal(label, this.datatype(datatype));
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(label);
        Assertions.assertThat((Optional)literal.getLanguage()).isNotPresent();
        Assertions.assertThat((Object)literal.getCoreDatatype()).isEqualTo((Object)CoreDatatype.NONE);
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, (CoreDatatype)null));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, (CoreDatatype)CoreDatatype.XSD.STRING));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.literal(null, (CoreDatatype)CoreDatatype.RDF.LANGSTRING));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.literal("", (CoreDatatype)CoreDatatype.RDF.LANGSTRING));
    }

    @Test(expected=NullPointerException.class)
    public final void testCoreDatatypeTypedConstructorNullDatatype() {
        this.literal("label", (CoreDatatype)null);
    }

    @Test
    public void testCoreDatatypeStringValue() {
        String label = "literal";
        String language = "en";
        CoreDatatype.XSD datatype = CoreDatatype.XSD.DECIMAL;
        Assertions.assertThat((String)this.literal(label).stringValue()).isEqualTo(label);
        Assertions.assertThat((String)this.literal(label, language).stringValue()).isEqualTo(label);
        Assertions.assertThat((String)this.literal(label, (CoreDatatype)datatype).stringValue()).isEqualTo(label);
    }

    @Test
    public void testCoreDatatypeBooleanValue() {
        CoreDatatype.XSD datatype = CoreDatatype.XSD.BOOLEAN;
        Assertions.assertThat((boolean)this.literal("true", (CoreDatatype)datatype).booleanValue()).isTrue();
        Assertions.assertThat((boolean)this.literal("false", (CoreDatatype)datatype).booleanValue()).isFalse();
        Assertions.assertThat((boolean)this.literal("1", (CoreDatatype)datatype).booleanValue()).isTrue();
        Assertions.assertThat((boolean)this.literal("0", (CoreDatatype)datatype).booleanValue()).isFalse();
        Assertions.assertThat((boolean)this.literal("\ttrue", (CoreDatatype)datatype).booleanValue()).isTrue();
        Assertions.assertThat((boolean)this.literal("false\t", (CoreDatatype)datatype).booleanValue()).isFalse();
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeBooleanValue$64((CoreDatatype)datatype));
    }

    @Test
    public final void testCoreDatatypeByteValue() {
        CoreDatatype.XSD datatype = CoreDatatype.XSD.BYTE;
        Class<Byte> type = Byte.class;
        ((AbstractByteAssert)Assertions.assertThat((byte)this.literal("100", (CoreDatatype)datatype).byteValue()).isInstanceOf(type)).isEqualTo((byte)100);
        ((AbstractByteAssert)Assertions.assertThat((byte)this.literal("+100", (CoreDatatype)datatype).byteValue()).isInstanceOf(type)).isEqualTo((byte)100);
        ((AbstractByteAssert)Assertions.assertThat((byte)this.literal("-100", (CoreDatatype)datatype).byteValue()).isInstanceOf(type)).isEqualTo((byte)-100);
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeByteValue$65((CoreDatatype)datatype));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeByteValue$66((CoreDatatype)datatype));
    }

    @Test
    public final void testCoreDatatypeShortValue() {
        CoreDatatype.XSD datatype = CoreDatatype.XSD.SHORT;
        Class<Short> type = Short.class;
        ((AbstractShortAssert)Assertions.assertThat((short)this.literal("100", (CoreDatatype)datatype).shortValue()).isInstanceOf(type)).isEqualTo((short)100);
        ((AbstractShortAssert)Assertions.assertThat((short)this.literal("+100", (CoreDatatype)datatype).shortValue()).isInstanceOf(type)).isEqualTo((short)100);
        ((AbstractShortAssert)Assertions.assertThat((short)this.literal("-100", (CoreDatatype)datatype).shortValue()).isInstanceOf(type)).isEqualTo((short)-100);
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeShortValue$67((CoreDatatype)datatype));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeShortValue$68((CoreDatatype)datatype));
    }

    @Test
    public final void testCoreDatatypeIntValue() {
        CoreDatatype.XSD datatype = CoreDatatype.XSD.INT;
        Class<Integer> type = Integer.class;
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.literal("100", (CoreDatatype)datatype).intValue()).isInstanceOf(type)).isEqualTo(100);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.literal("+100", (CoreDatatype)datatype).intValue()).isInstanceOf(type)).isEqualTo(100);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.literal("-100", (CoreDatatype)datatype).intValue()).isInstanceOf(type)).isEqualTo(-100);
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeIntValue$69((CoreDatatype)datatype));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeIntValue$70((CoreDatatype)datatype));
    }

    @Test
    public final void testCoreDatatypeLongValue() {
        CoreDatatype.XSD datatype = CoreDatatype.XSD.LONG;
        Class<Long> type = Long.class;
        ((AbstractLongAssert)Assertions.assertThat((long)this.literal("100", (CoreDatatype)datatype).longValue()).isInstanceOf(type)).isEqualTo(100L);
        ((AbstractLongAssert)Assertions.assertThat((long)this.literal("+100", (CoreDatatype)datatype).longValue()).isInstanceOf(type)).isEqualTo(100L);
        ((AbstractLongAssert)Assertions.assertThat((long)this.literal("-100", (CoreDatatype)datatype).longValue()).isInstanceOf(type)).isEqualTo(-100L);
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeLongValue$71((CoreDatatype)datatype));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeLongValue$72((CoreDatatype)datatype));
    }

    @Test
    public final void testCoreDatatypeFloatValue() {
        CoreDatatype.XSD datatype = CoreDatatype.XSD.FLOAT;
        Class<Float> type = Float.class;
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("100", (CoreDatatype)datatype).floatValue()).isInstanceOf(type)).isEqualTo(100.0f);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("+100", (CoreDatatype)datatype).floatValue()).isInstanceOf(type)).isEqualTo(100.0f);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("-100", (CoreDatatype)datatype).floatValue()).isInstanceOf(type)).isEqualTo(-100.0f);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("100.0", (CoreDatatype)datatype).floatValue()).isInstanceOf(type)).isEqualTo(100.0f);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("10e1", (CoreDatatype)datatype).floatValue()).isInstanceOf(type)).isEqualTo(100.0f);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("INF", (CoreDatatype)datatype).floatValue()).isInstanceOf(type)).isEqualTo(Float.POSITIVE_INFINITY);
        ((AbstractFloatAssert)Assertions.assertThat((float)this.literal("-INF", (CoreDatatype)datatype).floatValue()).isInstanceOf(type)).isEqualTo(Float.NEGATIVE_INFINITY);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Float.isNaN(this.literal("NaN", (CoreDatatype)datatype).floatValue()));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeFloatValue$73((CoreDatatype)datatype));
    }

    @Test
    public final void testCoreDatatypeDoubleValue() {
        CoreDatatype.XSD datatype = CoreDatatype.XSD.DOUBLE;
        Class<Double> type = Double.class;
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("100", (CoreDatatype)datatype).doubleValue()).isInstanceOf(type)).isEqualTo(100.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("+100", (CoreDatatype)datatype).doubleValue()).isInstanceOf(type)).isEqualTo(100.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("-100", (CoreDatatype)datatype).doubleValue()).isInstanceOf(type)).isEqualTo(-100.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("100.0", (CoreDatatype)datatype).doubleValue()).isInstanceOf(type)).isEqualTo(100.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("10e1", (CoreDatatype)datatype).doubleValue()).isInstanceOf(type)).isEqualTo(100.0);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("INF", (CoreDatatype)datatype).doubleValue()).isInstanceOf(type)).isEqualTo(Double.POSITIVE_INFINITY);
        ((AbstractDoubleAssert)Assertions.assertThat((double)this.literal("-INF", (CoreDatatype)datatype).doubleValue()).isInstanceOf(type)).isEqualTo(Double.NEGATIVE_INFINITY);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isNaN(this.literal("NaN", (CoreDatatype)datatype).doubleValue()));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeDoubleValue$74((CoreDatatype)datatype));
    }

    @Test
    public final void testCoreDatatypeIntegerValue() {
        CoreDatatype.XSD datatype = CoreDatatype.XSD.INTEGER;
        Class<BigInteger> type = BigInteger.class;
        ((AbstractBigIntegerAssert)Assertions.assertThat((BigInteger)this.literal("100", (CoreDatatype)datatype).integerValue()).isInstanceOf(type)).isEqualTo(100);
        ((AbstractBigIntegerAssert)Assertions.assertThat((BigInteger)this.literal("+100", (CoreDatatype)datatype).integerValue()).isInstanceOf(type)).isEqualTo(100);
        ((AbstractBigIntegerAssert)Assertions.assertThat((BigInteger)this.literal("-100", (CoreDatatype)datatype).integerValue()).isInstanceOf(type)).isEqualTo(-100);
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeIntegerValue$75((CoreDatatype)datatype));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeIntegerValue$76((CoreDatatype)datatype));
    }

    @Test
    public final void testCoreDatatypeDecimalValue() {
        CoreDatatype.XSD datatype = CoreDatatype.XSD.DECIMAL;
        Class<BigDecimal> type = BigDecimal.class;
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)this.literal("100", (CoreDatatype)datatype).decimalValue()).isInstanceOf(type)).isEqualTo((Object)new BigDecimal("100"));
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)this.literal("+100", (CoreDatatype)datatype).decimalValue()).isInstanceOf(type)).isEqualTo((Object)new BigDecimal("100"));
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)this.literal("-100", (CoreDatatype)datatype).decimalValue()).isInstanceOf(type)).isEqualTo((Object)new BigDecimal("-100"));
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)this.literal("100.0", (CoreDatatype)datatype).decimalValue()).isInstanceOf(type)).isEqualTo((Object)new BigDecimal("100.0"));
        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)this.literal("10e1", (CoreDatatype)datatype).decimalValue()).isInstanceOf(type)).isEqualTo((Object)new BigDecimal("1.0e2"));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeDecimalValue$77((CoreDatatype)datatype));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.lambda$testCoreDatatypeDecimalValue$78((CoreDatatype)datatype));
    }

    @Test
    public final void testCoreDatatypeTemporalDateTimeValue() {
        String integral = "2020-09-29T01:02:03";
        String fractional = "2020-09-29T01:02:03.004";
        String offset = "2020-09-29T01:02:03+05:00";
        String zero = "2020-09-29T01:02:03Z";
        Assertions.assertThat((LocalDateTime)LocalDateTime.from(this.literal(integral, (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue())).isEqualTo((Object)LocalDateTime.parse(integral));
        Assertions.assertThat((LocalDateTime)LocalDateTime.from(this.literal(fractional, (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue())).isEqualTo((Object)LocalDateTime.parse(fractional));
        Assertions.assertThat((OffsetDateTime)OffsetDateTime.from(this.literal(offset, (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue())).isEqualTo((Object)OffsetDateTime.parse(offset));
        Assertions.assertThat((OffsetDateTime)OffsetDateTime.from(this.literal(zero, (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue())).isEqualTo((Object)OffsetDateTime.parse(zero));
        Stream.of("0001-01-01T00:00:00", "0001-01-01T00:00:00.0", "0001-01-01T00:00:00Z", "0001-01-01T00:00:00.0Z", "0001-01-01T00:00:00+00:00", "0001-01-01T00:00:00.0+00:00", "0001-01-01T00:00:00.0-00:00", "0001-01-01T00:00:00.0+14:00", "0001-01-01T00:00:00.0-14:00", "0001-05-31T00:00:00.00", "0001-07-31T00:00:00.00", "0001-08-31T00:00:00.00", "0001-10-31T00:00:00.00", "0001-12-31T00:00:00.00", "-0001-01-01T00:00:00", "1234-12-31T23:59:59", "1234-12-31T24:00:00", "2004-02-29T00:00:00").forEach(value -> ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.literal((String)value, (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue()).as(value, new Object[0])).doesNotThrowAnyException());
    }

    @Test
    public final void testCoreDatatypeTemporalTimeValue() {
        String integral = "01:02:03";
        String fractional = "01:02:03.004";
        String offset = "01:02:03+05:00";
        String zero = "01:02:03Z";
        Assertions.assertThat((LocalTime)LocalTime.from(this.literal(integral, (CoreDatatype)CoreDatatype.XSD.TIME).temporalAccessorValue())).isEqualTo((Object)LocalTime.parse(integral));
        Assertions.assertThat((LocalTime)LocalTime.from(this.literal(fractional, (CoreDatatype)CoreDatatype.XSD.TIME).temporalAccessorValue())).isEqualTo((Object)LocalTime.parse(fractional));
        Assertions.assertThat((OffsetTime)OffsetTime.from(this.literal(offset, (CoreDatatype)CoreDatatype.XSD.TIME).temporalAccessorValue())).isEqualTo((Object)OffsetTime.parse(offset));
        Assertions.assertThat((OffsetTime)OffsetTime.from(this.literal(zero, (CoreDatatype)CoreDatatype.XSD.TIME).temporalAccessorValue())).isEqualTo((Object)OffsetTime.parse(zero));
    }

    @Test
    public final void testCoreDatatypeTemporalDateValue() {
        String local = "2020-11-14";
        String offset = "2020-11-14+05:00";
        String zero = "2020-11-14Z";
        Assertions.assertThat((LocalDate)LocalDate.from(this.literal(local, (CoreDatatype)CoreDatatype.XSD.DATE).temporalAccessorValue())).isEqualTo((Object)LocalDate.parse(local));
        Assertions.assertThat((LocalDate)LocalDate.from(this.literal(offset, (CoreDatatype)CoreDatatype.XSD.DATE).temporalAccessorValue())).isEqualTo((Object)LocalDate.parse(offset.substring(0, 10)));
        Assertions.assertThat((LocalDate)LocalDate.from(this.literal(zero, (CoreDatatype)CoreDatatype.XSD.DATE).temporalAccessorValue())).isEqualTo((Object)LocalDate.parse(offset.substring(0, 10)));
    }

    @Test
    public final void testCoreDatatypeTemporalGYearMonthValue() {
        String base = "2020-11";
        Assertions.assertThat((Comparable)YearMonth.from(this.literal(base, (CoreDatatype)CoreDatatype.XSD.GYEARMONTH).temporalAccessorValue())).isEqualTo((Object)YearMonth.parse(base));
    }

    @Test
    public final void testCoreDatatypeTemporalGYearValue() {
        String local = "2020";
        Assertions.assertThat((Comparable)Year.from(this.literal(local, (CoreDatatype)CoreDatatype.XSD.GYEAR).temporalAccessorValue())).isEqualTo((Object)Year.parse(local));
    }

    @Test
    public final void testCoreDatatypeTemporalGMonthDayValue() {
        String local = "--11-14";
        Assertions.assertThat((Comparable)MonthDay.from(this.literal(local, (CoreDatatype)CoreDatatype.XSD.GMONTHDAY).temporalAccessorValue())).isEqualTo((Object)MonthDay.parse(local));
    }

    @Test
    public final void testCoreDatatypeTemporalGDayValue() {
        String local = "---14";
        Assertions.assertThat((int)this.literal(local, (CoreDatatype)CoreDatatype.XSD.GDAY).temporalAccessorValue().get(ChronoField.DAY_OF_MONTH)).isEqualTo(14);
    }

    @Test
    public final void testCoreDatatypeTemporalGMonthValue() {
        String local = "--11";
        Assertions.assertThat((Comparable)((Object)Month.from(this.literal(local, (CoreDatatype)CoreDatatype.XSD.GMONTH).temporalAccessorValue()))).isEqualTo((Object)Month.NOVEMBER);
    }

    @Test
    public final void testCoreDatatypeTemporalAccessorMalformedValue() {
        Assertions.assertThatExceptionOfType(DateTimeException.class).isThrownBy(() -> this.literal("", (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue());
        Assertions.assertThatExceptionOfType(DateTimeException.class).isThrownBy(() -> this.literal("--", (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("no time components", new Object[0])).isThrownBy(() -> this.literal("2020-11-16T", (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("missing fractional digits after dot", new Object[0])).isThrownBy(() -> this.literal("2020-11-16T11:12:13.", (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue());
        Assertions.assertThatExceptionOfType(DateTimeException.class).isThrownBy(() -> this.literal("malformed", (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("no time components", new Object[0])).isThrownBy(() -> this.literal("2020-11-16T", (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("missing fractional digits after dot", new Object[0])).isThrownBy(() -> this.literal("2020-11-16T11:12:13.", (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue());
        Stream.of("foo", "Mon, 11 Jul 2005 09:22:29 +0200", "0001-01-01T00:00", "0001-01-01T00:00.00", "0001-13-01T00:00:00.00", "0001-01-32T00:00:00.00", "0001-01-01T25:00:00.00", "0001-01-01T00:61:00.00", "0001-01-01T00:00:61.00", "0001-01-01T00:00.00+15:00", "0001-01-01T00:00.00-15:00", "001-01-01T00:00:00.0", "0001-1-01T00:00:00.0", "0001-01-1T00:00:00.0", "0001-01-01T0:00:00.0", "0001-01-01T00:0:00.0", "0001-01-01T00:00:0.0", "0001/01-01T00:00:00.0", "0001-01/01T00:00:00.0", "0001-01-01t00:00:00.0", "0001-01-01T00.00:00.0", "0001-01-01T00:00.00.0", "0001-01-01T00:00:00:0", "0001-01-01T00:00.00+0:00", "0001-01-01T00:00.00+00:0", "0001-jan-01T00:00:00", "0001-01-01T00:00:00+00:00Z", "0001-01-01T24:01:00", "0001-01-01T24:00:01", "00001-01-01T00:00:00", "0001-001-01T00:00:00", "0001-01-001T00:00:00", "0001-01-01T000:00:00", "0001-01-01T00:000:00", "0001-01-01T00:00:000", "0001-01-01T00:00:000", "0001-01-01T00:00:00z", "0001-01-01T00:00:00+05", "0001-01-01T00:00:00+0500", "0001-01-01T00:00:00GMT", "0001-01-01T00:00:00PST", "0001-01-01T00:00:00GMT+05", "-0000-01-01T00:00:00", "+0001-01-01T00:00:00").forEach(value -> ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as(value, new Object[0])).isThrownBy(() -> this.literal((String)value, (CoreDatatype)CoreDatatype.XSD.DATETIME).temporalAccessorValue()));
    }

    @Test
    public final void testCoreDatatypeTemporalDurationValue() {
        String period = "P1Y2M3D";
        String duration = "PT1H2M3.4S";
        Assertions.assertThat((Period)Period.from(this.literal(period, (CoreDatatype)CoreDatatype.XSD.DURATION).temporalAmountValue())).isEqualTo((Object)Period.parse(period));
        Assertions.assertThat((Period)Period.from(this.literal("-P1Y2M3D", (CoreDatatype)CoreDatatype.XSD.DURATION).temporalAmountValue())).isEqualTo((Object)Period.parse(period).negated());
        Assertions.assertThat((Duration)Duration.from(this.literal(duration, (CoreDatatype)CoreDatatype.XSD.DURATION).temporalAmountValue())).isEqualTo((Object)Duration.parse(duration));
    }

    @Test
    public final void testCoreDatatypeTemporalAmountMalformedValue() {
        Assertions.assertThatExceptionOfType(DateTimeException.class).isThrownBy(() -> this.literal("", (CoreDatatype)CoreDatatype.XSD.DURATION).temporalAmountValue());
        Assertions.assertThatExceptionOfType(DateTimeException.class).isThrownBy(() -> this.literal("malformed", (CoreDatatype)CoreDatatype.XSD.DURATION).temporalAmountValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("no  components", new Object[0])).isThrownBy(() -> this.literal("P", (CoreDatatype)CoreDatatype.XSD.DURATION).temporalAmountValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("no time components", new Object[0])).isThrownBy(() -> this.literal("P1Y2MT", (CoreDatatype)CoreDatatype.XSD.DURATION).temporalAmountValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("negative component", new Object[0])).isThrownBy(() -> this.literal("P-1347M ", (CoreDatatype)CoreDatatype.XSD.DURATION).temporalAmountValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("no time separator", new Object[0])).isThrownBy(() -> this.literal("P1Y1S ", (CoreDatatype)CoreDatatype.XSD.DURATION).temporalAmountValue());
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(DateTimeException.class).as("missing fractional digits after dot", new Object[0])).isThrownBy(() -> this.literal("PT1.S", (CoreDatatype)CoreDatatype.XSD.DURATION).temporalAmountValue());
    }

    @Test
    public final void testCoreDatatypeCalendarValue() throws DatatypeConfigurationException {
        Class<XMLGregorianCalendar> type = XMLGregorianCalendar.class;
        DatatypeFactory factory = DatatypeFactory.newInstance();
        Function<Consumer, XMLGregorianCalendar> setup = consumer -> {
            XMLGregorianCalendar calendar = factory.newXMLGregorianCalendar();
            consumer.accept(calendar);
            return calendar;
        };
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("2020-09-29T01:02:03.004Z", (CoreDatatype)CoreDatatype.XSD.DATETIME).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> {
            calendar.setYear(2020);
            calendar.setMonth(9);
            calendar.setDay(29);
            calendar.setTime(1, 2, 3, 4);
            calendar.setTimezone(0);
        }));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("01:02:03.004", (CoreDatatype)CoreDatatype.XSD.TIME).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> calendar.setTime(1, 2, 3, 4)));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("2020-09-29", (CoreDatatype)CoreDatatype.XSD.DATE).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> {
            calendar.setYear(2020);
            calendar.setMonth(9);
            calendar.setDay(29);
        }));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("2020-09", (CoreDatatype)CoreDatatype.XSD.GYEARMONTH).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> {
            calendar.setYear(2020);
            calendar.setMonth(9);
        }));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("--09-29", (CoreDatatype)CoreDatatype.XSD.GMONTHDAY).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> {
            calendar.setMonth(9);
            calendar.setDay(29);
        }));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("2020", (CoreDatatype)CoreDatatype.XSD.GYEAR).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> calendar.setYear(2020)));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("--09", (CoreDatatype)CoreDatatype.XSD.GMONTH).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> calendar.setMonth(9)));
        ((ObjectAssert)Assertions.assertThat((Object)this.literal("---29", (CoreDatatype)CoreDatatype.XSD.GDAY).calendarValue()).isInstanceOf(type)).isEqualTo((Object)setup.apply(calendar -> calendar.setDay(29)));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("not normalized", new Object[0])).isThrownBy(() -> this.literal("\t100", (CoreDatatype)CoreDatatype.XSD.DATETIME).calendarValue());
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("malformed", new Object[0])).isThrownBy(() -> this.literal("malformed", (CoreDatatype)CoreDatatype.XSD.DATETIME).calendarValue());
    }

    @Test
    public void testCoreDatatypeEqualsAndHashCode() {
        Literal plain = this.literal("plain");
        Literal tagged = this.literal("tagged", "en");
        Literal typed = this.literal("typed", this.datatype("http://example.org/datatype"));
        Literal _plain = this.literal(plain.getLabel());
        Literal _tagged = this.literal(tagged.getLabel(), tagged.getLanguage().orElse(""));
        Literal _typed = this.literal(typed.getLabel(), typed.getDatatype());
        Assertions.assertThat((Object)plain).isEqualTo((Object)plain);
        Assertions.assertThat((Object)plain).isEqualTo((Object)_plain);
        Assertions.assertThat((Object)tagged).isEqualTo((Object)tagged);
        Assertions.assertThat((Object)tagged).isEqualTo((Object)_tagged);
        Assertions.assertThat((Object)typed).isEqualTo((Object)typed);
        Assertions.assertThat((Object)typed).isEqualTo((Object)_typed);
        Assertions.assertThat((Object)plain).isNotEqualTo(null);
        Assertions.assertThat((Object)plain).isNotEqualTo(new Object());
        Assertions.assertThat((Object)plain).isNotEqualTo((Object)tagged);
        Assertions.assertThat((Object)plain).isNotEqualTo((Object)typed);
        Assertions.assertThat((Object)tagged).isNotEqualTo((Object)typed);
        Assertions.assertThat((Object)plain).isNotEqualTo((Object)this.literal("other"));
        Assertions.assertThat((Object)tagged).isNotEqualTo((Object)this.literal(tagged.getLabel(), "other"));
        Assertions.assertThat((Object)typed).isNotEqualTo((Object)this.literal(typed.getLabel(), "http://example.org/other"));
        Assertions.assertThat((int)plain.hashCode()).isEqualTo(_plain.hashCode());
        Assertions.assertThat((int)tagged.hashCode()).isEqualTo(_tagged.hashCode());
        Assertions.assertThat((int)typed.hashCode()).isEqualTo(_typed.hashCode());
        ((AbstractIntegerAssert)Assertions.assertThat((int)tagged.hashCode()).as("computed according to contract", new Object[0])).isEqualTo(tagged.getLabel().hashCode());
    }

    @Test
    public final void testCoreDatatypeEqualsAndHashCodeCaseInsensitiveLanguage() {
        Literal lowercase = this.literal("label", "en");
        Literal uppercase = this.literal("label", "EN");
        Assertions.assertThat((Object)lowercase).isEqualTo((Object)uppercase);
        Assertions.assertThat((int)lowercase.hashCode()).isEqualTo(uppercase.hashCode());
    }

    @Test
    public final void testCoreDatatypeEqualsAndHashCodeXSDString() {
        Literal plain = this.literal("label");
        Literal typed = this.literal("label", (CoreDatatype)CoreDatatype.XSD.STRING);
        Assertions.assertThat((Object)plain).isEqualTo((Object)typed);
        Assertions.assertThat((int)plain.hashCode()).isEqualTo(typed.hashCode());
    }

    private /* synthetic */ void lambda$testCoreDatatypeDecimalValue$78(CoreDatatype datatype) throws Throwable {
        this.literal("malformed", datatype).decimalValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeDecimalValue$77(CoreDatatype datatype) throws Throwable {
        this.literal("\t100", datatype).decimalValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeIntegerValue$76(CoreDatatype datatype) throws Throwable {
        this.literal("malformed", datatype).integerValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeIntegerValue$75(CoreDatatype datatype) throws Throwable {
        this.literal("\t100", datatype).integerValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeDoubleValue$74(CoreDatatype datatype) throws Throwable {
        this.literal("malformed", datatype).doubleValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeFloatValue$73(CoreDatatype datatype) throws Throwable {
        this.literal("malformed", datatype).floatValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeLongValue$72(CoreDatatype datatype) throws Throwable {
        this.literal("malformed", datatype).longValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeLongValue$71(CoreDatatype datatype) throws Throwable {
        this.literal("\t100", datatype).longValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeIntValue$70(CoreDatatype datatype) throws Throwable {
        this.literal("malformed", datatype).intValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeIntValue$69(CoreDatatype datatype) throws Throwable {
        this.literal("\t100", datatype).intValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeShortValue$68(CoreDatatype datatype) throws Throwable {
        this.literal("malformed", datatype).shortValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeShortValue$67(CoreDatatype datatype) throws Throwable {
        this.literal("\t100", datatype).shortValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeByteValue$66(CoreDatatype datatype) throws Throwable {
        this.literal("malformed", datatype).booleanValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeByteValue$65(CoreDatatype datatype) throws Throwable {
        this.literal("\t100", datatype).byteValue();
    }

    private /* synthetic */ void lambda$testCoreDatatypeBooleanValue$64(CoreDatatype datatype) throws Throwable {
        this.literal("malformed", datatype).booleanValue();
    }
}

