/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableTypeAssert;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.junit.Test;

public abstract class ValueFactoryTest {
    protected abstract ValueFactory factory();

    @Test
    public void testCreateBNode() {
        BNode bnode = this.factory().createBNode();
        Assertions.assertThat((Object)bnode).isNotNull();
        Assertions.assertThat((String)bnode.getID()).isNotNull();
    }

    @Test
    public void testCreateLiteralBoolean() {
        Literal _true = this.factory().createLiteral(true);
        Assertions.assertThat((Object)_true).isNotNull();
        Assertions.assertThat((boolean)_true.booleanValue()).isTrue();
        Assertions.assertThat((String)_true.getLabel()).isEqualTo("true");
        Assertions.assertThat((String)_true.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#boolean");
        Literal _false = this.factory().createLiteral(false);
        Assertions.assertThat((Object)_false).isNotNull();
        Assertions.assertThat((boolean)_false.booleanValue()).isFalse();
        Assertions.assertThat((String)_false.getLabel()).isEqualTo("false");
        Assertions.assertThat((String)_false.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#boolean");
    }

    @Test
    public void testCreateLiteralByte() {
        int value = 42;
        Literal literal = this.factory().createLiteral((byte)42);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((byte)literal.byteValue()).isEqualTo((byte)42);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("42");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#byte");
    }

    @Test
    public void testCreateLiteralShort() {
        int value = 42;
        Literal literal = this.factory().createLiteral((short)42);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((short)literal.shortValue()).isEqualTo((short)42);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("42");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#short");
    }

    @Test
    public void testCreateLiteralInt() {
        int value = 42;
        Literal literal = this.factory().createLiteral(42);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((int)literal.intValue()).isEqualTo(42);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("42");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#int");
    }

    @Test
    public void testCreateLiteralLong() {
        long value = 42L;
        Literal literal = this.factory().createLiteral(42L);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((long)literal.longValue()).isEqualTo(42L);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("42");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#long");
    }

    @Test
    public void testCreateLiteralFloat() {
        float value = 42.0f;
        ValueFactory factory = this.factory();
        Literal literal = factory.createLiteral(42.0f);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((float)literal.floatValue()).isEqualTo(42.0f);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("42.0");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#float");
        Assertions.assertThat((String)factory.createLiteral(Float.POSITIVE_INFINITY).getLabel()).isEqualTo("INF");
        Assertions.assertThat((String)factory.createLiteral(Float.NEGATIVE_INFINITY).getLabel()).isEqualTo("-INF");
        Assertions.assertThat((String)factory.createLiteral(Float.NaN).getLabel()).isEqualTo("NaN");
    }

    @Test
    public void testCreateLiteralDouble() {
        double value = 42.0;
        ValueFactory factory = this.factory();
        Literal literal = factory.createLiteral(42.0);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((double)literal.doubleValue()).isEqualTo(42.0);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("42.0");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#double");
        Assertions.assertThat((String)factory.createLiteral(Double.POSITIVE_INFINITY).getLabel()).isEqualTo("INF");
        Assertions.assertThat((String)factory.createLiteral(Double.NEGATIVE_INFINITY).getLabel()).isEqualTo("-INF");
        Assertions.assertThat((String)factory.createLiteral(Double.NaN).getLabel()).isEqualTo("NaN");
    }

    @Test
    public void testCreateLiteralInteger() {
        BigInteger value = new BigInteger("42");
        Literal literal = this.factory().createLiteral(value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((BigInteger)literal.integerValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("42");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#integer");
    }

    @Test
    public void testCreateLiteralDecimal() {
        BigDecimal value = new BigDecimal("42.0");
        Literal literal = this.factory().createLiteral(value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((BigDecimal)literal.decimalValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("42.0");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#decimal");
    }

    @Test
    public void testCreateLiteralTemporalNull() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.factory().createLiteral((TemporalAccessor)null));
    }

    @Test
    public void testCreateLiteralTemporalLocalDateTime() {
        LocalDateTime value = LocalDateTime.parse("2020-09-30T01:02:03.004");
        Literal literal = this.factory().createLiteral((TemporalAccessor)value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAccessorValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(value.toString());
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#dateTime");
    }

    @Test
    public void testCreateLiteralTemporalOffsetDateTime() {
        OffsetDateTime value = OffsetDateTime.parse("2020-09-30T01:02:03.004Z");
        Literal literal = this.factory().createLiteral((TemporalAccessor)value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAccessorValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(value.toString());
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#dateTime");
    }

    @Test
    public void testCreateLiteralTemporalLocalTime() {
        LocalTime value = LocalTime.parse("01:02:03.004");
        Literal literal = this.factory().createLiteral((TemporalAccessor)value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAccessorValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(value.toString());
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#time");
    }

    @Test
    public void testCreateLiteralTemporalOffsetTime() {
        OffsetTime value = OffsetTime.parse("01:02:03.004Z");
        Literal literal = this.factory().createLiteral((TemporalAccessor)value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAccessorValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(value.toString());
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#time");
    }

    @Test
    public void testCreateLiteralTemporalLocalDate() {
        LocalDate value = LocalDate.parse("2020-11-14");
        Literal literal = this.factory().createLiteral((TemporalAccessor)value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAccessorValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(value.toString());
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#date");
    }

    @Test
    public void testCreateLiteralTemporalOffsetDate() {
        String label = "2020-09-30Z";
        TemporalAccessor value = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendOffsetId().toFormatter().parse("2020-09-30Z");
        Literal literal = this.factory().createLiteral(value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAccessorValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("2020-09-30Z");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#date");
    }

    @Test
    public void testCreateLiteralTemporalYearMonth() {
        YearMonth value = YearMonth.parse("2020-09");
        Literal literal = this.factory().createLiteral((TemporalAccessor)value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAccessorValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(value.toString());
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#gYearMonth");
    }

    @Test
    public void testCreateLiteralTemporalYear() {
        Year value = Year.parse("2020");
        Literal literal = this.factory().createLiteral((TemporalAccessor)value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAccessorValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(value.toString());
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#gYear");
    }

    @Test
    public void testCreateLiteralTemporalMonthDay() {
        MonthDay value = MonthDay.parse("--11-14");
        Literal literal = this.factory().createLiteral((TemporalAccessor)value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAccessorValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(value.toString());
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#gMonthDay");
    }

    @Test
    public void testCreateLiteralTemporalDay() {
        TemporalAccessor value = new TemporalAccessor(){

            @Override
            public boolean isSupported(TemporalField field) {
                return field.equals(ChronoField.DAY_OF_MONTH);
            }

            @Override
            public long getLong(TemporalField field) {
                if (field == ChronoField.DAY_OF_MONTH) {
                    return 14L;
                }
                throw new UnsupportedTemporalTypeException(field.toString());
            }
        };
        Literal literal = this.factory().createLiteral(value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAccessorValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("---14");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#gDay");
    }

    @Test
    public void testCreateLiteralTemporalMonth() {
        Month value = Month.NOVEMBER;
        Literal literal = this.factory().createLiteral((TemporalAccessor)value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAccessorValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo("--11");
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#gMonth");
    }

    @Test
    public void testCreateLiteralTemporalAccessorUnsupported() {
        TemporalAccessor accessor = new TemporalAccessor(){

            @Override
            public boolean isSupported(TemporalField field) {
                return field.equals(ChronoField.SECOND_OF_DAY);
            }

            @Override
            public long getLong(TemporalField field) {
                if (field == ChronoField.SECOND_OF_DAY) {
                    return 123L;
                }
                throw new UnsupportedTemporalTypeException(field.toString());
            }
        };
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.factory().createLiteral(accessor));
    }

    @Test
    public void testCreateLiteralTemporalPeriod() {
        Period value = Period.parse("P1Y");
        Literal literal = this.factory().createLiteral((TemporalAmount)value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAmountValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(value.toString());
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#duration");
    }

    @Test
    public void testCreateLiteralTemporalDuration() {
        Duration value = Duration.ofSeconds(7L);
        Literal literal = this.factory().createLiteral((TemporalAmount)value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.temporalAmountValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(value.toString());
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#duration");
    }

    @Test
    public void testCreateLiteralTemporalAmountUnsupported() {
        class TestAmount
        implements TemporalAmount {
            private final List<TemporalUnit> units;

            private TestAmount(ChronoUnit ... units) {
                this.units = Collections.unmodifiableList(Arrays.asList(units));
            }

            @Override
            public long get(TemporalUnit unit) {
                return unit.isDateBased() ? 1L : -1L;
            }

            @Override
            public List<TemporalUnit> getUnits() {
                return this.units;
            }

            @Override
            public Temporal addTo(Temporal temporal) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Temporal subtractFrom(Temporal temporal) {
                throw new UnsupportedOperationException();
            }
        }
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("unsupported components", new Object[0])).isThrownBy(() -> this.factory().createLiteral((TemporalAmount)new TestAmount(ChronoUnit.HALF_DAYS)));
        ((ThrowableTypeAssert)Assertions.assertThatIllegalArgumentException().as("mixed sign components", new Object[0])).isThrownBy(() -> this.factory().createLiteral((TemporalAmount)new TestAmount(ChronoUnit.YEARS, ChronoUnit.HOURS)));
    }

    @Test
    public void testCreateLiteralXMLGregorianCalendar() throws DatatypeConfigurationException {
        XMLGregorianCalendar value = DatatypeFactory.newInstance().newXMLGregorianCalendar("2020-09-30T01:02:03.004Z");
        Literal literal = this.factory().createLiteral(value);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.calendarValue()).isEqualTo((Object)value);
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(value.toString());
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#dateTime");
    }

    @Test
    public void testCreateLiteralDate() throws DatatypeConfigurationException {
        Date date = new Date(2020, 9, 30, 1, 2, 3);
        String string = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(date);
        Literal literal = this.factory().createLiteral(date);
        Assertions.assertThat((Object)literal).isNotNull();
        Assertions.assertThat((Object)literal.calendarValue()).isEqualTo((Object)DatatypeFactory.newInstance().newXMLGregorianCalendar(string));
        Assertions.assertThat((String)literal.getLabel()).isEqualTo(string);
        Assertions.assertThat((String)literal.getDatatype().stringValue()).isEqualTo("http://www.w3.org/2001/XMLSchema#dateTime");
    }
}

