/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model;

import java.util.Objects;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.Namespace;
import org.junit.jupiter.api.Test;

public abstract class NamespaceTest {
    protected abstract Namespace namespace(String var1, String var2);

    @Test
    public void compareTo() {
        Namespace x = this.namespace("com", "http://example.org/x");
        Namespace y = this.namespace("org", "http://example.org/y");
        Namespace z = this.namespace("org", "http://example.org/z");
        Assertions.assertThat((Comparable)x).isEqualByComparingTo((Comparable)x);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)x).as("nulls first", new Object[0])).isGreaterThan(null);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)x).as("less by prefix", new Object[0])).isLessThan((Comparable)y);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)y).as("greater by prefix", new Object[0])).isGreaterThan((Comparable)x);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)y).as("less by name", new Object[0])).isLessThan((Comparable)z);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)z).as("greater by name", new Object[0])).isGreaterThan((Comparable)y);
    }

    @Test
    public void testEquals() {
        Namespace x = this.namespace("com", "http://example.org/x");
        Namespace y = this.namespace("org", "http://example.org/y");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)x).as("same object", new Object[0])).isEqualTo((Object)x);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)x).as("same class", new Object[0])).isEqualTo((Object)this.namespace(x.getPrefix(), x.getName()));
        Assertions.assertThat((Comparable)x).isNotEqualTo(null);
        Assertions.assertThat((Comparable)x).isNotEqualTo(new Object());
        Assertions.assertThat((Comparable)x).isNotEqualTo((Object)y);
    }

    @Test
    public void testHashCode() {
        Namespace namespace = this.namespace("com", "http://example.org/x");
        ((AbstractIntegerAssert)Assertions.assertThat((int)namespace.hashCode()).as("computed according to contract", new Object[0])).isEqualTo(Objects.hash(namespace.getPrefix(), namespace.getName()));
    }
}

