/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.base.AbstractIRI;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.base.CoreDatatypeHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CoreDatatypeTest {
    @Test
    public void testOrderOfXSD() {
        ArrayList<CoreDatatype.XSD> datatypes = this.getXSDDatatypesShuffled();
        List datatypeIRIs = this.getXSDDatatypesShuffled().stream().map(CoreDatatype::getIri).map(Object::toString).collect(Collectors.toList());
        Collections.sort(datatypes);
        Collections.sort(datatypeIRIs);
        List datatypeIRIsSortedByEnum = datatypes.stream().map(CoreDatatype::getIri).map(Object::toString).collect(Collectors.toList());
        Assertions.assertEquals(datatypeIRIs, datatypeIRIsSortedByEnum);
    }

    @Test
    public void testOrderOfRDF() {
        ArrayList<CoreDatatype.RDF> datatypes = this.getRDFDatatypesShuffled();
        List datatypeIRIs = this.getRDFDatatypesShuffled().stream().map(CoreDatatype::getIri).map(Object::toString).collect(Collectors.toList());
        Collections.sort(datatypes);
        Collections.sort(datatypeIRIs);
        List datatypeIRIsSortedByEnum = datatypes.stream().map(CoreDatatype::getIri).map(Object::toString).collect(Collectors.toList());
        Assertions.assertEquals(datatypeIRIs, datatypeIRIsSortedByEnum);
    }

    private ArrayList<CoreDatatype.XSD> getXSDDatatypesShuffled() {
        ArrayList<CoreDatatype.XSD> datatypes = new ArrayList<CoreDatatype.XSD>(Arrays.asList(CoreDatatype.XSD.values()));
        Collections.shuffle(datatypes, new Random(42353245L));
        return datatypes;
    }

    private ArrayList<CoreDatatype.RDF> getRDFDatatypesShuffled() {
        ArrayList<CoreDatatype.RDF> datatypes = new ArrayList<CoreDatatype.RDF>(Arrays.asList(CoreDatatype.RDF.values()));
        Collections.shuffle(datatypes, new Random(42353245L));
        return datatypes;
    }

    @Test
    public void testToString() {
        for (CoreDatatype value : CoreDatatypeHelper.getReverseLookup().values()) {
            Assertions.assertSame((Object)value.toString(), (Object)value.getIri().toString());
        }
    }

    @Test
    public void testUnknownDatatype() {
        Assertions.assertEquals((Object)CoreDatatype.NONE, (Object)CoreDatatype.from((IRI)new AbstractIRI.GenericIRI("http://example.com")));
    }
}

