/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.model;

import java.util.Set;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class ModelNamespacesTest {
    private Model testModel;

    protected abstract Model getModelImplementation();

    @BeforeEach
    public void setUp() throws Exception {
        this.testModel = this.getModelImplementation();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testModel = null;
    }

    @Test
    public final void testGetNamespacesEmpty() {
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertTrue((boolean)namespaces.isEmpty(), (String)"Namespaces must initially be empty");
    }

    @Test
    public final void testGetNamespacesSingle() {
        this.testModel.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertFalse((boolean)namespaces.isEmpty());
        Assertions.assertEquals((int)1, (int)namespaces.size());
        Assertions.assertTrue((boolean)namespaces.contains(new SimpleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#")), (String)"Did not find the expected namespace in the set");
    }

    @Test
    public final void testGetNamespacesMultiple() {
        this.testModel.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.testModel.setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.testModel.setNamespace("dc", "http://purl.org/dc/elements/1.1/");
        this.testModel.setNamespace("skos", "http://www.w3.org/2004/02/skos/core#");
        this.testModel.setNamespace("sesame", "http://www.openrdf.org/schema/sesame#");
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertFalse((boolean)namespaces.isEmpty());
        Assertions.assertEquals((int)5, (int)namespaces.size());
        Assertions.assertTrue((boolean)namespaces.contains(new SimpleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#")));
        Assertions.assertTrue((boolean)namespaces.contains(new SimpleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#")));
        Assertions.assertTrue((boolean)namespaces.contains(new SimpleNamespace("dc", "http://purl.org/dc/elements/1.1/")));
        Assertions.assertTrue((boolean)namespaces.contains(new SimpleNamespace("skos", "http://www.w3.org/2004/02/skos/core#")));
        Assertions.assertTrue((boolean)namespaces.contains(new SimpleNamespace("sesame", "http://www.openrdf.org/schema/sesame#")));
    }

    @Test
    public final void testGetNamespaceEmpty() {
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertTrue((boolean)namespaces.isEmpty(), (String)"Namespaces must initially be empty");
        Assertions.assertFalse((boolean)this.testModel.getNamespace("rdf").isPresent());
        Assertions.assertFalse((boolean)this.testModel.getNamespace("rdfs").isPresent());
        Assertions.assertFalse((boolean)this.testModel.getNamespace("dc").isPresent());
        Assertions.assertFalse((boolean)this.testModel.getNamespace("skos").isPresent());
        Assertions.assertFalse((boolean)this.testModel.getNamespace("sesame").isPresent());
    }

    @Test
    public final void testGetNamespaceSingle() {
        this.testModel.setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertFalse((boolean)namespaces.isEmpty());
        Assertions.assertEquals((int)1, (int)namespaces.size());
        Assertions.assertTrue((boolean)namespaces.contains(new SimpleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#")), (String)"Did not find the expected namespace in the set");
        Assertions.assertFalse((boolean)this.testModel.getNamespace("rdf").isPresent());
        Assertions.assertEquals((Object)new SimpleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#"), this.testModel.getNamespace("rdfs").get());
        Assertions.assertFalse((boolean)this.testModel.getNamespace("dc").isPresent());
        Assertions.assertFalse((boolean)this.testModel.getNamespace("skos").isPresent());
        Assertions.assertFalse((boolean)this.testModel.getNamespace("sesame").isPresent());
    }

    @Test
    public final void testGetNamespaceMultiple() {
        this.testModel.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.testModel.setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.testModel.setNamespace("dc", "http://purl.org/dc/elements/1.1/");
        this.testModel.setNamespace("skos", "http://www.w3.org/2004/02/skos/core#");
        this.testModel.setNamespace("sesame", "http://www.openrdf.org/schema/sesame#");
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertFalse((boolean)namespaces.isEmpty());
        Assertions.assertEquals((int)5, (int)namespaces.size());
        Assertions.assertEquals((Object)new SimpleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"), this.testModel.getNamespace("rdf").get());
        Assertions.assertEquals((Object)new SimpleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#"), this.testModel.getNamespace("rdfs").get());
        Assertions.assertEquals((Object)new SimpleNamespace("dc", "http://purl.org/dc/elements/1.1/"), this.testModel.getNamespace("dc").get());
        Assertions.assertEquals((Object)new SimpleNamespace("skos", "http://www.w3.org/2004/02/skos/core#"), this.testModel.getNamespace("skos").get());
        Assertions.assertEquals((Object)new SimpleNamespace("sesame", "http://www.openrdf.org/schema/sesame#"), this.testModel.getNamespace("sesame").get());
    }

    @Test
    public final void testSetNamespaceSamePrefix() {
        this.testModel.setNamespace("r", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.testModel.setNamespace("r", "http://www.w3.org/2000/01/rdf-schema#");
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertEquals((int)1, (int)namespaces.size());
        Assertions.assertEquals((Object)new SimpleNamespace("r", "http://www.w3.org/2000/01/rdf-schema#"), this.testModel.getNamespace("r").orElse(null));
    }

    @Test
    public final void testSetNamespaceNamespace() {
        this.testModel.setNamespace((Namespace)new SimpleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        this.testModel.setNamespace((Namespace)new SimpleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#"));
        this.testModel.setNamespace((Namespace)new SimpleNamespace("dc", "http://purl.org/dc/elements/1.1/"));
        this.testModel.setNamespace((Namespace)new SimpleNamespace("skos", "http://www.w3.org/2004/02/skos/core#"));
        this.testModel.setNamespace((Namespace)new SimpleNamespace("sesame", "http://www.openrdf.org/schema/sesame#"));
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertFalse((boolean)namespaces.isEmpty());
        Assertions.assertEquals((int)5, (int)namespaces.size());
        Assertions.assertEquals((Object)new SimpleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"), this.testModel.getNamespace("rdf").get());
        Assertions.assertEquals((Object)new SimpleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#"), this.testModel.getNamespace("rdfs").get());
        Assertions.assertEquals((Object)new SimpleNamespace("dc", "http://purl.org/dc/elements/1.1/"), this.testModel.getNamespace("dc").get());
        Assertions.assertEquals((Object)new SimpleNamespace("skos", "http://www.w3.org/2004/02/skos/core#"), this.testModel.getNamespace("skos").get());
        Assertions.assertEquals((Object)new SimpleNamespace("sesame", "http://www.openrdf.org/schema/sesame#"), this.testModel.getNamespace("sesame").get());
    }

    @Test
    public final void testSetNamespaceNamespaceSamePrefix() {
        this.testModel.setNamespace((Namespace)new SimpleNamespace("r", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        this.testModel.setNamespace((Namespace)new SimpleNamespace("r", "http://www.w3.org/2000/01/rdf-schema#"));
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertEquals((int)1, (int)namespaces.size());
        Assertions.assertEquals((Object)new SimpleNamespace("r", "http://www.w3.org/2000/01/rdf-schema#"), this.testModel.getNamespace("r").orElse(null));
    }

    @Test
    public final void testRemoveNamespaceEmpty() {
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertFalse((boolean)this.testModel.removeNamespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#").isPresent());
        Assertions.assertFalse((boolean)this.testModel.removeNamespace("http://www.w3.org/2000/01/rdf-schema#").isPresent());
        Assertions.assertFalse((boolean)this.testModel.removeNamespace("http://purl.org/dc/elements/1.1/").isPresent());
        Assertions.assertFalse((boolean)this.testModel.removeNamespace("http://www.w3.org/2004/02/skos/core#").isPresent());
        Assertions.assertFalse((boolean)this.testModel.removeNamespace("http://www.openrdf.org/schema/sesame#").isPresent());
    }

    @Test
    public final void testRemoveNamespaceSingle() {
        this.testModel.setNamespace("dc", "http://purl.org/dc/elements/1.1/");
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertFalse((boolean)namespaces.isEmpty());
        Assertions.assertEquals((int)1, (int)namespaces.size());
        Assertions.assertTrue((boolean)namespaces.contains(new SimpleNamespace("dc", "http://purl.org/dc/elements/1.1/")), (String)"Did not find the expected namespace in the set");
        Assertions.assertFalse((boolean)this.testModel.removeNamespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#").isPresent());
        Assertions.assertFalse((boolean)this.testModel.removeNamespace("http://www.w3.org/2000/01/rdf-schema#").isPresent());
        Assertions.assertEquals((Object)new SimpleNamespace("dc", "http://purl.org/dc/elements/1.1/"), this.testModel.removeNamespace("dc").get());
        Assertions.assertFalse((boolean)this.testModel.removeNamespace("http://www.w3.org/2004/02/skos/core#").isPresent());
        Assertions.assertFalse((boolean)this.testModel.removeNamespace("http://www.openrdf.org/schema/sesame#").isPresent());
        Set namespacesAfter = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespacesAfter, (String)"Namespaces set must not be null");
        Assertions.assertTrue((boolean)namespacesAfter.isEmpty(), (String)"Namespaces must now be empty");
    }

    @Test
    public final void testRemoveNamespaceMultiple() {
        this.testModel.setNamespace((Namespace)new SimpleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        this.testModel.setNamespace((Namespace)new SimpleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#"));
        this.testModel.setNamespace((Namespace)new SimpleNamespace("dc", "http://purl.org/dc/elements/1.1/"));
        this.testModel.setNamespace((Namespace)new SimpleNamespace("skos", "http://www.w3.org/2004/02/skos/core#"));
        this.testModel.setNamespace((Namespace)new SimpleNamespace("sesame", "http://www.openrdf.org/schema/sesame#"));
        Set namespaces = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespaces, (String)"Namespaces set must not be null");
        Assertions.assertFalse((boolean)namespaces.isEmpty());
        Assertions.assertEquals((int)5, (int)namespaces.size());
        Assertions.assertEquals((Object)new SimpleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"), this.testModel.removeNamespace("rdf").get());
        Assertions.assertEquals((Object)new SimpleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#"), this.testModel.removeNamespace("rdfs").get());
        Assertions.assertEquals((Object)new SimpleNamespace("dc", "http://purl.org/dc/elements/1.1/"), this.testModel.removeNamespace("dc").get());
        Assertions.assertEquals((Object)new SimpleNamespace("skos", "http://www.w3.org/2004/02/skos/core#"), this.testModel.removeNamespace("skos").get());
        Assertions.assertEquals((Object)new SimpleNamespace("sesame", "http://www.openrdf.org/schema/sesame#"), this.testModel.removeNamespace("sesame").get());
        Set namespacesAfter = this.testModel.getNamespaces();
        Assertions.assertNotNull((Object)namespacesAfter, (String)"Could not find parser for this format.");
        Assertions.assertTrue((boolean)namespacesAfter.isEmpty(), (String)"Namespaces must now be empty");
    }
}

