/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.impl.GraphQueryResultImpl;
import org.eclipse.rdf4j.query.impl.TupleQueryResultImpl;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.impl.AbstractParserQuery;
import org.eclipse.rdf4j.query.parser.impl.AbstractParserUpdate;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public abstract class AbstractQueryPreparer
implements QueryPreparer {
    private final TripleSource tripleSource;

    public AbstractQueryPreparer(TripleSource tripleSource) {
        this.tripleSource = tripleSource;
    }

    @Override
    public BooleanQuery prepare(ParsedBooleanQuery q) {
        return new BooleanQueryImpl(q);
    }

    @Override
    public TupleQuery prepare(ParsedTupleQuery q) {
        return new TupleQueryImpl(q);
    }

    @Override
    public GraphQuery prepare(ParsedGraphQuery q) {
        return new GraphQueryImpl(q);
    }

    @Override
    public Update prepare(ParsedUpdate u) {
        return new UpdateImpl(u);
    }

    @Override
    public TripleSource getTripleSource() {
        return this.tripleSource;
    }

    protected abstract CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr var1, Dataset var2, BindingSet var3, boolean var4, int var5) throws QueryEvaluationException;

    protected abstract void execute(UpdateExpr var1, Dataset var2, BindingSet var3, boolean var4, int var5) throws UpdateExecutionException;

    class UpdateImpl
    extends AbstractParserUpdate {
        UpdateImpl(ParsedUpdate update) {
            super(update);
        }

        public void execute() throws UpdateExecutionException {
            ParsedUpdate parsedUpdate = this.getParsedUpdate();
            List updateExprs = parsedUpdate.getUpdateExprs();
            Map datasetMapping = parsedUpdate.getDatasetMapping();
            for (UpdateExpr updateExpr : updateExprs) {
                Dataset activeDataset = this.getMergedDataset((Dataset)datasetMapping.get(updateExpr));
                try {
                    AbstractQueryPreparer.this.execute(updateExpr, activeDataset, this.getBindings(), this.getIncludeInferred(), this.getMaxExecutionTime());
                }
                catch (UpdateExecutionException e) {
                    if (updateExpr.isSilent()) continue;
                    throw e;
                }
            }
        }
    }

    class GraphQueryImpl
    extends AbstractParserQuery
    implements GraphQuery {
        GraphQueryImpl(ParsedGraphQuery query) {
            super((ParsedQuery)query);
        }

        public ParsedGraphQuery getParsedQuery() {
            return (ParsedGraphQuery)super.getParsedQuery();
        }

        public GraphQueryResult evaluate() throws QueryEvaluationException {
            TupleExpr tupleExpr = this.getParsedQuery().getTupleExpr();
            CloseableIteration bindingsIter = AbstractQueryPreparer.this.evaluate(tupleExpr, this.getActiveDataset(), this.getBindings(), this.getIncludeInferred(), this.getMaxExecutionTime());
            bindingsIter = new FilterIteration<BindingSet, QueryEvaluationException>(bindingsIter){

                protected boolean accept(BindingSet bindingSet) {
                    Value context = bindingSet.getValue("context");
                    return bindingSet.getValue("subject") instanceof Resource && bindingSet.getValue("predicate") instanceof URI && bindingSet.getValue("object") instanceof Value && (context == null || context instanceof Resource);
                }
            };
            bindingsIter = this.enforceMaxQueryTime(bindingsIter);
            ConvertingIteration<BindingSet, Statement, QueryEvaluationException> stIter = new ConvertingIteration<BindingSet, Statement, QueryEvaluationException>((Iteration)bindingsIter){
                private final ValueFactory vf;
                {
                    this.vf = AbstractQueryPreparer.this.tripleSource.getValueFactory();
                }

                protected Statement convert(BindingSet bindingSet) {
                    Resource subject = (Resource)bindingSet.getValue("subject");
                    URI predicate = (URI)bindingSet.getValue("predicate");
                    Value object = bindingSet.getValue("object");
                    Resource context = (Resource)bindingSet.getValue("context");
                    if (context == null) {
                        return this.vf.createStatement(subject, predicate, object);
                    }
                    return this.vf.createStatement(subject, predicate, object, context);
                }
            };
            return new GraphQueryResultImpl(this.getParsedQuery().getQueryNamespaces(), (CloseableIteration)stIter);
        }

        public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
            GraphQueryResult queryResult = this.evaluate();
            QueryResults.report((GraphQueryResult)queryResult, (RDFHandler)handler);
        }
    }

    class TupleQueryImpl
    extends AbstractParserQuery
    implements TupleQuery {
        TupleQueryImpl(ParsedTupleQuery query) {
            super((ParsedQuery)query);
        }

        public ParsedTupleQuery getParsedQuery() {
            return (ParsedTupleQuery)super.getParsedQuery();
        }

        public TupleQueryResult evaluate() throws QueryEvaluationException {
            TupleExpr tupleExpr = this.getParsedQuery().getTupleExpr();
            CloseableIteration bindingsIter = AbstractQueryPreparer.this.evaluate(tupleExpr, this.getActiveDataset(), this.getBindings(), this.getIncludeInferred(), this.getMaxExecutionTime());
            bindingsIter = this.enforceMaxQueryTime(bindingsIter);
            return new TupleQueryResultImpl(new ArrayList(tupleExpr.getBindingNames()), bindingsIter);
        }

        public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
            TupleQueryResult queryResult = this.evaluate();
            QueryResults.report((TupleQueryResult)queryResult, (QueryResultHandler)handler);
        }
    }

    class BooleanQueryImpl
    extends AbstractParserQuery
    implements BooleanQuery {
        BooleanQueryImpl(ParsedBooleanQuery query) {
            super((ParsedQuery)query);
        }

        public ParsedBooleanQuery getParsedQuery() {
            return (ParsedBooleanQuery)super.getParsedQuery();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evaluate() throws QueryEvaluationException {
            ParsedBooleanQuery parsedBooleanQuery = this.getParsedQuery();
            TupleExpr tupleExpr = parsedBooleanQuery.getTupleExpr();
            Dataset dataset = this.getDataset();
            if (dataset == null) {
                dataset = parsedBooleanQuery.getDataset();
            }
            CloseableIteration bindingsIter = AbstractQueryPreparer.this.evaluate(tupleExpr, dataset, this.getBindings(), this.getIncludeInferred(), this.getMaxExecutionTime());
            bindingsIter = this.enforceMaxQueryTime(bindingsIter);
            try {
                boolean bl = bindingsIter.hasNext();
                return bl;
            }
            finally {
                bindingsIter.close();
            }
        }
    }
}

