/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.federation;

import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.SesameClient;
import org.eclipse.rdf4j.http.client.SesameClientDependent;
import org.eclipse.rdf4j.http.client.SesameClientImpl;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.AbstractFederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.SPARQLFederatedService;

public class FederatedServiceResolverImpl
extends AbstractFederatedServiceResolver
implements FederatedServiceResolver,
HttpClientDependent,
SesameClientDependent {
    private SesameClient client;
    private SesameClientImpl dependentClient;

    public synchronized SesameClient getSesameClient() {
        if (this.client == null) {
            this.dependentClient = new SesameClientImpl();
            this.client = this.dependentClient;
        }
        return this.client;
    }

    public synchronized void setSesameClient(SesameClient client) {
        this.client = client;
    }

    public HttpClient getHttpClient() {
        return this.getSesameClient().getHttpClient();
    }

    public void setHttpClient(HttpClient httpClient) {
        if (this.dependentClient == null) {
            this.dependentClient = new SesameClientImpl();
            this.client = this.dependentClient;
        }
        this.dependentClient.setHttpClient(httpClient);
    }

    @Override
    protected FederatedService createService(String serviceUrl) throws QueryEvaluationException {
        return new SPARQLFederatedService(serviceUrl, this.getSesameClient());
    }

    @Override
    public void shutDown() {
        super.shutDown();
        if (this.dependentClient != null) {
            this.dependentClient.shutDown();
            this.dependentClient = null;
        }
    }
}

