/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.federation;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.http.client.QueueCursor;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public abstract class JoinExecutorBase<T>
extends LookAheadIteration<T, QueryEvaluationException> {
    protected static int NEXT_JOIN_ID = 1;
    protected final TupleExpr rightArg;
    protected final BindingSet bindings;
    protected CloseableIteration<T, QueryEvaluationException> leftIter;
    protected CloseableIteration<T, QueryEvaluationException> rightIter;
    protected volatile boolean closed;
    protected boolean finished = false;
    protected final QueueCursor<CloseableIteration<T, QueryEvaluationException>> rightQueue = new QueueCursor(1024);

    public JoinExecutorBase(CloseableIteration<T, QueryEvaluationException> leftIter, TupleExpr rightArg, BindingSet bindings) throws QueryEvaluationException {
        this.leftIter = leftIter;
        this.rightArg = rightArg;
        this.bindings = bindings;
    }

    public final void run() {
        try {
            this.handleBindings();
        }
        catch (Exception e) {
            this.toss(e);
        }
        finally {
            this.finished = true;
            this.rightQueue.done();
        }
    }

    protected abstract void handleBindings() throws Exception;

    public void addResult(CloseableIteration<T, QueryEvaluationException> res) {
        if (res instanceof EmptyIteration) {
            return;
        }
        try {
            this.rightQueue.put(res);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Error adding element to right queue", e);
        }
    }

    public void done() {
    }

    public void toss(Exception e) {
        this.rightQueue.toss(e);
    }

    public T getNextElement() throws QueryEvaluationException {
        while (this.rightIter != null || this.rightQueue.hasNext()) {
            if (this.rightIter == null) {
                this.rightIter = (CloseableIteration)this.rightQueue.next();
            }
            if (this.rightIter.hasNext()) {
                return (T)this.rightIter.next();
            }
            this.rightIter.close();
            this.rightIter = null;
        }
        return null;
    }

    public void handleClose() throws QueryEvaluationException {
        this.closed = true;
        this.rightQueue.close();
        if (this.rightIter != null) {
            this.rightIter.close();
            this.rightIter = null;
        }
        if (this.leftIter != null) {
            this.leftIter.close();
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

