/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.federation;

import java.util.Collection;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.JoinExecutorBase;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.SilentIteration;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;

public class ServiceFallbackIteration
extends JoinExecutorBase<BindingSet> {
    protected final Service service;
    protected final Set<String> projectionVars;
    protected final FederatedService federatedService;
    protected final Collection<BindingSet> bindings;

    public ServiceFallbackIteration(Service service, Set<String> projectionVars, Collection<BindingSet> bindings, FederatedService federatedService) throws QueryEvaluationException {
        super(null, null, EmptyBindingSet.getInstance());
        this.service = service;
        this.projectionVars = projectionVars;
        this.bindings = bindings;
        this.federatedService = federatedService;
        this.run();
    }

    @Override
    protected void handleBindings() throws Exception {
        for (BindingSet b : this.bindings) {
            try {
                CloseableIteration result = this.federatedService.select(this.service, this.projectionVars, b, this.service.getBaseURI());
                result = this.service.isSilent() ? new SilentIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result) : result;
                this.addResult(result);
            }
            catch (QueryEvaluationException e) {
                if (this.service.isSilent()) {
                    this.addResult(new SingletonIteration((Object)b));
                    continue;
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (this.service.isSilent()) {
                    this.addResult(new SingletonIteration((Object)b));
                    continue;
                }
                throw e;
            }
        }
    }
}

