/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.federation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DistinctIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.TupleFunctionCall;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.TupleFunctionEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class TupleFunctionFederatedService
implements FederatedService {
    private final TupleFunctionRegistry tupleFunctionRegistry;
    private final ValueFactory vf;
    private volatile boolean isInitialized;

    public TupleFunctionFederatedService(TupleFunctionRegistry tupleFunctionRegistry, ValueFactory vf) {
        this.tupleFunctionRegistry = tupleFunctionRegistry;
        this.vf = vf;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        this.isInitialized = true;
    }

    public void shutdown() {
        this.isInitialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ask(Service service, BindingSet bindings, String baseUri) throws QueryEvaluationException {
        try (CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(service, (CloseableIteration<BindingSet, QueryEvaluationException>)new SingletonIteration((Object)bindings), baseUri);){
            if (iter.hasNext()) {
                BindingSet bs = (BindingSet)iter.next();
                String firstVar = (String)service.getBindingNames().iterator().next();
                boolean bl = QueryEvaluationUtil.getEffectiveBooleanValue(bs.getValue(firstVar));
                return bl;
            }
        }
        return false;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> select(Service service, final Set<String> projectionVars, BindingSet bindings, String baseUri) throws QueryEvaluationException {
        final CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(service, (CloseableIteration<BindingSet, QueryEvaluationException>)new SingletonIteration((Object)bindings), baseUri);
        if (service.getBindingNames().equals(projectionVars)) {
            return iter;
        }
        return new CloseableIteration<BindingSet, QueryEvaluationException>(){

            public boolean hasNext() throws QueryEvaluationException {
                return iter.hasNext();
            }

            public BindingSet next() throws QueryEvaluationException {
                QueryBindingSet projected = new QueryBindingSet();
                BindingSet result = (BindingSet)iter.next();
                for (String var : projectionVars) {
                    Value v = result.getValue(var);
                    projected.addBinding(var, v);
                }
                return projected;
            }

            public void remove() throws QueryEvaluationException {
                iter.remove();
            }

            public void close() throws QueryEvaluationException {
                iter.close();
            }
        };
    }

    public final CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, CloseableIteration<BindingSet, QueryEvaluationException> bindings, String baseUri) throws QueryEvaluationException {
        if (!bindings.hasNext()) {
            return new EmptyIteration();
        }
        TupleExpr expr = service.getArg();
        if (!(expr instanceof TupleFunctionCall)) {
            return new EmptyIteration();
        }
        TupleFunctionCall funcCall = (TupleFunctionCall)expr;
        TupleFunction func = (TupleFunction)this.tupleFunctionRegistry.get(funcCall.getURI()).orElseThrow(() -> new QueryEvaluationException("Unknown tuple function '" + funcCall.getURI() + "'"));
        List argExprs = funcCall.getArgs();
        ArrayList<CloseableIteration<BindingSet, QueryEvaluationException>> resultIters = new ArrayList<CloseableIteration<BindingSet, QueryEvaluationException>>();
        while (bindings.hasNext()) {
            BindingSet bs = (BindingSet)bindings.next();
            Value[] argValues = new Value[argExprs.size()];
            for (int i = 0; i < argExprs.size(); ++i) {
                Value argValue;
                ValueExpr argExpr = (ValueExpr)argExprs.get(i);
                if (argExpr instanceof Var) {
                    argValue = TupleFunctionFederatedService.getValue((Var)argExpr, bs);
                } else if (argExpr instanceof ValueConstant) {
                    argValue = ((ValueConstant)argExpr).getValue();
                } else {
                    throw new ValueExprEvaluationException("Unsupported ValueExpr for argument " + i + ": " + argExpr.getClass().getSimpleName());
                }
                argValues[i] = argValue;
            }
            resultIters.add(TupleFunctionEvaluationStrategy.evaluate(func, funcCall.getResultVars(), bs, this.vf, argValues));
        }
        return resultIters.size() > 1 ? new DistinctIteration((Iteration)new UnionIteration(resultIters)) : (CloseableIteration)resultIters.get(0);
    }

    private static Value getValue(Var var, BindingSet bs) throws ValueExprEvaluationException {
        Value v = var.getValue();
        if (v == null) {
            v = bs.getValue(var.getName());
        }
        if (v == null) {
            throw new ValueExprEvaluationException("No value for binding: " + var.getName());
        }
        return v;
    }
}

