/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StringCast
implements Function {
    @Override
    public String getURI() {
        return XMLSchema.STRING.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("xsd:string cast requires exactly 1 argument, got " + args.length);
        }
        Value value = args[0];
        if (value instanceof IRI) {
            return valueFactory.createLiteral(value.toString(), XMLSchema.STRING);
        }
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            IRI datatype = literal.getDatatype();
            if (QueryEvaluationUtil.isSimpleLiteral(literal)) {
                return valueFactory.createLiteral(literal.getLabel(), XMLSchema.STRING);
            }
            if (!Literals.isLanguageLiteral((Literal)literal)) {
                if (datatype.equals((Object)XMLSchema.STRING)) {
                    return literal;
                }
                if (XMLDatatypeUtil.isNumericDatatype((IRI)datatype) || datatype.equals((Object)XMLSchema.BOOLEAN) || datatype.equals((Object)XMLSchema.DATETIME)) {
                    if (XMLDatatypeUtil.isValidValue((String)literal.getLabel(), (IRI)datatype)) {
                        String normalizedValue = XMLDatatypeUtil.normalize((String)literal.getLabel(), (IRI)datatype);
                        return valueFactory.createLiteral(normalizedValue, XMLSchema.STRING);
                    }
                    return valueFactory.createLiteral(literal.getLabel(), XMLSchema.STRING);
                }
                return valueFactory.createLiteral(literal.getLabel(), XMLSchema.STRING);
            }
        }
        throw new ValueExprEvaluationException("Invalid argument for xsd:string cast: " + value);
    }
}

