/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.lang.ObjectUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.AbstractAggregateOperator;
import org.eclipse.rdf4j.query.algebra.AggregateOperator;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupConcat;
import org.eclipse.rdf4j.query.algebra.GroupElem;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.Sample;
import org.eclipse.rdf4j.query.algebra.Sum;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.MathUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class GroupIterator
extends CloseableIteratorIteration<BindingSet, QueryEvaluationException> {
    private final SimpleValueFactory vf = SimpleValueFactory.getInstance();
    private final EvaluationStrategy strategy;
    private final BindingSet parentBindings;
    private final Group group;
    private boolean initialized = false;
    private final Object lock = new Object();
    private final File tempFile;
    private final DB db;
    private final long iterationCacheSyncThreshold;

    public GroupIterator(EvaluationStrategy strategy, Group group, BindingSet parentBindings) throws QueryEvaluationException {
        this(strategy, group, parentBindings, 0L);
    }

    public GroupIterator(EvaluationStrategy strategy, Group group, BindingSet parentBindings, long iterationCacheSyncThreshold) throws QueryEvaluationException {
        this.strategy = strategy;
        this.group = group;
        this.parentBindings = parentBindings;
        this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
        if (this.iterationCacheSyncThreshold > 0L) {
            try {
                this.tempFile = File.createTempFile("group-eval", null);
            }
            catch (IOException e) {
                throw new QueryEvaluationException("could not initialize temp db", (Throwable)e);
            }
            this.db = DBMaker.newFileDB((File)this.tempFile).deleteFilesAfterClose().closeOnJvmShutdown().make();
        } else {
            this.tempFile = null;
            this.db = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() throws QueryEvaluationException {
        if (!this.initialized) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialized) {
                    super.setIterator(this.createIterator());
                    this.initialized = true;
                }
            }
        }
        return super.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingSet next() throws QueryEvaluationException {
        if (!this.initialized) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialized) {
                    super.setIterator(this.createIterator());
                    this.initialized = true;
                }
            }
        }
        return (BindingSet)super.next();
    }

    protected void handleClose() throws QueryEvaluationException {
        super.handleClose();
        if (this.db != null) {
            this.db.close();
        }
    }

    private <T> Set<T> createSet(String setName) {
        if (this.db != null) {
            return this.db.getHashSet(setName);
        }
        return new HashSet();
    }

    private Iterator<BindingSet> createIterator() throws QueryEvaluationException {
        Collection<Entry> entries = this.buildEntries();
        Set bindingSets = this.createSet("bindingsets");
        for (Entry entry : entries) {
            QueryBindingSet sol = new QueryBindingSet(this.parentBindings);
            for (String name : this.group.getGroupBindingNames()) {
                Value value;
                BindingSet prototype = entry.getPrototype();
                if (prototype == null || (value = prototype.getValue(name)) == null) continue;
                sol.setBinding(name, value);
            }
            entry.bindSolution(sol);
            bindingSets.add((Object)((Object)sol));
        }
        return bindingSets.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Entry> buildEntries() throws QueryEvaluationException {
        try (CloseableIteration<BindingSet, QueryEvaluationException> iter = this.strategy.evaluate(this.group.getArg(), this.parentBindings);){
            Entry entry;
            LinkedHashMap<Key, Entry> entries = new LinkedHashMap<Key, Entry>();
            if (!iter.hasNext() && !(entry = new Entry(null)).getAggregates().isEmpty()) {
                entry.addSolution(EmptyBindingSet.getInstance());
                entries.put(new Key(EmptyBindingSet.getInstance()), entry);
            }
            while (iter.hasNext()) {
                BindingSet sol;
                try {
                    sol = (BindingSet)iter.next();
                }
                catch (NoSuchElementException e) {
                    break;
                }
                Key key = new Key(sol);
                Entry entry2 = (Entry)entries.get(key);
                if (entry2 == null) {
                    entry2 = new Entry(sol);
                    entries.put(key, entry2);
                }
                entry2.addSolution(sol);
            }
            Collection<Entry> collection = entries.values();
            return collection;
        }
    }

    private class ConcatAggregate
    extends Aggregate {
        private StringBuilder concatenated;
        private String separator;

        public ConcatAggregate(GroupConcat groupConcatOp) throws ValueExprEvaluationException, QueryEvaluationException {
            super((AbstractAggregateOperator)groupConcatOp);
            this.concatenated = new StringBuilder();
            this.separator = " ";
            ValueExpr separatorExpr = groupConcatOp.getSeparator();
            if (separatorExpr != null) {
                Value separatorValue = GroupIterator.this.strategy.evaluate(separatorExpr, GroupIterator.this.parentBindings);
                this.separator = separatorValue.stringValue();
            }
        }

        @Override
        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (v != null && this.distinctValue(v)) {
                this.concatenated.append(v.stringValue());
                this.concatenated.append(this.separator);
            }
        }

        @Override
        public Value getValue() {
            if (this.concatenated.length() == 0) {
                return GroupIterator.this.vf.createLiteral("");
            }
            int len = this.concatenated.length() - this.separator.length();
            return GroupIterator.this.vf.createLiteral(this.concatenated.substring(0, len));
        }
    }

    private class SampleAggregate
    extends Aggregate {
        private Value sample;
        private Random random;

        public SampleAggregate(Sample operator) {
            super((AbstractAggregateOperator)operator);
            this.sample = null;
            this.random = new Random(System.currentTimeMillis());
        }

        @Override
        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            Value newValue;
            if ((this.sample == null || this.random.nextFloat() < 0.5f) && (newValue = this.evaluate(s)) != null) {
                this.sample = newValue;
            }
        }

        @Override
        public Value getValue() {
            return this.sample;
        }
    }

    private class AvgAggregate
    extends Aggregate {
        private long count;
        private Literal sum;
        private ValueExprEvaluationException typeError;

        public AvgAggregate(Avg operator) {
            super((AbstractAggregateOperator)operator);
            this.count = 0L;
            this.sum = GroupIterator.this.vf.createLiteral("0", XMLSchema.INTEGER);
            this.typeError = null;
        }

        @Override
        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            if (this.typeError != null) {
                return;
            }
            Value v = this.evaluate(s);
            if (this.distinctValue(v)) {
                if (v instanceof Literal) {
                    Literal nextLiteral = (Literal)v;
                    if (nextLiteral.getDatatype() != null && XMLDatatypeUtil.isNumericDatatype((IRI)nextLiteral.getDatatype())) {
                        this.sum = MathUtil.compute(this.sum, nextLiteral, MathExpr.MathOp.PLUS);
                    } else {
                        this.typeError = new ValueExprEvaluationException("not a number: " + v);
                    }
                    ++this.count;
                } else if (v != null) {
                    this.typeError = new ValueExprEvaluationException("not a number: " + v);
                }
            }
        }

        @Override
        public Value getValue() throws ValueExprEvaluationException {
            if (this.typeError != null) {
                throw this.typeError;
            }
            if (this.count == 0L) {
                return GroupIterator.this.vf.createLiteral(0.0);
            }
            Literal sizeLit = GroupIterator.this.vf.createLiteral(this.count);
            return MathUtil.compute(this.sum, sizeLit, MathExpr.MathOp.DIVIDE);
        }
    }

    private class SumAggregate
    extends Aggregate {
        private Literal sum;
        private ValueExprEvaluationException typeError;

        public SumAggregate(Sum operator) {
            super((AbstractAggregateOperator)operator);
            this.sum = GroupIterator.this.vf.createLiteral("0", XMLSchema.INTEGER);
            this.typeError = null;
        }

        @Override
        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            if (this.typeError != null) {
                return;
            }
            Value v = this.evaluate(s);
            if (this.distinctValue(v)) {
                if (v instanceof Literal) {
                    Literal nextLiteral = (Literal)v;
                    if (nextLiteral.getDatatype() != null && XMLDatatypeUtil.isNumericDatatype((IRI)nextLiteral.getDatatype())) {
                        this.sum = MathUtil.compute(this.sum, nextLiteral, MathExpr.MathOp.PLUS);
                    } else {
                        this.typeError = new ValueExprEvaluationException("not a number: " + v);
                    }
                } else if (v != null) {
                    this.typeError = new ValueExprEvaluationException("not a number: " + v);
                }
            }
        }

        @Override
        public Value getValue() throws ValueExprEvaluationException {
            if (this.typeError != null) {
                throw this.typeError;
            }
            return this.sum;
        }
    }

    private class MaxAggregate
    extends Aggregate {
        private final ValueComparator comparator;
        private Value max;

        public MaxAggregate(Max operator) {
            super((AbstractAggregateOperator)operator);
            this.comparator = new ValueComparator();
            this.max = null;
        }

        @Override
        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (v != null && this.distinctValue(v)) {
                if (this.max == null) {
                    this.max = v;
                } else if (this.comparator.compare(v, this.max) > 0) {
                    this.max = v;
                }
            }
        }

        @Override
        public Value getValue() {
            return this.max;
        }
    }

    private class MinAggregate
    extends Aggregate {
        private final ValueComparator comparator;
        private Value min;

        public MinAggregate(Min operator) {
            super((AbstractAggregateOperator)operator);
            this.comparator = new ValueComparator();
            this.min = null;
        }

        @Override
        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            Value v = this.evaluate(s);
            if (v != null && this.distinctValue(v)) {
                if (this.min == null) {
                    this.min = v;
                } else if (this.comparator.compare(v, this.min) < 0) {
                    this.min = v;
                }
            }
        }

        @Override
        public Value getValue() {
            return this.min;
        }
    }

    private class CountAggregate
    extends Aggregate {
        private long count;
        private final Set<BindingSet> distinctBindingSets;

        public CountAggregate(Count operator) {
            super((AbstractAggregateOperator)operator);
            this.count = 0L;
            this.distinctBindingSets = operator.isDistinct() && this.getArg() == null ? GroupIterator.this.createSet("distinct-bs-" + this.hashCode()) : null;
        }

        @Override
        public void processAggregate(BindingSet s) throws QueryEvaluationException {
            if (this.getArg() != null) {
                Value value = this.evaluate(s);
                if (value != null && this.distinctValue(value)) {
                    ++this.count;
                }
            } else if (s.size() > 0 && this.distinctBindingSet(s)) {
                ++this.count;
            }
        }

        protected boolean distinctBindingSet(BindingSet s) {
            if (this.distinctBindingSets == null) {
                return true;
            }
            boolean result = this.distinctBindingSets.add(s);
            if (GroupIterator.this.db != null && (long)this.distinctBindingSets.size() % GroupIterator.this.iterationCacheSyncThreshold == 0L) {
                GroupIterator.this.db.commit();
            }
            return result;
        }

        @Override
        public Value getValue() {
            return GroupIterator.this.vf.createLiteral(Long.toString(this.count), XMLSchema.INTEGER);
        }
    }

    private abstract class Aggregate {
        private final Set<Value> distinctValues;
        private final ValueExpr arg;

        public Aggregate(AbstractAggregateOperator operator) {
            this.arg = operator.getArg();
            this.distinctValues = operator.isDistinct() ? GroupIterator.this.createSet("distinct-values-" + this.hashCode()) : null;
        }

        public abstract Value getValue() throws ValueExprEvaluationException;

        public abstract void processAggregate(BindingSet var1) throws QueryEvaluationException;

        protected boolean distinctValue(Value value) {
            if (this.distinctValues == null) {
                return true;
            }
            boolean result = this.distinctValues.add(value);
            if (GroupIterator.this.db != null && (long)this.distinctValues.size() % GroupIterator.this.iterationCacheSyncThreshold == 0L) {
                GroupIterator.this.db.commit();
            }
            return result;
        }

        protected ValueExpr getArg() {
            return this.arg;
        }

        protected Value evaluate(BindingSet s) throws QueryEvaluationException {
            try {
                return GroupIterator.this.strategy.evaluate(this.getArg(), s);
            }
            catch (ValueExprEvaluationException e) {
                return null;
            }
        }
    }

    private class Entry {
        private BindingSet prototype;
        private Map<String, Aggregate> aggregates;

        public Entry(BindingSet prototype) throws ValueExprEvaluationException, QueryEvaluationException {
            this.prototype = prototype;
        }

        private Map<String, Aggregate> getAggregates() throws ValueExprEvaluationException, QueryEvaluationException {
            if (this.aggregates == null) {
                this.aggregates = new LinkedHashMap<String, Aggregate>();
                for (GroupElem ge : GroupIterator.this.group.getGroupElements()) {
                    Aggregate create = this.create(ge.getOperator());
                    if (create == null) continue;
                    this.aggregates.put(ge.getName(), create);
                }
            }
            return this.aggregates;
        }

        public BindingSet getPrototype() {
            return this.prototype;
        }

        public void addSolution(BindingSet bindingSet) throws QueryEvaluationException {
            for (Aggregate aggregate : this.getAggregates().values()) {
                aggregate.processAggregate(bindingSet);
            }
        }

        public void bindSolution(QueryBindingSet sol) throws QueryEvaluationException {
            for (String name : this.getAggregates().keySet()) {
                try {
                    Value value = this.getAggregates().get(name).getValue();
                    if (value == null) continue;
                    sol.setBinding(name, value);
                }
                catch (ValueExprEvaluationException valueExprEvaluationException) {}
            }
        }

        private Aggregate create(AggregateOperator operator) throws ValueExprEvaluationException, QueryEvaluationException {
            if (operator instanceof Count) {
                return new CountAggregate((Count)operator);
            }
            if (operator instanceof Min) {
                return new MinAggregate((Min)operator);
            }
            if (operator instanceof Max) {
                return new MaxAggregate((Max)operator);
            }
            if (operator instanceof Sum) {
                return new SumAggregate((Sum)operator);
            }
            if (operator instanceof Avg) {
                return new AvgAggregate((Avg)operator);
            }
            if (operator instanceof Sample) {
                return new SampleAggregate((Sample)operator);
            }
            if (operator instanceof GroupConcat) {
                return new ConcatAggregate((GroupConcat)operator);
            }
            return null;
        }
    }

    protected class Key
    implements Serializable {
        private static final long serialVersionUID = 4461951265373324084L;
        private BindingSet bindingSet;
        private int hash;

        public Key(BindingSet bindingSet) {
            this.bindingSet = bindingSet;
            for (String name : GroupIterator.this.group.getGroupBindingNames()) {
                Value value = bindingSet.getValue(name);
                if (value == null) continue;
                this.hash ^= value.hashCode();
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other instanceof Key && other.hashCode() == this.hash) {
                BindingSet otherSolution = ((Key)other).bindingSet;
                for (String name : GroupIterator.this.group.getGroupBindingNames()) {
                    Value v2;
                    Value v1 = this.bindingSet.getValue(name);
                    if (ObjectUtil.nullEquals((Object)v1, (Object)(v2 = otherSolution.getValue(name)))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

