/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public class LeftJoinIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private EvaluationStrategy strategy;
    private final LeftJoin join;
    private final Set<String> scopeBindingNames;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private volatile CloseableIteration<BindingSet, QueryEvaluationException> rightIter;

    public LeftJoinIterator(EvaluationStrategy strategy, LeftJoin join, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.join = join;
        this.scopeBindingNames = join.getBindingNames();
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = new EmptyIteration();
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        try {
            while (this.rightIter.hasNext() || this.leftIter.hasNext()) {
                BindingSet leftBindings = null;
                if (!this.rightIter.hasNext()) {
                    leftBindings = (BindingSet)this.leftIter.next();
                    this.rightIter.close();
                    this.rightIter = this.strategy.evaluate(this.join.getRightArg(), leftBindings);
                }
                while (this.rightIter.hasNext()) {
                    BindingSet rightBindings = (BindingSet)this.rightIter.next();
                    try {
                        if (this.join.getCondition() == null) {
                            return rightBindings;
                        }
                        QueryBindingSet scopeBindings = new QueryBindingSet(rightBindings);
                        scopeBindings.retainAll(this.scopeBindingNames);
                        if (!this.strategy.isTrue(this.join.getCondition(), (BindingSet)scopeBindings)) continue;
                        return rightBindings;
                    }
                    catch (ValueExprEvaluationException valueExprEvaluationException) {
                    }
                }
                if (leftBindings == null) continue;
                return leftBindings;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    protected void handleClose() throws QueryEvaluationException {
        super.handleClose();
        this.leftIter.close();
        this.rightIter.close();
    }
}

