/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResults;

public class SPARQLMinusIteration<X extends Exception>
extends FilterIteration<BindingSet, X> {
    private final Iteration<BindingSet, X> rightArg;
    private final boolean distinct;
    private boolean initialized;
    private Set<BindingSet> excludeSet;

    public SPARQLMinusIteration(Iteration<BindingSet, X> leftArg, Iteration<BindingSet, X> rightArg) {
        this(leftArg, rightArg, false);
    }

    public SPARQLMinusIteration(Iteration<BindingSet, X> leftArg, Iteration<BindingSet, X> rightArg, boolean distinct) {
        super(leftArg);
        assert (rightArg != null);
        this.rightArg = rightArg;
        this.distinct = distinct;
        this.initialized = false;
    }

    protected boolean accept(BindingSet object) throws X {
        if (!this.initialized) {
            this.excludeSet = this.makeSet(this.getRightArg());
            this.initialized = true;
        }
        boolean compatible = false;
        for (BindingSet excluded : this.excludeSet) {
            Set<String> sharedBindingNames = this.makeSet(excluded.getBindingNames());
            sharedBindingNames.retainAll(object.getBindingNames());
            if (sharedBindingNames.isEmpty() || !QueryResults.bindingSetsCompatible((BindingSet)excluded, (BindingSet)object)) continue;
            compatible = true;
            break;
        }
        return !compatible;
    }

    protected Set<BindingSet> makeSet() throws X {
        return new LinkedHashSet<BindingSet>();
    }

    protected Set<String> makeSet(Set<String> set) throws X {
        return new HashSet<String>(set);
    }

    protected Set<BindingSet> makeSet(Iteration<BindingSet, X> rightArg2) throws X {
        return (Set)Iterations.addAll(this.rightArg, this.makeSet());
    }

    protected void handleClose() throws X {
        super.handleClose();
        Iterations.closeCloseable(this.getRightArg());
    }

    protected Iteration<BindingSet, X> getRightArg() {
        return this.rightArg;
    }

    protected long clearExcludeSet() {
        int size = this.excludeSet.size();
        this.excludeSet.clear();
        return size;
    }
}

