/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator;

import java.util.Collection;
import java.util.Comparator;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.OrderIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator.LimitedSizeIteratorUtil;

public class LimitedSizeOrderIteration
extends OrderIterator {
    private final AtomicLong used;
    private final long maxSize;

    public LimitedSizeOrderIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator, AtomicLong used, long maxSize) {
        this(iter, comparator, Integer.MAX_VALUE, false, used, maxSize);
    }

    public LimitedSizeOrderIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator, long limit, boolean distinct, AtomicLong used, long maxSize) {
        super(iter, comparator, limit, distinct);
        this.used = used;
        this.maxSize = maxSize;
    }

    @Override
    protected void removeLast(Collection<BindingSet> lastResults) {
        super.removeLast(lastResults);
        this.used.decrementAndGet();
    }

    @Override
    protected boolean add(BindingSet next, Collection<BindingSet> list) throws QueryEvaluationException {
        return LimitedSizeIteratorUtil.add(next, list, this.used, this.maxSize);
    }

    @Override
    protected Integer put(NavigableMap<BindingSet, Integer> map, BindingSet next, int count) throws QueryEvaluationException {
        Integer i = (Integer)map.get(next);
        int oldCount = i == null ? 0 : i;
        Integer put = super.put(map, next, count);
        if (oldCount < count) {
            if (this.used.incrementAndGet() > this.maxSize) {
                throw new QueryEvaluationException("Size limited reached inside order operator query, max size is:" + this.maxSize);
            }
        } else if (oldCount > count) {
            this.used.decrementAndGet();
        }
        return put;
    }
}

