/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.SPARQLMinusIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator.LimitedSizeIteratorUtil;

public class LimitedSizeSPARQLMinusIteration
extends SPARQLMinusIteration<QueryEvaluationException> {
    private AtomicLong used;
    private long maxSize;

    public LimitedSizeSPARQLMinusIteration(Iteration<BindingSet, QueryEvaluationException> leftArg, Iteration<BindingSet, QueryEvaluationException> rightArg, AtomicLong used, long maxSize) {
        this(leftArg, rightArg, false, used, maxSize);
    }

    public LimitedSizeSPARQLMinusIteration(Iteration<BindingSet, QueryEvaluationException> leftArg, Iteration<BindingSet, QueryEvaluationException> rightArg, boolean distinct, AtomicLong used, long maxSize) {
        super(leftArg, rightArg, distinct);
        this.used = used;
        this.maxSize = maxSize;
    }

    @Override
    protected Set<BindingSet> makeSet(Iteration<BindingSet, QueryEvaluationException> rightArg2) throws QueryEvaluationException {
        return LimitedSizeIteratorUtil.addAll(rightArg2, this.makeSet(), this.used, this.maxSize);
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        long size = this.clearExcludeSet();
        super.handleClose();
        this.used.addAndGet(-size);
    }
}

