/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class FloatCast
implements Function {
    @Override
    public String getURI() {
        return XMLSchema.FLOAT.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("xsd:float cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            IRI datatype = literal.getDatatype();
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                String floatValue = XMLDatatypeUtil.collapseWhiteSpace((String)literal.getLabel());
                if (XMLDatatypeUtil.isValidFloat((String)floatValue)) {
                    return valueFactory.createLiteral(floatValue, XMLSchema.FLOAT);
                }
            } else if (datatype != null) {
                if (datatype.equals((Object)XMLSchema.FLOAT)) {
                    return literal;
                }
                if (XMLDatatypeUtil.isNumericDatatype((IRI)datatype)) {
                    try {
                        float floatValue = literal.floatValue();
                        return valueFactory.createLiteral(floatValue);
                    }
                    catch (NumberFormatException e) {
                        throw new ValueExprEvaluationException(e.getMessage(), e);
                    }
                }
                if (datatype.equals((Object)XMLSchema.BOOLEAN)) {
                    try {
                        return valueFactory.createLiteral(literal.booleanValue() ? 1.0f : 0.0f);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ValueExprEvaluationException(e.getMessage(), e);
                    }
                }
            }
        }
        throw new ValueExprEvaluationException("Invalid argument for xsd:float cast: " + args[0]);
    }
}

