/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.TupleFunctionCall;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunctionRegistry;

public class TupleFunctionEvaluationStrategy
implements EvaluationStrategy {
    private final EvaluationStrategy delegate;
    private final ValueFactory valueFactory;
    private final TupleFunctionRegistry tupleFuncRegistry;

    public TupleFunctionEvaluationStrategy(EvaluationStrategy delegate, ValueFactory valueFactory) {
        this(delegate, valueFactory, TupleFunctionRegistry.getInstance());
    }

    public TupleFunctionEvaluationStrategy(EvaluationStrategy delegate, ValueFactory valueFactory, TupleFunctionRegistry tupleFuncRegistry) {
        this.delegate = delegate;
        this.valueFactory = valueFactory;
        this.tupleFuncRegistry = tupleFuncRegistry;
    }

    @Override
    public FederatedService getService(String serviceUrl) throws QueryEvaluationException {
        return this.delegate.getService(serviceUrl);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service expr, String serviceUri, CloseableIteration<BindingSet, QueryEvaluationException> bindings) throws QueryEvaluationException {
        return this.delegate.evaluate(expr, serviceUri, bindings);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof TupleFunctionCall) {
            return this.evaluate((TupleFunctionCall)expr, bindings);
        }
        return this.delegate.evaluate(expr, bindings);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleFunctionCall expr, BindingSet bindings) throws QueryEvaluationException {
        TupleFunction func = (TupleFunction)this.tupleFuncRegistry.get(expr.getURI()).orElseThrow(() -> new QueryEvaluationException("Unknown tuple function '" + expr.getURI() + "'"));
        List args = expr.getArgs();
        Value[] argValues = new Value[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            argValues[i] = this.evaluate((ValueExpr)args.get(i), bindings);
        }
        return TupleFunctionEvaluationStrategy.evaluate(func, expr.getResultVars(), bindings, this.valueFactory, argValues);
    }

    @Override
    public Value evaluate(ValueExpr expr, BindingSet bindings) throws QueryEvaluationException {
        return this.delegate.evaluate(expr, bindings);
    }

    @Override
    public boolean isTrue(ValueExpr expr, BindingSet bindings) throws QueryEvaluationException {
        return this.delegate.isTrue(expr, bindings);
    }

    public static CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleFunction func, final List<Var> resultVars, final BindingSet bindings, ValueFactory valueFactory, Value ... argValues) throws QueryEvaluationException {
        final CloseableIteration<? extends List<? extends Value>, QueryEvaluationException> iter = func.evaluate(valueFactory, argValues);
        return new LookAheadIteration<BindingSet, QueryEvaluationException>(){

            public BindingSet getNextElement() throws QueryEvaluationException {
                QueryBindingSet resultBindings;
                if (iter.hasNext()) {
                    resultBindings = new QueryBindingSet(bindings);
                    List values = (List)iter.next();
                    if (resultVars.size() != values.size()) {
                        throw new QueryEvaluationException("Incorrect number of result vars: require " + values.size());
                    }
                    for (int i = 0; i < values.size(); ++i) {
                        Value result = (Value)values.get(i);
                        Var resultVar = (Var)resultVars.get(i);
                        Value varValue = resultVar.getValue();
                        String varName = resultVar.getName();
                        Value boundValue = bindings.getValue(varName);
                        if (varValue != null && !result.equals(varValue) || boundValue != null && !result.equals(boundValue)) {
                            resultBindings = null;
                            break;
                        }
                        resultBindings.addBinding(varName, result);
                    }
                } else {
                    resultBindings = null;
                }
                return resultBindings;
            }

            protected void handleClose() throws QueryEvaluationException {
                iter.close();
            }
        };
    }
}

