/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.SimpleEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class PathIteration
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final SimpleEvaluationStrategy evaluationStrategyImpl;
    private long currentLength;
    private CloseableIteration<BindingSet, QueryEvaluationException> currentIter;
    private BindingSet bindings;
    private StatementPattern.Scope scope;
    private Var startVar;
    private Var endVar;
    private final boolean startVarFixed;
    private final boolean endVarFixed;
    private Queue<ValuePair> valueQueue;
    private final Set<ValuePair> reportedValues;
    private final Set<ValuePair> unreportedValues;
    private TupleExpr pathExpression;
    private Var contextVar;
    private ValuePair currentVp;
    private static final String JOINVAR_PREFIX = "intermediate-join-";

    public PathIteration(SimpleEvaluationStrategy evaluationStrategyImpl, StatementPattern.Scope scope, Var startVar, TupleExpr pathExpression, Var endVar, Var contextVar, long minLength, BindingSet bindings) throws QueryEvaluationException {
        this.evaluationStrategyImpl = evaluationStrategyImpl;
        this.scope = scope;
        this.startVar = startVar;
        this.endVar = endVar;
        this.startVarFixed = startVar.hasValue() || bindings.hasBinding(startVar.getName());
        this.endVarFixed = endVar.hasValue() || bindings.hasBinding(endVar.getName());
        this.pathExpression = pathExpression;
        this.contextVar = contextVar;
        this.currentLength = minLength;
        this.bindings = bindings;
        this.reportedValues = this.makeSet();
        this.unreportedValues = this.makeSet();
        this.valueQueue = this.makeQueue();
        this.createIteration();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected BindingSet getNextElement() throws QueryEvaluationException {
        ValuePair vp;
        Value v2;
        Value v1;
        Object nextElement;
        block0: while (true) {
            if (!this.currentIter.hasNext()) {
                Iterations.closeCloseable(this.currentIter);
                this.createIteration();
                if (!(this.currentIter instanceof EmptyIteration)) continue;
            }
            while (true) {
                Value startValue;
                if (!this.currentIter.hasNext()) {
                    this.reportedValues.clear();
                    this.unreportedValues.clear();
                    this.valueQueue.clear();
                    return null;
                }
                nextElement = (BindingSet)this.currentIter.next();
                if (!this.startVarFixed && !this.endVarFixed && this.currentVp != null && (startValue = this.currentVp.getStartValue()) != null) {
                    nextElement = new QueryBindingSet((BindingSet)nextElement);
                    ((QueryBindingSet)((Object)nextElement)).addBinding(this.startVar.getName(), startValue);
                }
                if (this.startVarFixed && this.endVarFixed && this.currentLength > 2L) {
                    v1 = this.getVarValue(this.startVar, this.startVarFixed, (BindingSet)nextElement);
                    v2 = nextElement.getValue("END_intermediate-join-" + this.pathExpression.hashCode());
                } else if (this.startVarFixed && this.endVarFixed && this.currentLength == 2L) {
                    v1 = this.getVarValue(this.startVar, this.startVarFixed, (BindingSet)nextElement);
                    v2 = nextElement.getValue(JOINVAR_PREFIX + (this.currentLength - 1L) + "-" + this.pathExpression.hashCode());
                } else {
                    v1 = this.getVarValue(this.startVar, this.startVarFixed, (BindingSet)nextElement);
                    v2 = this.getVarValue(this.endVar, this.endVarFixed, (BindingSet)nextElement);
                }
                if (this.isCyclicPath(v1, v2)) continue block0;
                vp = new ValuePair(v1, v2);
                if (!this.reportedValues.contains(vp)) break;
                if (!this.currentIter.hasNext()) continue block0;
            }
            if (!this.startVarFixed || !this.endVarFixed) break;
            Value endValue = this.getVarValue(this.endVar, this.endVarFixed, (BindingSet)nextElement);
            if (endValue.equals(v2)) {
                this.add(this.reportedValues, vp);
                if (!v1.equals(v2)) {
                    this.addToQueue(this.valueQueue, vp);
                }
                if (!nextElement.hasBinding(this.startVar.getName())) {
                    ((QueryBindingSet)((Object)nextElement)).addBinding(this.startVar.getName(), v1);
                }
                if (!nextElement.hasBinding(this.endVar.getName())) {
                    ((QueryBindingSet)((Object)nextElement)).addBinding(this.endVar.getName(), v2);
                }
                return nextElement;
            }
            if (!this.add(this.unreportedValues, vp) || v1.equals(v2)) continue;
            this.addToQueue(this.valueQueue, vp);
        }
        this.add(this.reportedValues, vp);
        if (!v1.equals(v2)) {
            this.addToQueue(this.valueQueue, vp);
        }
        if (!nextElement.hasBinding(this.startVar.getName())) {
            ((QueryBindingSet)((Object)nextElement)).addBinding(this.startVar.getName(), v1);
        }
        if (!nextElement.hasBinding(this.endVar.getName())) {
            ((QueryBindingSet)((Object)nextElement)).addBinding(this.endVar.getName(), v2);
        }
        return nextElement;
    }

    protected void handleClose() throws QueryEvaluationException {
        Iterations.closeCloseable(this.currentIter);
        super.handleClose();
    }

    protected boolean addToQueue(Queue<ValuePair> valueQueue2, ValuePair vp) throws QueryEvaluationException {
        return valueQueue2.add(vp);
    }

    protected boolean add(Set<ValuePair> valueSet, ValuePair vp) throws QueryEvaluationException {
        return valueSet.add(vp);
    }

    private Value getVarValue(Var var, boolean fixedValue, BindingSet bindingSet) {
        Value v;
        if (fixedValue) {
            v = var.getValue();
            if (v == null) {
                v = this.bindings.getValue(var.getName());
            }
        } else {
            v = bindingSet.getValue(var.getName());
        }
        return v;
    }

    private boolean isCyclicPath(Value v1, Value v2) {
        if (this.currentLength <= 2L) {
            return false;
        }
        return this.reportedValues.contains(new ValuePair(v1, v2));
    }

    private void createIteration() throws QueryEvaluationException {
        if (this.currentLength == 0L) {
            ZeroLengthPath zlp = new ZeroLengthPath(this.scope, this.startVar, this.endVar, this.contextVar);
            this.currentIter = this.evaluationStrategyImpl.evaluate(zlp, this.bindings);
            ++this.currentLength;
        } else if (this.currentLength == 1L) {
            TupleExpr pathExprClone = this.pathExpression.clone();
            if (this.startVarFixed && this.endVarFixed) {
                Var replacement = this.createAnonVar(JOINVAR_PREFIX + this.currentLength + "-" + this.pathExpression.hashCode());
                VarReplacer replacer = new VarReplacer(this.endVar, replacement, 0L, false);
                pathExprClone.visit((QueryModelVisitor)replacer);
            }
            this.currentIter = this.evaluationStrategyImpl.evaluate(pathExprClone, this.bindings);
            ++this.currentLength;
        } else {
            this.currentVp = this.valueQueue.poll();
            if (this.currentVp != null) {
                TupleExpr pathExprClone = this.pathExpression.clone();
                if (this.startVarFixed && this.endVarFixed) {
                    Var startReplacement = this.createAnonVar(JOINVAR_PREFIX + this.currentLength + "-" + this.pathExpression.hashCode());
                    Var endReplacement = this.createAnonVar("END_intermediate-join-" + this.pathExpression.hashCode());
                    startReplacement.setAnonymous(false);
                    endReplacement.setAnonymous(false);
                    Value v = this.currentVp.getEndValue();
                    startReplacement.setValue(v);
                    VarReplacer replacer = new VarReplacer(this.startVar, startReplacement, 0L, false);
                    pathExprClone.visit((QueryModelVisitor)replacer);
                    replacer = new VarReplacer(this.endVar, endReplacement, 0L, false);
                    pathExprClone.visit((QueryModelVisitor)replacer);
                } else {
                    Value v;
                    Var toBeReplaced;
                    if (!this.endVarFixed) {
                        toBeReplaced = this.startVar;
                        v = this.currentVp.getEndValue();
                    } else {
                        toBeReplaced = this.endVar;
                        v = this.currentVp.getStartValue();
                    }
                    Var replacement = this.createAnonVar(JOINVAR_PREFIX + this.currentLength + "-" + this.pathExpression.hashCode());
                    replacement.setValue(v);
                    VarReplacer replacer = new VarReplacer(toBeReplaced, replacement, 0L, false);
                    pathExprClone.visit((QueryModelVisitor)replacer);
                }
                this.currentIter = this.evaluationStrategyImpl.evaluate(pathExprClone, this.bindings);
            } else {
                this.currentIter = new EmptyIteration();
            }
            ++this.currentLength;
        }
    }

    protected Set<ValuePair> makeSet() {
        return new HashSet<ValuePair>(64, 0.9f);
    }

    protected Queue<ValuePair> makeQueue() {
        return new ArrayDeque<ValuePair>();
    }

    public Var createAnonVar(String varName) {
        Var var = new Var(varName);
        var.setAnonymous(true);
        return var;
    }

    class VarReplacer
    extends AbstractQueryModelVisitor<QueryEvaluationException> {
        private Var toBeReplaced;
        private Var replacement;
        private long index;
        private boolean replaceAnons;

        public VarReplacer(Var toBeReplaced, Var replacement, long index, boolean replaceAnons) {
            this.toBeReplaced = toBeReplaced;
            this.replacement = replacement;
            this.index = index;
            this.replaceAnons = replaceAnons;
        }

        public void meet(Var var) {
            if (this.toBeReplaced.equals((Object)var) || this.toBeReplaced.isAnonymous() && var.isAnonymous() && this.toBeReplaced.hasValue() && this.toBeReplaced.getValue().equals(var.getValue())) {
                QueryModelNode parent = var.getParentNode();
                parent.replaceChildNode((QueryModelNode)var, (QueryModelNode)this.replacement);
                this.replacement.setParentNode(parent);
            } else if (this.replaceAnons && var.isAnonymous() && !var.hasValue()) {
                Var replacementVar = PathIteration.this.createAnonVar("anon-replace-" + var.getName() + this.index);
                QueryModelNode parent = var.getParentNode();
                parent.replaceChildNode((QueryModelNode)var, (QueryModelNode)replacementVar);
                replacementVar.setParentNode(parent);
            }
        }
    }

    protected static class ValuePair {
        private final Value startValue;
        private final Value endValue;

        public ValuePair(Value startValue, Value endValue) {
            this.startValue = startValue;
            this.endValue = endValue;
        }

        public Value getStartValue() {
            return this.startValue;
        }

        public Value getEndValue() {
            return this.endValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.endValue == null ? 0 : this.endValue.hashCode());
            result = 31 * result + (this.startValue == null ? 0 : this.startValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ValuePair)) {
                return false;
            }
            ValuePair other = (ValuePair)obj;
            if (this.endValue == null ? other.endValue != null : !this.endValue.equals(other.endValue)) {
                return false;
            }
            return !(this.startValue == null ? other.startValue != null : !this.startValue.equals(other.startValue));
        }
    }
}

