/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import com.spatial4j.core.shape.impl.BufferedLineString;
import java.io.IOException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.WktWriter;

final class DefaultWktWriter
implements WktWriter {
    DefaultWktWriter() {
    }

    private String notSupported(Shape s) {
        throw new UnsupportedOperationException("This shape is not supported due to licensing issues. Feel free to provide your own implementation by using something like JTS: " + s.getClass().getName());
    }

    @Override
    public String toWkt(Shape shape) throws IOException {
        if (shape instanceof Point) {
            Point p = (Point)shape;
            return "POINT " + this.toCoords(p);
        }
        if (shape instanceof ShapeCollection) {
            ShapeCollection col = (ShapeCollection)shape;
            if (col.isEmpty()) {
                return "GEOMETRYCOLLECTION EMPTY";
            }
            Class<Object> elementType = null;
            StringBuilder buf = new StringBuilder(" (");
            String sep = "";
            for (Shape s : col) {
                if (elementType == null) {
                    elementType = s.getClass();
                } else if (!elementType.equals(s.getClass())) {
                    elementType = Shape.class;
                }
                buf.append(sep).append(this.toCoords(s));
                sep = ", ";
            }
            buf.append(")");
            if (Point.class.isAssignableFrom(elementType)) {
                buf.insert(0, "MULTIPOINT");
            } else if (elementType == Shape.class) {
                buf.insert(0, "GEOMETRYCOLLECTION");
            } else {
                return this.notSupported(shape);
            }
            return buf.toString();
        }
        if (shape instanceof BufferedLineString) {
            BufferedLineString ls = (BufferedLineString)shape;
            return "LINESTRING " + this.toCoords(ls);
        }
        return this.notSupported(shape);
    }

    private String toCoords(Shape shape) throws IOException {
        if (shape instanceof Point) {
            Point p = (Point)shape;
            return this.toCoords(p);
        }
        if (shape instanceof BufferedLineString) {
            BufferedLineString ls = (BufferedLineString)shape;
            return this.toCoords(ls);
        }
        return this.notSupported(shape);
    }

    private String toCoords(Point p) throws IOException {
        if (p.isEmpty()) {
            return "EMPTY";
        }
        return "(" + p.getX() + " " + p.getY() + ")";
    }

    private String toCoords(BufferedLineString shape) throws IOException {
        double buffer = shape.getBuf();
        if (buffer != 0.0) {
            return this.notSupported((Shape)shape);
        }
        StringBuilder buf = new StringBuilder("(");
        String sep = "";
        for (Point p : shape.getPoints()) {
            buf.append(sep);
            buf.append(p.getX()).append(" ").append(p.getY());
            sep = ", ";
        }
        buf.append(")");
        return buf.toString();
    }
}

