/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.text.ParseException;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.GEO;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

class FunctionArguments {
    private FunctionArguments() {
    }

    public static double getDouble(Function func, Value v) throws ValueExprEvaluationException {
        Literal l = FunctionArguments.getLiteral(func, v, (URI)XMLSchema.DOUBLE);
        return l.doubleValue();
    }

    public static String getString(Function func, Value v) throws ValueExprEvaluationException {
        Literal l = FunctionArguments.getLiteral(func, v, (URI)XMLSchema.STRING);
        return l.stringValue();
    }

    public static Shape getShape(Function func, Value v, SpatialContext context) throws ValueExprEvaluationException {
        Literal wktLiteral = FunctionArguments.getLiteral(func, v, GEO.WKT_LITERAL);
        try {
            return context.readShapeFromWkt(wktLiteral.getLabel());
        }
        catch (ParseException e) {
            throw new ValueExprEvaluationException("Invalid argument for " + func.getURI() + ": " + wktLiteral, (Throwable)e);
        }
    }

    public static Point getPoint(Function func, Value v, SpatialContext geoContext) throws ValueExprEvaluationException {
        Shape p = FunctionArguments.getShape(func, v, geoContext);
        if (!(p instanceof Point)) {
            throw new ValueExprEvaluationException("Invalid argument for " + func.getURI() + " (not a point): " + v);
        }
        return (Point)p;
    }

    public static Literal getLiteral(Function func, Value v, URI expectedDatatype) throws ValueExprEvaluationException {
        if (!(v instanceof Literal)) {
            throw new ValueExprEvaluationException("Invalid argument for " + func.getURI() + ": " + v);
        }
        Literal lit = (Literal)v;
        if (!expectedDatatype.equals((Object)lit.getDatatype())) {
            throw new ValueExprEvaluationException("Invalid datatype " + lit.getDatatype() + " for " + func.getURI() + ": " + v);
        }
        return lit;
    }

    public static URI getUnits(Function func, Value v) throws ValueExprEvaluationException {
        if (!(v instanceof URI)) {
            throw new ValueExprEvaluationException("Invalid argument for " + func.getURI() + ": " + v);
        }
        URI unitUri = (URI)v;
        if (!unitUri.getNamespace().equals("http://www.opengis.net/def/uom/OGC/1.0/")) {
            throw new ValueExprEvaluationException("Invalid unit of measurement URI for " + func.getURI() + ": " + v);
        }
        return unitUri;
    }

    public static double convertFromDegrees(double degs, URI units) throws ValueExprEvaluationException {
        double v;
        if (GEOF.UOM_DEGREE.equals((Object)units)) {
            v = degs;
        } else if (GEOF.UOM_RADIAN.equals((Object)units)) {
            v = DistanceUtils.toRadians((double)degs);
        } else if (GEOF.UOM_UNITY.equals((Object)units)) {
            v = degs / 180.0;
        } else if (GEOF.UOM_METRE.equals((Object)units)) {
            v = DistanceUtils.degrees2Dist((double)degs, (double)6371.0087714) * 1000.0;
        } else {
            throw new ValueExprEvaluationException("Invalid unit of measurement: " + units);
        }
        return v;
    }

    public static double convertToDegrees(double v, URI units) throws ValueExprEvaluationException {
        double degs;
        if (GEOF.UOM_DEGREE.equals((Object)units)) {
            degs = v;
        } else if (GEOF.UOM_RADIAN.equals((Object)units)) {
            degs = DistanceUtils.toDegrees((double)v);
        } else if (GEOF.UOM_UNITY.equals((Object)units)) {
            degs = v * 180.0;
        } else if (GEOF.UOM_METRE.equals((Object)units)) {
            degs = DistanceUtils.dist2Degrees((double)(v / 1000.0), (double)6371.0087714);
        } else {
            throw new ValueExprEvaluationException("Invalid unit of measurement: " + units);
        }
        return degs;
    }
}

