/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.GEO;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.FunctionArguments;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialSupport;

abstract class GeometricBinaryFunction
implements Function {
    GeometricBinaryFunction() {
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        String wkt;
        if (args.length != 2) {
            throw new ValueExprEvaluationException(this.getURI() + " requires exactly 2 arguments, got " + args.length);
        }
        SpatialContext geoContext = SpatialSupport.getSpatialContext();
        Shape geom1 = FunctionArguments.getShape(this, args[0], geoContext);
        Shape geom2 = FunctionArguments.getShape(this, args[1], geoContext);
        Shape result = this.operation(geom1, geom2);
        try {
            wkt = SpatialSupport.getWktWriter().toWkt(result);
        }
        catch (IOException ioe) {
            throw new ValueExprEvaluationException((Throwable)ioe);
        }
        return valueFactory.createLiteral(wkt, GEO.WKT_LITERAL);
    }

    protected abstract Shape operation(Shape var1, Shape var2);
}

