/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.GEO;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.FunctionArguments;

public class SRID
implements Function {
    public String getURI() {
        return GEOF.GET_SRID.stringValue();
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException(this.getURI() + " requires exactly 1 argument, got " + args.length);
        }
        Literal geom = FunctionArguments.getLiteral(this, args[0], GEO.WKT_LITERAL);
        String wkt = geom.getLabel();
        int sep = wkt.indexOf(32);
        String srid = sep != -1 && wkt.charAt(0) == '<' && wkt.charAt(sep - 1) == '>' ? wkt.substring(1, sep - 1) : "http://www.opengis.net/def/crs/OGC/1.3/CRS84";
        return valueFactory.createLiteral(srid, XMLSchema.ANYURI);
    }
}

