/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.impl.BufferedLineString;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialAlgebra;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialSupport;

final class DefaultSpatialAlgebra
implements SpatialAlgebra {
    DefaultSpatialAlgebra() {
    }

    private <T> T notSupported() {
        throw new UnsupportedOperationException("Not supported due to licensing issues. Feel free to provide your own implementation by using something like JTS.");
    }

    private Shape createEmptyPoint() {
        return SpatialSupport.getSpatialContext().makePoint(Double.NaN, Double.NaN);
    }

    private Shape createEmptyGeometry() {
        return new ShapeCollection(Collections.emptyList(), SpatialSupport.getSpatialContext());
    }

    @Override
    public Shape convexHull(Shape s) {
        if (s instanceof Point) {
            return s;
        }
        if (s instanceof ShapeCollection) {
            return new BufferedLineString((List)((ShapeCollection)s), 0.0, SpatialSupport.getSpatialContext());
        }
        return (Shape)this.notSupported();
    }

    @Override
    public Shape boundary(Shape s) {
        if (s instanceof Point) {
            return this.createEmptyGeometry();
        }
        if (s instanceof ShapeCollection) {
            ShapeCollection col = (ShapeCollection)s;
            if (col.isEmpty()) {
                return this.createEmptyGeometry();
            }
            for (Shape p : col) {
                if (p instanceof Point) continue;
                return (Shape)this.notSupported();
            }
            return this.createEmptyGeometry();
        }
        return (Shape)this.notSupported();
    }

    @Override
    public Shape envelope(Shape s) {
        if (s instanceof Point) {
            return s;
        }
        return (Shape)this.notSupported();
    }

    @Override
    public Shape union(Shape s1, Shape s2) {
        if (s1 instanceof Point && s2 instanceof Point) {
            Point p2 = (Point)s2;
            Point p1 = (Point)s1;
            int diff = this.compare(p2, p1);
            if (diff == 0) {
                return s1;
            }
            if (diff < 0) {
                p1 = p2;
                p2 = (Point)s1;
            }
            return new ShapeCollection(Arrays.asList(p1, p2), SpatialSupport.getSpatialContext());
        }
        return (Shape)this.notSupported();
    }

    private int compare(Point p1, Point p2) {
        int diff = Double.compare(p1.getX(), p2.getX());
        if (diff == 0) {
            diff = Double.compare(p1.getY(), p2.getY());
        }
        return diff;
    }

    @Override
    public Shape intersection(Shape s1, Shape s2) {
        if (s1 instanceof Point && s2 instanceof Point) {
            Point p2 = (Point)s2;
            Point p1 = (Point)s1;
            int diff = this.compare(p2, p1);
            if (diff == 0) {
                return s1;
            }
            return this.createEmptyPoint();
        }
        return (Shape)this.notSupported();
    }

    @Override
    public Shape symDifference(Shape s1, Shape s2) {
        if (s1 instanceof Point && s2 instanceof Point) {
            Point p2 = (Point)s2;
            Point p1 = (Point)s1;
            int diff = this.compare(p2, p1);
            if (diff == 0) {
                return this.createEmptyPoint();
            }
            if (diff < 0) {
                p1 = p2;
                p2 = (Point)s1;
            }
            return new ShapeCollection(Arrays.asList(p1, p2), SpatialSupport.getSpatialContext());
        }
        return (Shape)this.notSupported();
    }

    @Override
    public Shape difference(Shape s1, Shape s2) {
        if (s1 instanceof Point && s2 instanceof Point) {
            Point p2 = (Point)s2;
            Point p1 = (Point)s1;
            int diff = this.compare(p2, p1);
            if (diff == 0) {
                return this.createEmptyPoint();
            }
            return s1;
        }
        return (Shape)this.notSupported();
    }

    @Override
    public boolean relate(Shape s1, Shape s2, String intersectionPattern) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean equals(Shape s1, Shape s2) {
        return s1.equals((Object)s2);
    }

    @Override
    public boolean sfDisjoint(Shape s1, Shape s2) {
        return SpatialRelation.DISJOINT == s1.relate(s2);
    }

    @Override
    public boolean sfIntersects(Shape s1, Shape s2) {
        return SpatialRelation.INTERSECTS == s1.relate(s2);
    }

    @Override
    public boolean sfTouches(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean sfCrosses(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean sfWithin(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean sfContains(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean sfOverlaps(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean ehDisjoint(Shape s1, Shape s2) {
        return SpatialRelation.DISJOINT == s1.relate(s2);
    }

    @Override
    public boolean ehMeet(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean ehOverlap(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean ehCovers(Shape s1, Shape s2) {
        return SpatialRelation.CONTAINS == s1.relate(s2);
    }

    @Override
    public boolean ehCoveredBy(Shape s1, Shape s2) {
        return SpatialRelation.WITHIN == s1.relate(s2);
    }

    @Override
    public boolean ehInside(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean ehContains(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean rcc8dc(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean rcc8ec(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean rcc8po(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean rcc8tppi(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean rcc8tpp(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean rcc8ntpp(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }

    @Override
    public boolean rcc8ntppi(Shape s1, Shape s2) {
        return (Boolean)this.notSupported();
    }
}

