/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.http;

import java.io.IOException;
import org.eclipse.rdf4j.http.client.SparqlSession;
import org.eclipse.rdf4j.http.client.query.AbstractHTTPQuery;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.http.HTTPQueryEvaluationException;
import org.eclipse.rdf4j.repository.http.HTTPRepositoryConnection;

public class HTTPTupleQuery
extends AbstractHTTPQuery
implements TupleQuery {
    private final HTTPRepositoryConnection conn;

    public HTTPTupleQuery(HTTPRepositoryConnection conn, QueryLanguage ql, String queryString, String baseURI) {
        super((SparqlSession)conn.getSesameSession(), ql, queryString, baseURI);
        this.conn = conn;
    }

    public TupleQueryResult evaluate() throws QueryEvaluationException {
        SparqlSession client = this.getHttpClient();
        try {
            this.conn.flushTransactionState(Protocol.Action.QUERY);
            return client.sendTupleQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.getIncludeInferred(), this.getMaxExecutionTime(), this.getBindingsArray());
        }
        catch (IOException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        SparqlSession client = this.getHttpClient();
        try {
            this.conn.flushTransactionState(Protocol.Action.QUERY);
            client.sendTupleQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.includeInferred, this.getMaxExecutionTime(), handler, this.getBindingsArray());
        }
        catch (IOException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }
}

