/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;

public class IterationWrapper<E, X extends Exception>
extends AbstractCloseableIteration<E, X> {
    @Deprecated
    protected final Iteration<? extends E, ? extends X> wrappedIter;

    public IterationWrapper(Iteration<? extends E, ? extends X> iter) {
        assert (iter != null);
        this.wrappedIter = iter;
    }

    @Override
    public boolean hasNext() throws X {
        if (this.isClosed()) {
            return false;
        }
        if (Thread.currentThread().isInterrupted()) {
            this.close();
            return false;
        }
        boolean result = this.wrappedIter.hasNext();
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public E next() throws X {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        if (Thread.currentThread().isInterrupted()) {
            this.close();
            throw new NoSuchElementException("The iteration has been interrupted.");
        }
        try {
            return this.wrappedIter.next();
        }
        catch (NoSuchElementException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void remove() throws X {
        if (this.isClosed()) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        if (Thread.currentThread().isInterrupted()) {
            this.close();
            throw new IllegalStateException("The iteration has been interrupted.");
        }
        try {
            this.wrappedIter.remove();
        }
        catch (IllegalStateException e) {
            this.close();
            throw e;
        }
    }

    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            Iterations.closeCloseable(this.wrappedIter);
        }
    }
}

