/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedHttpClientSessionManager
implements HttpClientSessionManager,
HttpClientDependent {
    private static final int cores = System.getProperty("org.eclipse.rdf4j.client.executors.jdkbug") != null ? 1 : 0;
    private static final AtomicLong threadCount = new AtomicLong();
    private final Logger logger = LoggerFactory.getLogger(SharedHttpClientSessionManager.class);
    private volatile HttpClient httpClient;
    private volatile CloseableHttpClient dependentClient;
    private final ScheduledExecutorService executor;
    private volatile HttpClientBuilder httpClientBuilder;
    private final Map<SPARQLProtocolSession, Boolean> openSessions = new ConcurrentHashMap<SPARQLProtocolSession, Boolean>();

    public SharedHttpClientSessionManager() {
        final ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        this.executor = Executors.newScheduledThreadPool(cores, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = backingThreadFactory.newThread(runnable);
                thread.setName(String.format("rdf4j-sesameclientimpl-%d", threadCount.getAndIncrement()));
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public SharedHttpClientSessionManager(CloseableHttpClient dependentClient, ScheduledExecutorService dependentExecutorService) {
        this.dependentClient = Objects.requireNonNull(dependentClient, "HTTP client was null");
        this.httpClient = this.dependentClient;
        this.executor = Objects.requireNonNull(dependentExecutorService, "Executor service was null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClient getHttpClient() {
        HttpClient result = this.httpClient;
        if (result == null) {
            SharedHttpClientSessionManager sharedHttpClientSessionManager = this;
            synchronized (sharedHttpClientSessionManager) {
                result = this.httpClient;
                if (result == null) {
                    this.dependentClient = this.createHttpClient();
                    this.httpClient = this.dependentClient;
                    result = this.dependentClient;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHttpClient(HttpClient httpClient) {
        SharedHttpClientSessionManager sharedHttpClientSessionManager = this;
        synchronized (sharedHttpClientSessionManager) {
            this.httpClient = Objects.requireNonNull(httpClient, "HTTP Client cannot be null");
            CloseableHttpClient toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                HttpClientUtils.closeQuietly((HttpClient)toCloseDependentClient);
            }
        }
    }

    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder nextHttpClientBuilder = this.httpClientBuilder;
        if (nextHttpClientBuilder != null) {
            return nextHttpClientBuilder.build();
        }
        return HttpClientBuilder.create().useSystemProperties().disableAutomaticRetries().build();
    }

    @Override
    public SPARQLProtocolSession createSPARQLProtocolSession(String queryEndpointUrl, String updateEndpointUrl) {
        SPARQLProtocolSession session = new SPARQLProtocolSession(this.getHttpClient(), this.executor){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    SharedHttpClientSessionManager.this.openSessions.remove(this);
                }
            }
        };
        session.setQueryURL(queryEndpointUrl);
        session.setUpdateURL(updateEndpointUrl);
        this.openSessions.put(session, true);
        return session;
    }

    @Override
    public RDF4JProtocolSession createRDF4JProtocolSession(String serverURL) {
        RDF4JProtocolSession session = new RDF4JProtocolSession(this.getHttpClient(), this.executor){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    SharedHttpClientSessionManager.this.openSessions.remove(this);
                }
            }
        };
        session.setServerURL(serverURL);
        this.openSessions.put(session, true);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() {
        try {
            this.openSessions.keySet().forEach(session -> {
                try {
                    session.close();
                }
                catch (Exception e) {
                    this.logger.error(e.toString(), (Throwable)e);
                }
            });
            CloseableHttpClient toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                HttpClientUtils.closeQuietly((HttpClient)toCloseDependentClient);
            }
        }
        finally {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (!this.executor.isTerminated()) {
                    this.executor.shutdownNow();
                }
            }
        }
    }

    @Deprecated
    public void initialize() {
    }
}

