/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.RDFHandlerWrapper;

public class BufferedGroupingRDFHandler
extends RDFHandlerWrapper {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final int bufferSize;
    private final Model bufferedStatements;
    private final Set<Resource> contexts;
    private final Object bufferLock = new Object();

    public BufferedGroupingRDFHandler(RDFHandler ... handlers) {
        this(1024, handlers);
    }

    public BufferedGroupingRDFHandler(int bufferSize, RDFHandler ... handlers) {
        super(handlers);
        this.bufferSize = bufferSize;
        this.bufferedStatements = this.getModelFactory().createEmptyModel();
        this.contexts = new HashSet<Resource>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.bufferedStatements.add(st);
            this.contexts.add(st.getContext());
            if (this.bufferedStatements.size() >= this.bufferSize) {
                this.processBuffer();
            }
        }
    }

    private void processBuffer() throws RDFHandlerException {
        for (Resource context : this.contexts) {
            Model contextData = this.bufferedStatements.filter(null, null, null, context);
            Set<Resource> subjects = contextData.subjects();
            for (Resource subject : subjects) {
                HashSet<IRI> processedPredicates = new HashSet<IRI>();
                for (Statement typeStatement : contextData.filter(subject, RDF.TYPE, null, new Resource[0])) {
                    super.handleStatement(typeStatement);
                }
                processedPredicates.add(RDF.TYPE);
                for (Statement subjectStatement : contextData.filter(subject, null, null, new Resource[0])) {
                    IRI predicate = subjectStatement.getPredicate();
                    if (processedPredicates.contains(predicate)) continue;
                    for (Statement toWrite : contextData.filter(subject, predicate, null, new Resource[0])) {
                        super.handleStatement(toWrite);
                    }
                    processedPredicates.add(predicate);
                }
            }
        }
        this.bufferedStatements.clear();
        this.contexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endRDF() throws RDFHandlerException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.processBuffer();
        }
        super.endRDF();
    }
}

