/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencerConnection;

public class SchemaCachingRDFSInferencer
extends NotifyingSailWrapper {
    Repository schema;
    private final ReentrantLock exclusiveWriteLock = new ReentrantLock(true);
    boolean useAllRdfsRules = true;
    protected volatile boolean useInferredToCreateSchema;
    private final Collection<Resource> properties = new HashSet<Resource>();
    private final Collection<Resource> types = new HashSet<Resource>();
    private final Collection<Statement> subClassOfStatements = new HashSet<Statement>();
    private final Collection<Statement> subPropertyOfStatements = new HashSet<Statement>();
    private final Collection<Statement> rangeStatements = new HashSet<Statement>();
    private final Collection<Statement> domainStatements = new HashSet<Statement>();
    private final Map<Resource, Set<Resource>> calculatedTypes = new HashMap<Resource, Set<Resource>>();
    private final Map<Resource, Set<Resource>> calculatedProperties = new HashMap<Resource, Set<Resource>>();
    private final Map<Resource, Set<Resource>> calculatedRange = new HashMap<Resource, Set<Resource>>();
    private final Map<Resource, Set<Resource>> calculatedDomain = new HashMap<Resource, Set<Resource>>();
    private boolean sharedSchema;
    private boolean addInferredStatementsToDefaultContext = false;

    public SchemaCachingRDFSInferencer() {
        this.schema = null;
    }

    public SchemaCachingRDFSInferencer(NotifyingSail data) {
        super(data);
        this.schema = null;
    }

    public SchemaCachingRDFSInferencer(NotifyingSail data, Repository schema) {
        super(data);
        this.schema = schema;
    }

    public SchemaCachingRDFSInferencer(NotifyingSail data, boolean useAllRdfsRules) {
        super(data);
        this.schema = null;
        this.useAllRdfsRules = useAllRdfsRules;
    }

    public SchemaCachingRDFSInferencer(NotifyingSail data, Repository schema, boolean useAllRdfsRules) {
        super(data);
        this.schema = schema;
        this.useAllRdfsRules = useAllRdfsRules;
    }

    void clearInferenceTables() {
        this.acquireExclusiveWriteLock();
        this.properties.clear();
        this.types.clear();
        this.subClassOfStatements.clear();
        this.subPropertyOfStatements.clear();
        this.rangeStatements.clear();
        this.domainStatements.clear();
        this.calculatedTypes.clear();
        this.calculatedProperties.clear();
        this.calculatedRange.clear();
        this.calculatedDomain.clear();
    }

    void acquireExclusiveWriteLock() {
        if (this.exclusiveWriteLock.isHeldByCurrentThread()) {
            return;
        }
        try {
            this.exclusiveWriteLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
    }

    void releaseExclusiveWriteLock() {
        while (this.exclusiveWriteLock.isHeldByCurrentThread()) {
            this.exclusiveWriteLock.unlock();
        }
    }

    @Override
    public void initialize() throws SailException {
        super.initialize();
        if (this.sharedSchema) {
            return;
        }
        try (SchemaCachingRDFSInferencerConnection conn = this.getConnection();){
            conn.begin();
            conn.addAxiomStatements();
            List<Object> tboxStatments = new ArrayList();
            if (this.schema != null) {
                try (RepositoryConnection schemaConnection = this.schema.getConnection();){
                    schemaConnection.begin();
                    RepositoryResult<Statement> statements = schemaConnection.getStatements(null, null, null, new Resource[0]);
                    tboxStatments = Iterations.stream(statements).peek(conn::processForSchemaCache).collect(Collectors.toList());
                    schemaConnection.commit();
                }
            }
            this.calculateInferenceMaps(conn, true);
            if (this.schema != null) {
                tboxStatments.forEach(statement -> conn.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext()));
            }
            conn.commit();
        }
    }

    @Override
    public SchemaCachingRDFSInferencerConnection getConnection() throws SailException {
        InferencerConnection e = (InferencerConnection)super.getConnection();
        return new SchemaCachingRDFSInferencerConnection(this, e);
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.getBaseSail().getValueFactory();
    }

    public static SchemaCachingRDFSInferencer fastInstantiateFrom(SchemaCachingRDFSInferencer sailToInstantiateFrom, NotifyingSail store) {
        return SchemaCachingRDFSInferencer.fastInstantiateFrom(sailToInstantiateFrom, store, true);
    }

    public static SchemaCachingRDFSInferencer fastInstantiateFrom(SchemaCachingRDFSInferencer sailToInstantiateFrom, NotifyingSail store, boolean useAllRdfsRules) {
        sailToInstantiateFrom.getConnection().close();
        SchemaCachingRDFSInferencer ret = new SchemaCachingRDFSInferencer(store, sailToInstantiateFrom.schema, useAllRdfsRules);
        ret.sharedSchema = true;
        sailToInstantiateFrom.calculatedTypes.forEach((key, value) -> value.forEach(v -> {
            if (!ret.calculatedTypes.containsKey(key)) {
                ret.calculatedTypes.put((Resource)key, new HashSet());
            }
            ret.calculatedTypes.get(key).add((Resource)v);
        }));
        sailToInstantiateFrom.calculatedProperties.forEach((key, value) -> value.forEach(v -> {
            if (!ret.calculatedProperties.containsKey(key)) {
                ret.calculatedProperties.put((Resource)key, new HashSet());
            }
            ret.calculatedProperties.get(key).add((Resource)v);
        }));
        sailToInstantiateFrom.calculatedRange.forEach((key, value) -> value.forEach(v -> {
            if (!ret.calculatedRange.containsKey(key)) {
                ret.calculatedRange.put((Resource)key, new HashSet());
            }
            ret.calculatedRange.get(key).add((Resource)v);
        }));
        sailToInstantiateFrom.calculatedDomain.forEach((key, value) -> value.forEach(v -> {
            if (!ret.calculatedDomain.containsKey(key)) {
                ret.calculatedDomain.put((Resource)key, new HashSet());
            }
            ret.calculatedDomain.get(key).add((Resource)v);
        }));
        return ret;
    }

    long getSchemaSize() {
        return this.subClassOfStatements.size() + this.subPropertyOfStatements.size() + this.rangeStatements.size() + this.domainStatements.size() + this.properties.size() + this.types.size();
    }

    void calculateInferenceMaps(SchemaCachingRDFSInferencerConnection conn, boolean addInferred) {
        this.calculateSubClassOf(this.subClassOfStatements);
        this.properties.forEach(predicate -> {
            if (addInferred) {
                conn.addInferredStatementInternal((Resource)predicate, RDF.TYPE, RDF.PROPERTY, new Resource[0]);
            }
            this.calculatedProperties.put((Resource)predicate, new HashSet());
        });
        this.calculateSubPropertyOf(this.subPropertyOfStatements);
        this.calculateRangeDomain(this.rangeStatements, this.calculatedRange);
        this.calculateRangeDomain(this.domainStatements, this.calculatedDomain);
        if (addInferred) {
            this.calculatedTypes.forEach((subClass, superClasses) -> {
                conn.addInferredStatementInternal((Resource)subClass, RDFS.SUBCLASSOF, (Value)subClass, new Resource[0]);
                superClasses.forEach(superClass -> {
                    conn.addInferredStatementInternal((Resource)subClass, RDFS.SUBCLASSOF, (Value)superClass, new Resource[0]);
                    conn.addInferredStatementInternal((Resource)superClass, RDFS.SUBCLASSOF, (Value)superClass, new Resource[0]);
                });
            });
        }
        if (addInferred) {
            this.calculatedProperties.forEach((sub, sups) -> {
                conn.addInferredStatementInternal((Resource)sub, RDFS.SUBPROPERTYOF, (Value)sub, new Resource[0]);
                sups.forEach(sup -> {
                    conn.addInferredStatementInternal((Resource)sub, RDFS.SUBPROPERTYOF, (Value)sup, new Resource[0]);
                    conn.addInferredStatementInternal((Resource)sup, RDFS.SUBPROPERTYOF, (Value)sup, new Resource[0]);
                });
            });
        }
    }

    void addSubClassOfStatement(Statement st) {
        this.subClassOfStatements.add(st);
        this.types.add(st.getSubject());
        this.types.add((Resource)st.getObject());
    }

    void addSubPropertyOfStatement(Statement st) {
        this.subPropertyOfStatements.add(st);
        this.properties.add(st.getSubject());
        this.properties.add((Resource)st.getObject());
    }

    void addRangeStatement(Statement st) {
        this.rangeStatements.add(st);
        this.properties.add(st.getSubject());
        this.types.add((Resource)st.getObject());
    }

    void addDomainStatement(Statement st) {
        this.domainStatements.add(st);
        this.properties.add(st.getSubject());
        this.types.add((Resource)st.getObject());
    }

    boolean hasType(Resource r) {
        return this.types.contains(r);
    }

    void addType(Resource r) {
        this.types.add(r);
    }

    boolean hasProperty(Resource property) {
        return this.properties.contains(property);
    }

    void addProperty(Resource property) {
        this.properties.add(property);
    }

    Set<Resource> resolveTypes(Resource value) {
        Set<Resource> iris = this.calculatedTypes.get(value);
        return iris != null ? iris : Collections.emptySet();
    }

    Set<Resource> resolveProperties(Resource predicate) {
        Set<Resource> iris = this.calculatedProperties.get(predicate);
        return iris != null ? iris : Collections.emptySet();
    }

    Set<Resource> resolveRangeTypes(IRI predicate) {
        Set<Resource> iris = this.calculatedRange.get(predicate);
        return iris != null ? iris : Collections.emptySet();
    }

    Set<Resource> resolveDomainTypes(IRI predicate) {
        Set<Resource> iris = this.calculatedDomain.get(predicate);
        return iris != null ? iris : Collections.emptySet();
    }

    private void calculateSubClassOf(Collection<Statement> subClassOfStatements) {
        this.types.forEach(type -> {
            if (!this.calculatedTypes.containsKey(type)) {
                this.calculatedTypes.put((Resource)type, new HashSet());
            }
            this.calculatedTypes.get(type).add((Resource)type);
        });
        subClassOfStatements.forEach(s -> {
            Resource subClass = s.getSubject();
            if (!this.calculatedTypes.containsKey(subClass)) {
                this.calculatedTypes.put(subClass, new HashSet());
            }
            this.calculatedTypes.get(subClass).add((Resource)s.getObject());
        });
        long prevSize = 0L;
        long[] newSize = new long[]{-1L};
        while (prevSize != newSize[0]) {
            prevSize = newSize[0];
            newSize[0] = 0L;
            this.calculatedTypes.forEach((key, value) -> {
                ArrayList temp = new ArrayList();
                value.forEach(superClass -> temp.addAll(this.resolveTypes((Resource)superClass)));
                value.addAll(temp);
                newSize[0] = newSize[0] + (long)value.size();
            });
        }
    }

    private void calculateSubPropertyOf(Collection<Statement> subPropertyOfStatemenets) {
        subPropertyOfStatemenets.forEach(s -> {
            Resource subClass = s.getSubject();
            Resource superClass = (Resource)s.getObject();
            if (!this.calculatedProperties.containsKey(subClass)) {
                this.calculatedProperties.put(subClass, new HashSet());
            }
            if (!this.calculatedProperties.containsKey(superClass)) {
                this.calculatedProperties.put(superClass, new HashSet());
            }
            this.calculatedProperties.get(subClass).add((Resource)s.getObject());
        });
        long prevSize = 0L;
        long[] newSize = new long[]{-1L};
        while (prevSize != newSize[0]) {
            prevSize = newSize[0];
            newSize[0] = 0L;
            this.calculatedProperties.forEach((key, value) -> {
                ArrayList temp = new ArrayList();
                value.forEach(superProperty -> temp.addAll(this.resolveProperties((Resource)superProperty)));
                value.addAll(temp);
                newSize[0] = newSize[0] + (long)value.size();
            });
        }
    }

    private void calculateRangeDomain(Collection<Statement> rangeOrDomainStatements, Map<Resource, Set<Resource>> calculatedRangeOrDomain) {
        rangeOrDomainStatements.forEach(s -> {
            Resource predicate = s.getSubject();
            if (!this.calculatedProperties.containsKey(predicate)) {
                this.calculatedProperties.put(predicate, new HashSet());
            }
            if (!calculatedRangeOrDomain.containsKey(predicate)) {
                calculatedRangeOrDomain.put(predicate, new HashSet());
            }
            ((Set)calculatedRangeOrDomain.get(predicate)).add((Resource)s.getObject());
            if (!this.calculatedTypes.containsKey(s.getObject())) {
                this.calculatedTypes.put((Resource)s.getObject(), new HashSet());
            }
        });
        this.calculatedProperties.keySet().stream().filter(key -> !calculatedRangeOrDomain.containsKey(key)).forEach(key -> {
            Set cfr_ignored_0 = calculatedRangeOrDomain.put((Resource)key, new HashSet());
        });
        long prevSize = 0L;
        long[] newSize = new long[]{-1L};
        while (prevSize != newSize[0]) {
            prevSize = newSize[0];
            newSize[0] = 0L;
            calculatedRangeOrDomain.forEach((key, value) -> {
                ArrayList resolvedBySubProperty = new ArrayList();
                this.resolveProperties((Resource)key).forEach(newPredicate -> {
                    Set iris = (Set)calculatedRangeOrDomain.get(newPredicate);
                    if (iris != null) {
                        resolvedBySubProperty.addAll(iris);
                    }
                });
                ArrayList resolvedBySubClass = new ArrayList();
                value.addAll(resolvedBySubProperty);
                value.stream().map(this::resolveTypes).forEach(resolvedBySubClass::addAll);
                value.addAll(resolvedBySubClass);
                newSize[0] = newSize[0] + (long)value.size();
            });
        }
    }

    @Override
    public IsolationLevel getDefaultIsolationLevel() {
        IsolationLevel level = super.getDefaultIsolationLevel();
        if (level.isCompatibleWith(IsolationLevels.READ_COMMITTED)) {
            return level;
        }
        List<IsolationLevel> supported = this.getSupportedIsolationLevels();
        return IsolationLevels.getCompatibleIsolationLevel(IsolationLevels.READ_COMMITTED, supported);
    }

    @Override
    public List<IsolationLevel> getSupportedIsolationLevels() {
        List<IsolationLevel> supported = super.getSupportedIsolationLevels();
        ArrayList<IsolationLevel> levels = new ArrayList<IsolationLevel>(supported.size());
        for (IsolationLevel level : supported) {
            if (!level.isCompatibleWith(IsolationLevels.READ_COMMITTED)) continue;
            levels.add(level);
        }
        return levels;
    }

    public boolean isAddInferredStatementsToDefaultContext() {
        return this.addInferredStatementsToDefaultContext;
    }

    public void setAddInferredStatementsToDefaultContext(boolean addInferredStatementsToDefaultContext) {
        this.addInferredStatementsToDefaultContext = addInferredStatementsToDefaultContext;
    }
}

