/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryContext;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.AbstractFederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.BindingAssigner;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.CompareOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ConstantOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.FilterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.IterativeEvaluationOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.OrderLimitOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryModelNormalizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.TupleFunctionEvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.TupleFunctionEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.QueryContextIteration;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.evaluation.SailTripleSource;
import org.eclipse.rdf4j.sail.evaluation.TupleFunctionEvaluationMode;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.lucene.BindingSetCollection;
import org.eclipse.rdf4j.sail.lucene.LuceneSail;
import org.eclipse.rdf4j.sail.lucene.LuceneSailBuffer;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchIndexQueryContextInitializer;
import org.eclipse.rdf4j.sail.lucene.SearchQueryEvaluator;
import org.eclipse.rdf4j.sail.lucene.SearchQueryInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSailConnection
extends NotifyingSailConnectionWrapper {
    private static final Set<Class<? extends QueryModelNode>> PROJECTION_TYPES = Sets.newHashSet((Object[])new Class[]{Projection.class, MultiProjection.class});
    private final Logger logger = LoggerFactory.getLogger(LuceneSailConnection.class);
    private final SearchIndex luceneIndex;
    private final AbstractFederatedServiceResolver tupleFunctionServiceResolver;
    private final LuceneSail sail;
    private final LuceneSailBuffer buffer = new LuceneSailBuffer();
    protected final SailConnectionListener connectionListener = new SailConnectionListener(){

        @Override
        public void statementAdded(Statement statement) {
            if (statement.getObject() instanceof Literal) {
                statement = LuceneSailConnection.this.sail.mapStatement(statement);
                if (statement == null) {
                    return;
                }
                Literal literal = (Literal)statement.getObject();
                if (LuceneSailConnection.this.luceneIndex.accept(literal)) {
                    LuceneSailConnection.this.buffer.add(statement);
                }
            }
        }

        @Override
        public void statementRemoved(Statement statement) {
            if (statement.getObject() instanceof Literal) {
                statement = LuceneSailConnection.this.sail.mapStatement(statement);
                if (statement == null) {
                    return;
                }
                Literal literal = (Literal)statement.getObject();
                if (LuceneSailConnection.this.luceneIndex.accept(literal)) {
                    LuceneSailConnection.this.buffer.remove(statement);
                }
            }
        }
    };
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public LuceneSailConnection(NotifyingSailConnection wrappedConnection, SearchIndex luceneIndex, LuceneSail sail) {
        super(wrappedConnection);
        this.luceneIndex = luceneIndex;
        this.sail = sail;
        if (sail.getEvaluationMode() == TupleFunctionEvaluationMode.SERVICE) {
            FederatedServiceResolver resolver = sail.getFederatedServiceResolver();
            if (!(resolver instanceof AbstractFederatedServiceResolver)) {
                throw new IllegalArgumentException("SERVICE EvaluationMode requires a FederatedServiceResolver that is an instance of " + AbstractFederatedServiceResolver.class.getName());
            }
            this.tupleFunctionServiceResolver = (AbstractFederatedServiceResolver)resolver;
        } else {
            this.tupleFunctionServiceResolver = null;
        }
        wrappedConnection.addConnectionListener(this.connectionListener);
    }

    @Override
    public synchronized void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        super.addStatement(subj, pred, obj, contexts);
    }

    @Override
    public void close() throws SailException {
        if (this.closed.compareAndSet(false, true)) {
            super.close();
        }
    }

    @Override
    public synchronized void clear(Resource ... contexts) throws SailException {
        this.getWrappedConnection().removeConnectionListener(this.connectionListener);
        try {
            super.clear(contexts);
            this.buffer.clear(contexts);
        }
        finally {
            this.getWrappedConnection().addConnectionListener(this.connectionListener);
        }
    }

    @Override
    public void begin() throws SailException {
        super.begin();
        this.buffer.reset();
        try {
            this.luceneIndex.begin();
        }
        catch (IOException e) {
            throw new SailException(e);
        }
    }

    @Override
    public void commit() throws SailException {
        super.commit();
        this.logger.debug("Committing Lucene transaction with {} operations.", (Object)this.buffer.operations().size());
        try {
            this.buffer.optimize();
            Iterator<LuceneSailBuffer.Operation> i = this.buffer.operations().iterator();
            while (i.hasNext()) {
                LuceneSailBuffer.Operation op = i.next();
                if (op instanceof LuceneSailBuffer.AddRemoveOperation) {
                    LuceneSailBuffer.AddRemoveOperation addremove = (LuceneSailBuffer.AddRemoveOperation)op;
                    this.addRemoveStatements(addremove.getAdded(), addremove.getRemoved());
                } else if (op instanceof LuceneSailBuffer.ClearContextOperation) {
                    this.clearContexts(((LuceneSailBuffer.ClearContextOperation)op).getContexts());
                } else if (op instanceof LuceneSailBuffer.ClearOperation) {
                    this.logger.debug("clearing index...");
                    this.luceneIndex.clear();
                } else {
                    throw new SailException("Cannot interpret operation " + op + " of type " + op.getClass().getName());
                }
                i.remove();
            }
        }
        catch (Exception e) {
            this.logger.error("Committing operations in lucenesail, encountered exception " + e + ". Only some operations were stored, " + this.buffer.operations().size() + " operations are discarded. Lucene Index is now corrupt.", (Throwable)e);
            throw new SailException(e);
        }
        finally {
            this.buffer.reset();
        }
    }

    private void addRemoveStatements(Set<Statement> toAdd, Set<Statement> toRemove) throws IOException {
        this.logger.debug("indexing {}/removing {} statements...", (Object)toAdd.size(), (Object)toRemove.size());
        this.luceneIndex.begin();
        try {
            this.luceneIndex.addRemoveStatements(toAdd, toRemove);
            this.luceneIndex.commit();
        }
        catch (IOException e) {
            this.logger.error("Rolling back", (Throwable)e);
            this.luceneIndex.rollback();
            throw e;
        }
    }

    private void clearContexts(Resource ... contexts) throws IOException {
        this.logger.debug("clearing contexts...");
        this.luceneIndex.begin();
        try {
            this.luceneIndex.clearContexts(contexts);
            this.luceneIndex.commit();
        }
        catch (IOException e) {
            this.logger.error("Rolling back", (Throwable)e);
            this.luceneIndex.rollback();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        CloseableIteration<? extends BindingSet, QueryEvaluationException> iter;
        QueryContext qctx = new QueryContext();
        SearchIndexQueryContextInitializer.init(qctx, this.luceneIndex);
        qctx.begin();
        try {
            iter = this.evaluateInternal(tupleExpr, dataset, bindings, includeInferred);
        }
        finally {
            qctx.end();
        }
        return new QueryContextIteration(iter, qctx);
    }

    private CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        if (!((tupleExpr = tupleExpr.clone()) instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        new BindingAssigner().optimize(tupleExpr, dataset, bindings);
        ArrayList<SearchQueryEvaluator> queries = new ArrayList<SearchQueryEvaluator>();
        for (SearchQueryInterpreter interpreter : this.sail.getSearchQueryInterpreters()) {
            interpreter.process(tupleExpr, bindings, queries);
        }
        if (!queries.isEmpty()) {
            this.evaluateLuceneQueries(queries, tupleExpr);
        }
        if (this.sail.getEvaluationMode() == TupleFunctionEvaluationMode.TRIPLE_SOURCE) {
            ValueFactory vf = this.sail.getValueFactory();
            TupleFunctionEvaluationStrategy strategy = new TupleFunctionEvaluationStrategy((TripleSource)new SailTripleSource(this, includeInferred, vf), dataset, this.sail.getFederatedServiceResolver(), this.sail.getTupleFunctionRegistry());
            new BindingAssigner().optimize(tupleExpr, dataset, bindings);
            new ConstantOptimizer(strategy).optimize(tupleExpr, dataset, bindings);
            new CompareOptimizer().optimize(tupleExpr, dataset, bindings);
            new ConjunctiveConstraintSplitter().optimize(tupleExpr, dataset, bindings);
            new DisjunctiveConstraintOptimizer().optimize(tupleExpr, dataset, bindings);
            new SameTermFilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new QueryModelNormalizer().optimize(tupleExpr, dataset, bindings);
            new QueryJoinOptimizer(new TupleFunctionEvaluationStatistics()).optimize(tupleExpr, dataset, bindings);
            new IterativeEvaluationOptimizer().optimize(tupleExpr, dataset, bindings);
            new FilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new OrderLimitOptimizer().optimize(tupleExpr, dataset, bindings);
            this.logger.trace("Optimized query model:\n{}", (Object)tupleExpr);
            try {
                return strategy.evaluate(tupleExpr, bindings);
            }
            catch (QueryEvaluationException e) {
                throw new SailException(e);
            }
        }
        return super.evaluate(tupleExpr, dataset, bindings, includeInferred);
    }

    private void evaluateLuceneQueries(Collection<SearchQueryEvaluator> queries, TupleExpr tupleExpr) throws SailException {
        if (this.closed.get()) {
            throw new SailException("Sail has been closed already");
        }
        for (SearchQueryEvaluator query : queries) {
            boolean hasResult;
            Collection<BindingSet> bindingSets = this.luceneIndex.evaluate(query);
            boolean bl = hasResult = bindingSets != null && !bindingSets.isEmpty();
            if (hasResult) {
                BindingSetAssignment bsa = new BindingSetAssignment();
                bsa.setBindingSets(bindingSets);
                if (bindingSets instanceof BindingSetCollection) {
                    bsa.setBindingNames(((BindingSetCollection)bindingSets).getBindingNames());
                }
                this.addBindingSets(query, bsa);
            }
            query.updateQueryModelNodes(hasResult);
        }
    }

    private void addBindingSets(SearchQueryEvaluator query, BindingSetAssignment bindingSets) {
        QueryModelNode principalNode = query.getParentQueryModelNode();
        final UnaryTupleOperator projection = (UnaryTupleOperator)this.getParentNodeOfTypes(principalNode, PROJECTION_TYPES);
        if (projection == null) {
            this.logger.error("Could not add bindings to the query tree because no projection was found for the query node: {}", (Object)principalNode);
            return;
        }
        final ArrayList assignments = new ArrayList();
        AbstractQueryModelVisitor<RuntimeException> assignmentVisitor = new AbstractQueryModelVisitor<RuntimeException>(){

            @Override
            public void meet(BindingSetAssignment node) throws RuntimeException {
                QueryModelNode parent = LuceneSailConnection.this.getParentNodeOfTypes(node, PROJECTION_TYPES);
                if (parent != null && parent.equals(projection)) {
                    assignments.add(node);
                }
            }
        };
        projection.visit(assignmentVisitor);
        ArrayList<BindingSetAssignment> bindingSetsList = new ArrayList<BindingSetAssignment>();
        bindingSetsList.add(bindingSets);
        for (BindingSetAssignment assignment : assignments) {
            bindingSetsList.add(assignment);
            assignment.replaceWith(new SingletonSet());
        }
        BindingSetAssignment bindings = this.joinBindingSets(bindingSetsList.iterator());
        TupleExpr arg = projection.getArg();
        if (arg instanceof LeftJoin) {
            LeftJoin binary = (LeftJoin)arg;
            Join join = new Join(bindings, binary.getLeftArg());
            binary.setLeftArg(join);
        } else {
            Join join = new Join(bindings, arg);
            projection.setArg(join);
        }
    }

    private QueryModelNode getParentNodeOfTypes(QueryModelNode node, Set<Class<? extends QueryModelNode>> types) {
        QueryModelNode parent = node.getParentNode();
        if (parent == null) {
            return null;
        }
        if (types.contains(parent.getClass())) {
            return parent;
        }
        return this.getParentNodeOfTypes(parent, types);
    }

    private BindingSetAssignment joinBindingSets(Iterator<BindingSetAssignment> iterator) {
        if (iterator.hasNext()) {
            BindingSetAssignment left = iterator.next();
            BindingSetAssignment right = this.joinBindingSets(iterator);
            if (right != null) {
                return this.crossJoin(left, right);
            }
            return left;
        }
        return null;
    }

    private BindingSetAssignment crossJoin(BindingSetAssignment left, BindingSetAssignment right) {
        Iterable<BindingSet> leftIter = left.getBindingSets();
        Iterable<BindingSet> rightIter = right.getBindingSets();
        int leftSize = LuceneSailConnection.size(leftIter, 16);
        int rightSize = LuceneSailConnection.size(rightIter, 16);
        ArrayList<BindingSet> output = new ArrayList<BindingSet>(leftSize * rightSize);
        for (BindingSet l : leftIter) {
            for (BindingSet r : rightIter) {
                QueryBindingSet bs = new QueryBindingSet();
                bs.addAll(l);
                bs.addAll(r);
                output.add(bs);
            }
        }
        HashSet<String> bindingNames = new HashSet<String>(left.getBindingNames());
        bindingNames.addAll(right.getBindingNames());
        BindingSetAssignment bindings = new BindingSetAssignment();
        bindings.setBindingSets(output);
        bindings.setBindingNames(bindingNames);
        return bindings;
    }

    private static int size(Iterable<?> iter, int defaultSize) {
        return iter instanceof Collection ? ((Collection)iter).size() : defaultSize;
    }

    @Override
    public synchronized void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        super.removeStatements(subj, pred, obj, contexts);
    }

    @Override
    public void rollback() throws SailException {
        super.rollback();
        this.buffer.reset();
        try {
            this.luceneIndex.rollback();
        }
        catch (IOException e) {
            throw new SailException(e);
        }
    }
}

