/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.ExternalTypeFilterNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.ModifyTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.Sort;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleLengthFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPropertyShape
extends PathPropertyShape {
    private final Resource classResource;
    private static final Logger logger = LoggerFactory.getLogger(ClassPropertyShape.class);

    ClassPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Resource classResource) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.classResource = classResource;
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNodeProvider overrideTargetNode) {
        if (this.deactivated) {
            return null;
        }
        SailConnection addedStatements = shaclSailConnection.getAddedStatements();
        if (overrideTargetNode != null) {
            PlanNode planNode = this.getPath() == null ? new ModifyTuple(overrideTargetNode.getPlanNode(), t -> {
                t.line.add(t.line.get(0));
                return t;
            }) : new LoggingNode(new BulkedExternalInnerJoin(overrideTargetNode.getPlanNode(), shaclSailConnection, this.getPath().getQuery("?a", "?c", null), false), "");
            LoggingNode addedStatementsTypeFilter = new LoggingNode(new ExternalTypeFilterNode(addedStatements, Collections.singleton(this.classResource), planNode, 1, false), "");
            LoggingNode invalidTuplesDueToDataAddedThatMatchesTargetOrPath = new LoggingNode(new ExternalTypeFilterNode(shaclSailConnection, Collections.singleton(this.classResource), addedStatementsTypeFilter, 1, false), "");
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, this);
        }
        if (this.getPath() != null && shaclSailConnection.stats.isBaseSailEmpty()) {
            String query = nodeShape.getQuery("?a", "?b", null);
            String query1 = this.getPath().getQuery("?a", "?d", null);
            String negationQuery = query + "\n" + query1 + "\n FILTER(NOT EXISTS{?d a <" + this.classResource + ">})\n";
            Select select = new Select(shaclSailConnection.getAddedStatements(), negationQuery, "?a", "?d");
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(select, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(new LoggingNode(select, ""), this);
        }
        if (this.getPath() == null) {
            ModifyTuple targets = new ModifyTuple(new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape, null), ""), t -> {
                t.line.add(t.line.get(0));
                return t;
            });
            LoggingNode filteredAgainstAdded = new LoggingNode(new ExternalTypeFilterNode(addedStatements, Collections.singleton(this.classResource), targets, 1, false), "");
            LoggingNode filteredAgainsteBaseSail = new LoggingNode(new ExternalTypeFilterNode(shaclSailConnection, Collections.singleton(this.classResource), filteredAgainstAdded, 1, false), "");
            if (shaclSailConnection.stats.hasRemoved()) {
                LoggingNode removedTypeStatements = new LoggingNode(new Select(shaclSailConnection.getRemovedStatements(), "?a a <" + this.classResource + ">", "*"), "");
                String query = nodeShape.getQuery("?a", "?q", shaclSailConnection.getRdfsSubClassOfReasoner());
                TrimTuple invalidDataDueToRemovedTypeStatement = new TrimTuple(new LoggingNode(new BulkedExternalInnerJoin(removedTypeStatements, shaclSailConnection, query, false), ""), 0, 1);
                filteredAgainsteBaseSail = new LoggingNode(new UnionNode(filteredAgainsteBaseSail, invalidDataDueToRemovedTypeStatement), "");
            }
            return new EnrichWithShape(filteredAgainsteBaseSail, this);
        }
        LoggingNode addedByPath = new LoggingNode(this.getPlanAddedStatements(shaclSailConnection, nodeShape, null), "");
        InnerJoin innerJoinHolder = new InnerJoin(new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape, null), ""), addedByPath);
        LoggingNode innerJoin = new LoggingNode(innerJoinHolder.getJoined(BufferedPlanNode.class), "");
        LoggingNode discardedRight = new LoggingNode(innerJoinHolder.getDiscardedRight(BufferedPlanNode.class), "");
        LoggingNode typeFilterPlan = new LoggingNode(nodeShape.getTargetFilter(shaclSailConnection, discardedRight), "");
        innerJoin = new LoggingNode(new Unique(new UnionNode(innerJoin, typeFilterPlan)), "");
        LoggingNode bulkedExternalLeftOuter = new LoggingNode(new BulkedExternalLeftOuterJoin(new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape, null), ""), shaclSailConnection, this.getPath().getQuery("?a", "?c", null), true), "");
        PlanNode joined = new TupleLengthFilter(new UnionNode(innerJoin, bulkedExternalLeftOuter), 2, false).getTrueNode(UnBufferedPlanNode.class);
        LoggingNode addedStatementsTypeFilter = new LoggingNode(new ExternalTypeFilterNode(addedStatements, Collections.singleton(this.classResource), joined, 1, false), "");
        LoggingNode invalidTuplesDueToDataAddedThatMatchesTargetOrPath = new LoggingNode(new ExternalTypeFilterNode(shaclSailConnection, Collections.singleton(this.classResource), addedStatementsTypeFilter, 1, false), "");
        if (shaclSailConnection.stats.hasRemoved()) {
            LoggingNode removedTypeStatements = new LoggingNode(new Select(shaclSailConnection.getRemovedStatements(), "?a a <" + this.classResource + ">", "*"), "removedTypeStatements");
            String query = this.getPath().getQuery("?c", "?a", null) + nodeShape.getQuery("?c", "?q", shaclSailConnection.getRdfsSubClassOfReasoner());
            Sort invalidDataDueToRemovedTypeStatement = new Sort(new ModifyTuple(new LoggingNode(new BulkedExternalInnerJoin(removedTypeStatements, shaclSailConnection, query, false), ""), t -> {
                List<Value> line = t.line;
                t.line = new ArrayList<Value>(2);
                t.line.add(line.get(2));
                t.line.add(line.get(0));
                return t;
            }));
            invalidTuplesDueToDataAddedThatMatchesTargetOrPath = new LoggingNode(new UnionNode(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, invalidDataDueToRemovedTypeStatement), "");
        }
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(invalidTuplesDueToDataAddedThatMatchesTargetOrPath, this);
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        if (this.deactivated) {
            return false;
        }
        return removedStatements.hasStatement(null, RDF.TYPE, this.classResource, true, new Resource[0]) || super.requiresEvaluation(addedStatements, removedStatements);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.ClassConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClassPropertyShape that = (ClassPropertyShape)o;
        return this.classResource.equals(that.classResource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.classResource);
    }

    public String toString() {
        return "ClassPropertyShape{classResource=" + this.classResource + ", path=" + this.getPath() + '}';
    }
}

