/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.AggregateIteratorTypeOverride;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.GroupByCount;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.MaxCountFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.ModifyTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxCountPropertyShape
extends PathPropertyShape {
    private static final Logger logger = LoggerFactory.getLogger(MaxCountPropertyShape.class);
    private long maxCount;

    MaxCountPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Long maxCount) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.maxCount = maxCount;
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNodeProvider overrideTargetNode) {
        PlanNode mergeNode1;
        if (this.deactivated) {
            return null;
        }
        if (overrideTargetNode != null) {
            LoggingNode bulkedExternalInnerJoin = new LoggingNode(new BulkedExternalInnerJoin(overrideTargetNode.getPlanNode(), shaclSailConnection, this.getPath().getQuery("?a", "?c", null), false), "");
            LoggingNode groupByCount = new LoggingNode(new GroupByCount(bulkedExternalInnerJoin), "");
            LoggingNode directTupleFromFilter = new LoggingNode(new MaxCountFilter(groupByCount, this.maxCount).getFalseNode(UnBufferedPlanNode.class), "");
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(directTupleFromFilter, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(new LoggingNode(directTupleFromFilter, ""), this);
        }
        if (this.maxCount == 1L && shaclSailConnection.stats.isBaseSailEmpty()) {
            String query = nodeShape.getQuery("?a", "?b", null);
            String query1 = this.getPath().getQuery("?a", "?d", null);
            String query2 = this.getPath().getQuery("?a", "?e", null);
            String negationQuery = query + "\n" + query1 + "\n" + query2 + "\nFILTER(?d != ?e)";
            PlanNode select = new Select(shaclSailConnection.getAddedStatements(), negationQuery, "?a");
            select = new ModifyTuple(select, a -> {
                a.line.add(SimpleValueFactory.getInstance().createLiteral(">= 2"));
                return a;
            });
            select = new AggregateIteratorTypeOverride(select);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(select, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(new LoggingNode(select, ""), this);
        }
        LoggingNode planAddedStatements = new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape, null), "");
        LoggingNode planAddedStatements1 = new LoggingNode(super.getPlanAddedStatements(shaclSailConnection, nodeShape, null), "");
        planAddedStatements1 = new LoggingNode(nodeShape.getTargetFilter(shaclSailConnection, planAddedStatements1), "");
        LoggingNode mergeNode = new LoggingNode(new UnionNode(planAddedStatements, planAddedStatements1), "");
        LoggingNode groupByCount1 = new LoggingNode(new GroupByCount(mergeNode), "");
        MaxCountFilter maxCountFilter = new MaxCountFilter(groupByCount1, this.maxCount);
        PlanNode validValues = maxCountFilter.getTrueNode(BufferedPlanNode.class);
        PlanNode invalidValues = maxCountFilter.getFalseNode(BufferedPlanNode.class);
        if (!shaclSailConnection.stats.isBaseSailEmpty()) {
            LoggingNode trimmed = new LoggingNode(new TrimTuple(validValues, 0, 1), "");
            LoggingNode unique = new LoggingNode(new Unique(trimmed), "");
            LoggingNode bulkedExternalInnerJoin = new LoggingNode(new BulkedExternalInnerJoin(unique, shaclSailConnection, this.getPath().getQuery("?a", "?c", null), true), "");
            LoggingNode groupByCount = new LoggingNode(new GroupByCount(bulkedExternalInnerJoin), "");
            PlanNode directTupleFromFilter = new MaxCountFilter(groupByCount, this.maxCount).getFalseNode(UnBufferedPlanNode.class);
            mergeNode1 = new UnionNode(new LoggingNode(directTupleFromFilter, ""), new LoggingNode(invalidValues, ""));
        } else {
            mergeNode1 = invalidValues;
        }
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(mergeNode1, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(new LoggingNode(mergeNode1, ""), this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.MaxCountConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MaxCountPropertyShape that = (MaxCountPropertyShape)o;
        return this.maxCount == that.maxCount;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxCount);
    }

    public String toString() {
        return "MaxCountPropertyShape{maxCount=" + this.maxCount + ", path=" + this.getPath() + '}';
    }
}

