/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.StandardisedPlanHelper;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.MaxLengthFilter;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxLengthPropertyShape
extends PathPropertyShape {
    private final long maxLength;
    private static final Logger logger = LoggerFactory.getLogger(MaxLengthPropertyShape.class);

    MaxLengthPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Long maxLength) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.maxLength = maxLength;
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNodeProvider overrideTargetNode) {
        if (this.deactivated) {
            return null;
        }
        PlanNode invalidValues = StandardisedPlanHelper.getGenericSingleObjectPlan(shaclSailConnection, nodeShape, parent -> new MaxLengthFilter(parent, this.maxLength), this, overrideTargetNode);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(invalidValues, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(invalidValues, this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.MaxLengthConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MaxLengthPropertyShape that = (MaxLengthPropertyShape)o;
        return this.maxLength == that.maxLength;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxLength);
    }

    public String toString() {
        return "MaxLengthPropertyShape{maxLength=" + this.maxLength + ", path=" + this.getPath() + '}';
    }
}

